/**********************************************************************
	Copyright (c) 1997 - 2000 Immersion Corporation

	Permission to use, copy, modify, distribute, and sell this
	software and its documentation may be granted without fee;
	interested parties are encouraged to request permission from
		Immersion Corporation
		801 Fox Lane
		San Jose, CA 95131
		408-467-1900

	IMMERSION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
	INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
	IN NO EVENT SHALL IMMERSION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
	LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
	NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
	CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

  FILE:		ImmBaseTypes.h

  PURPOSE:	Base Types for Feelit API Foundation Classes

  STARTED:	10/29/97

  NOTES/REVISIONS:
     3/2/99 jrm (Jeff Mallett): Force-->Feel renaming

**********************************************************************/


#if !defined(AFX_IMMBASETYPES_H__135B88C4_4175_11D1_B049_0020AF30269A__INCLUDED_)
#define AFX_IMMBASETYPES_H__135B88C4_4175_11D1_B049_0020AF30269A__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

//#include <windows.h>
#include "FeelitApi.h"

// Version 0x0100 -- IFC10
// Version 0x0101 -- IFC10p Special release: contains CImmProject::DestroyEffect
// Version 0x0110 -- IFC21 (and IFC20?)
#ifndef IFC_VERSION
 #define IFC_VERSION         0x0110
#endif

//#if (IFC_VERSION >= 0x0101)
 // This means that a user can call delete on a CImmCompoundEffect
 // object that was allocated through a CImmProject::CreateEffect()
 // and all will be well.
// #define PROTECT_AGAINST_DELETION
//#endif

#if (IFC_VERSION >= 0x0110)
 #define IFC_START_DELAY
 #define IFC_EFFECT_CACHING
#endif

//	Add define for DirectInput Device emulating FEELit Device
#define FEELIT_DEVICETYPE_DIRECTINPUT	3


//================================================================
// TYPE WRAPPERS
//================================================================

//
// IMM --> FEELIT Wrappers
//
#define IMM_VERSION			FEELIT_VERSION

#define IMM_DEVICETYPE_DEVICE		FEELIT_DEVICETYPE_DEVICE
#define IMM_DEVICETYPE_MOUSE		FEELIT_DEVICETYPE_MOUSE
#define IMM_DEVICETYPE_HID			FEELIT_DEVICETYPE_HID 
#define IMM_DEVICETYPE_DIRECTINPUT	FEELIT_DEVICETYPE_DIRECTINPUT

#define IMM_EFFECT		FEELIT_EFFECT
#define LPIMM_EFFECT	LPFEELIT_EFFECT
#define LPCIMM_EFFECT	LPCFEELIT_EFFECT

#define IMM_CONDITION     FEELIT_CONDITION
#define LPIMM_CONDITION   LPFEELIT_CONDITION
#define LPCIMM_CONDITION  LPCFEELIT_CONDITION

#define IMM_CONSTANTFORCE     FEELIT_CONSTANTFORCE
#define LPIMM_CONSTANTFORCE   LPFEELIT_CONSTANTFORCE
#define LPCIMM_CONSTANTFORCE  LPCFEELIT_CONSTANTFORCE

#define IMM_ELLIPSE		   FEELIT_ELLIPSE
#define LPIMM_ELLIPSE	   LPFEELIT_ELLIPSE
#define LPCIMM_ELLIPSE	   LPCFEELIT_ELLIPSE

#define IMM_ENCLOSURE     FEELIT_ENCLOSURE
#define LPIMM_ENCLOSURE   LPFEELIT_ENCLOSURE
#define LPCIMM_ENCLOSURE  LPCFEELIT_ENCLOSURE

#define IMM_PERIODIC      FEELIT_PERIODIC
#define LPIMM_PERIODIC    LPFEELIT_PERIODIC
#define LPCIMM_PERIODIC   LPCFEELIT_PERIODIC

#define IMM_RAMPFORCE     FEELIT_RAMPFORCE
#define LPIMM_RAMPFORCE   LPFEELIT_RAMPFORCE
#define LPCIMM_RAMPFORCE  LPCFEELIT_RAMPFORCE

#define IMM_TEXTURE       FEELIT_TEXTURE
#define LPIMM_TEXTURE     LPFEELIT_TEXTURE
#define LPCIMM_TEXTURE    LPCFEELIT_TEXTURE

#define IMM_ENVELOPE      FEELIT_ENVELOPE
#define LPIMM_ENVELOPE    LPFEELIT_ENVELOPE
#define LPCIMM_ENVELOPE   LPCFEELIT_ENVELOPE

#define LPIIMM_API        LPIFEELIT
#define LPIIMM_EFFECT     LPIFEELIT_EFFECT
#define LPIIMM_DEVICE     LPIFEELIT_DEVICE

#define IMM_CUSTOMFORCE     FEELIT_CUSTOMFORCE
#define LPIMM_CUSTOMFORCE   LPFEELIT_CUSTOMFORCE
#define LPCIMM_CUSTOMFORCE  LPCFEELIT_CUSTOMFORCE

#define LPIMM_ENUMDEVICESCALLBACK	LPFEELIT_ENUMDEVICESCALLBACK

/* Effect Types */
#define IMM_EFFECTTYPE_ALL	FEELIT_FEFFECTTYPE_ALL					

#define IMM_EFFECTTYPE_CONSTANTFORCE	FEELIT_FEFFECTTYPE_CONSTANTFORCE		
#define IMM_EFFECTTYPE_RAMPFORCE		FEELIT_FEFFECTTYPE_RAMPFORCE		
#define IMM_EFFECTTYPE_PERIODIC			FEELIT_FEFFECTTYPE_PERIODIC		
#define IMM_EFFECTTYPE_CONDITION		FEELIT_FEFFECTTYPE_CONDITION	
#define IMM_EFFECTTYPE_ENCLOSURE		FEELIT_FEFFECTTYPE_ENCLOSURE	
#define IMM_EFFECTTYPE_ELLIPSE			FEELIT_FEFFECTTYPE_ELLIPSE	
#define IMM_EFFECTTYPE_TEXTURE			FEELIT_FEFFECTTYPE_TEXTURE		
#define IMM_EFFECTTYPE_COMPOUND			0x00000008		
#define IMM_EFFECTTYPE_CUSTOMFORCE		FEELIT_FEFFECTTYPE_CUSTOMFORCE		
#define IMM_EFFECTTYPE_HARDWARE			FEELIT_FEFFECTTYPE_HARDWARE		

#define IMM_EFFECTTYPE_FFATTACK				FEELIT_FEFFECTTYPE_FFATTACK	
#define IMM_EFFECTTYPE_FFFADE				FEELIT_FEFFECTTYPE_FFFADE		
#define IMM_EFFECTTYPE_SATURATION			FEELIT_FEFFECTTYPE_SATURATION	
#define IMM_EFFECTTYPE_POSNEGCOEFFICIENTS	FEELIT_FEFFECTTYPE_POSNEGCOEFFICIENTS
#define IMM_EFFECTTYPE_POSNEGSATURATION		FEELIT_FEFFECTTYPE_POSNEGSATURATION	
#define IMM_EFFECTTYPE_DEADBAND				FEELIT_FEFFECTTYPE_DEADBAND			

/* Units */
#define IMM_DEGREES			FEELIT_DEGREES        
#define IMM_FFNOMINALMAX	FEELIT_FFNOMINALMAX     
#define IMM_SECONDS			FEELIT_SECONDS   

/* Start Flags */
#define IMM_START_SOLO			FEELIT_FSTART_SOLO             
#define IMM_START_NODOWNLOAD	FEELIT_FSTART_NODOWNLOAD          

/* Status Flags */
#define IMM_STATUS_PLAYING		FEELIT_FSTATUS_PLAYING         
#define IMM_STATUS_EMULATED		FEELIT_FSTATUS_EMULATED            

/* Stiffness Mask Flags */
#define IMM_STIFF_NONE				FEELIT_FSTIFF_NONE			
#define IMM_STIFF_OUTERLEFTWALL		FEELIT_FSTIFF_OUTERLEFTWALL	
#define IMM_STIFF_INNERLEFTWALL		FEELIT_FSTIFF_INNERLEFTWALL	
#define IMM_STIFF_INNERRIGHTWALL	FEELIT_FSTIFF_INNERRIGHTWALL	
#define IMM_STIFF_OUTERRIGHTWALL	FEELIT_FSTIFF_OUTERRIGHTWALL
#define IMM_STIFF_OUTERTOPWALL		FEELIT_FSTIFF_OUTERTOPWALL
#define IMM_STIFF_INNERTOPWALL		FEELIT_FSTIFF_INNERTOPWALL	
#define IMM_STIFF_INNERBOTTOMWALL	FEELIT_FSTIFF_INNERBOTTOMWALL
#define IMM_STIFF_OUTERBOTTOMWALL	FEELIT_FSTIFF_OUTERBOTTOMWALL	
#define IMM_STIFF_OUTERANYWALL		FEELIT_FSTIFF_OUTERANYWALL
#define IMM_STIFF_INBOUNDANYWALL	FEELIT_FSTIFF_INBOUNDANYWALL
#define IMM_STIFF_INNERANYWALL		FEELIT_FSTIFF_INNERANYWALL
#define IMM_STIFF_OUTBOUNDANYWALL	FEELIT_FSTIFF_OUTBOUNDANYWALL
#define IMM_STIFF_ANYWALL			FEELIT_FSTIFF_ANYWALL

/* Clipping Mask Flags */
#define IMM_CLIP_NONE				FEELIT_FCLIP_NONE		
#define IMM_CLIP_OUTERLEFTWALL		FEELIT_FCLIP_OUTERLEFTWALL
#define IMM_CLIP_INNERLEFTWALL		FEELIT_FCLIP_INNERLEFTWALL
#define IMM_CLIP_INNERRIGHTWALL		FEELIT_FCLIP_INNERRIGHTWALL
#define IMM_CLIP_OUTERRIGHTWALL		FEELIT_FCLIP_OUTERRIGHTWALL
#define IMM_CLIP_OUTERTOPWALL		FEELIT_FCLIP_OUTERTOPWALL
#define IMM_CLIP_INNERTOPWALL		FEELIT_FCLIP_INNERTOPWALL
#define IMM_CLIP_INNERBOTTOMWALL	FEELIT_FCLIP_INNERBOTTOMWALL
#define IMM_CLIP_OUTERBOTTOMWALL	FEELIT_FCLIP_OUTERBOTTOMWALL
#define IMM_CLIP_OUTERANYWALL		FEELIT_FCLIP_OUTERANYWALL
#define IMM_CLIP_INNERANYWALL		FEELIT_FCLIP_INNERANYWALL
#define IMM_CLIP_ANYWALL			FEELIT_FCLIP_ANYWALL

/* Device capabilities Stuct */
#define IMM_DEVCAPS		FEELIT_DEVCAPS
#define LPIMM_DEVCAPS	LPFEELIT_DEVCAPS
#define LPCIMM_DEVCAPS	LPCFEELIT_DEVCAPS

/* Device capabilities flags */
#define IMM_DEVCAPS_ATTACHED			FEELIT_FDEVCAPS_ATTACHED
#define IMM_DEVCAPS_POLLEDDEVICE		FEELIT_FDEVCAPS_POLLEDDEVICE
#define IMM_DEVCAPS_EMULATED			FEELIT_FDEVCAPS_EMULATED
#define IMM_DEVCAPS_POLLEDDATAFORMAT	FEELIT_FDEVCAPS_POLLEDDATAFORMAT
#define IMM_DEVCAPS_FORCEFEEDBACK		FEELIT_FDEVCAPS_FORCEFEEDBACK
#define IMM_DEVCAPS_FFATTACK			FEELIT_FDEVCAPS_FFATTACK
#define IMM_DEVCAPS_FFFADE				FEELIT_FDEVCAPS_FFFADE
#define IMM_DEVCAPS_SATURATION			FEELIT_FDEVCAPS_SATURATION
#define IMM_DEVCAPS_POSNEGCOEFFICIENTS	FEELIT_FDEVCAPS_POSNEGCOEFFICIENTS
#define IMM_DEVCAPS_POSNEGSATURATION	FEELIT_FDEVCAPS_POSNEGSATURATION
#define IMM_DEVCAPS_DEADBAND			FEELIT_FDEVCAPS_DEADBAND

#define LPIMM_DEVICEINSTANCE              LPFEELIT_DEVICEINSTANCE       
#define LPCIMM_DEVICEOBJECTINSTANCE       LPCFEELIT_DEVICEOBJECTINSTANCE
#define LPCIMM_EFFECTINFO                 LPCFEELIT_EFFECTINFO          

#define IMM_PARAM_DURATION               FEELIT_FPARAM_DURATION             
#define IMM_PARAM_SAMPLEPERIOD           FEELIT_FPARAM_SAMPLEPERIOD         
#define IMM_PARAM_GAIN                   FEELIT_FPARAM_GAIN                 
#define IMM_PARAM_TRIGGERBUTTON          FEELIT_FPARAM_TRIGGERBUTTON        
#define IMM_PARAM_TRIGGERREPEATINTERVAL  FEELIT_FPARAM_TRIGGERREPEATINTERVAL
#define IMM_PARAM_AXES                   FEELIT_FPARAM_AXES                 
#define IMM_PARAM_DIRECTION              FEELIT_FPARAM_DIRECTION            
#define IMM_PARAM_ENVELOPE               FEELIT_FPARAM_ENVELOPE             
#define IMM_PARAM_TYPESPECIFICPARAMS     FEELIT_FPARAM_TYPESPECIFICPARAMS  
#define IMM_PARAM_STARTDELAY             FEELIT_FPARAM_STARTDELAY 
#define IMM_PARAM_ALLPARAMS              FEELIT_FPARAM_ALLPARAMS            
#define IMM_PARAM_START                  FEELIT_FPARAM_START                
#define IMM_PARAM_NORESTART              FEELIT_FPARAM_NORESTART            
#define IMM_PARAM_NODOWNLOAD             FEELIT_FPARAM_NODOWNLOAD           

#define IMM_EFFECT_OBJECTIDS             FEELIT_FEFFECT_OBJECTIDS      
#define IMM_EFFECT_OBJECTOFFSETS         FEELIT_FEFFECT_OBJECTOFFSETS  
#define IMM_EFFECT_CARTESIAN             FEELIT_FEFFECT_CARTESIAN      
#define IMM_EFFECT_POLAR                 FEELIT_FEFFECT_POLAR          
#define IMM_EFFECT_SPHERICAL             FEELIT_FEFFECT_SPHERICAL      

#define IMM_PARAM_NOTRIGGER              FEELIT_PARAM_NOTRIGGER

/* Offsets */
#define IMM_MOUSEOFFSET_XAXIS   FEELIT_MOUSEOFFSET_XAXIS
#define IMM_MOUSEOFFSET_YAXIS   FEELIT_MOUSEOFFSET_YAXIS
#define IMM_MOUSEOFFSET_ZAXIS   FEELIT_MOUSEOFFSET_ZAXIS
#define IMM_MOUSEOFFSET_XFORCE	FEELIT_MOUSEOFFSET_XFORCE
#define IMM_MOUSEOFFSET_YFORCE	FEELIT_MOUSEOFFSET_YFORCE
#define IMM_MOUSEOFFSET_ZFORCE	FEELIT_MOUSEOFFSET_ZFORCE
#define IMM_MOUSEOFFSET_BUTTON0	FEELIT_MOUSEOFFSET_BUTTON0
#define IMM_MOUSEOFFSET_BUTTON1	FEELIT_MOUSEOFFSET_BUTTON1
#define IMM_MOUSEOFFSET_BUTTON2	FEELIT_MOUSEOFFSET_BUTTON2
#define IMM_MOUSEOFFSET_BUTTON3	FEELIT_MOUSEOFFSET_BUTTON3

/* Cooperative Level Flags */
#define IMM_COOPLEVEL_FOREGROUND	FEELIT_FCOOPLEVEL_FOREGROUND
#define IMM_COOPLEVEL_BACKGROUND	FEELIT_FCOOPLEVEL_BACKGROUND

/* Enumeration codes */
#define IMM_ENUM_STOP		FEELIT_ENUM_STOP
#define IMM_ENUM_CONTINUE	FEELIT_ENUM_CONTINUE

#define IMM_ENUMDEV_ALLDEVICES		FEELIT_FENUMDEV_ALLDEVICES
#define IMM_ENUMDEV_ATTACHEDONLY	FEELIT_FENUMDEV_ATTACHEDONLY
#define IMM_ENUMDEV_FORCEFEEDBACK	FEELIT_FENUMDEV_FORCEFEEDBACK

/* Return values */
#define IMM_RESULT_OK						FEELIT_RESULT_OK 
#define IMM_RESULT_NOTATTACHED				FEELIT_RESULT_NOTATTACHED
#define IMM_RESULT_BUFFEROVERFLOW			FEELIT_RESULT_BUFFEROVERFLOW
#define IMM_RESULT_PROPNOEFFECT				FEELIT_RESULT_PROPNOEFFECT
#define IMM_RESULT_NOEFFECT					FEELIT_RESULT_NOEFFECT
#define IMM_RESULT_POLLEDDEVICE				FEELIT_RESULT_POLLEDDEVICE
#define IMM_RESULT_DOWNLOADSKIPPED			FEELIT_RESULT_DOWNLOADSKIPPED
#define IMM_RESULT_EFFECTRESTARTED			FEELIT_RESULT_EFFECTRESTARTED
#define IMM_RESULT_TRUNCATED				FEELIT_RESULT_TRUNCATED
#define IMM_RESULT_TRUNCATEDANDRESTARTED	FEELIT_RESULT_TRUNCATEDANDRESTARTED
#define IMM_ERROR_OLDFEELITVERSION			FEELIT_ERROR_OLDFEELITVERSION
#define IMM_ERROR_BETAFEELITVERSION			FEELIT_ERROR_BETAFEELITVERSION
#define IMM_ERROR_BADDRIVERVER				FEELIT_ERROR_BADDRIVERVER
#define IMM_ERROR_DEVICENOTREG				FEELIT_ERROR_DEVICENOTREG
#define IMM_ERROR_NOTFOUND					FEELIT_ERROR_NOTFOUND
#define IMM_ERROR_OBJECTNOTFOUND			FEELIT_ERROR_OBJECTNOTFOUND
#define IMM_ERROR_INVALIDPARAM				FEELIT_ERROR_INVALIDPARAM
#define IMM_ERROR_NOINTERFACE				FEELIT_ERROR_NOINTERFACE
#define IMM_ERROR_GENERIC					FEELIT_ERROR_GENERIC
#define IMM_ERROR_OUTOFMEMORY				FEELIT_ERROR_OUTOFMEMORY
#define IMM_ERROR_UNSUPPORTED				FEELIT_ERROR_UNSUPPORTED
#define IMM_ERROR_NOTINITIALIZED			FEELIT_ERROR_NOTINITIALIZED
#define IMM_ERROR_ALREADYINITIALIZED		FEELIT_ERROR_ALREADYINITIALIZED
#define IMM_ERROR_NOAGGREGATION				FEELIT_ERROR_NOAGGREGATION
#define IMM_ERROR_OTHERAPPHASPRIO			FEELIT_ERROR_OTHERAPPHASPRIO
#define IMM_ERROR_INPUTLOST					FEELIT_ERROR_INPUTLOST
#define IMM_ERROR_ACQUIRED					FEELIT_ERROR_ACQUIRED				
#define IMM_ERROR_NOTACQUIRED				FEELIT_ERROR_NOTACQUIRED
#define IMM_ERROR_READONLY					FEELIT_ERROR_READONLY
#define IMM_ERROR_HANDLEEXISTS				FEELIT_ERROR_HANDLEEXISTS
#define IMM_ERROR_INSUFFICIENTPRIVS			FEELIT_ERROR_INSUFFICIENTPRIVS
#define IMM_ERROR_DEVICEFULL				FEELIT_ERROR_DEVICEFULL
#define IMM_ERROR_MOREDATA					FEELIT_ERROR_MOREDATA
#define IMM_ERROR_NOTDOWNLOADED				FEELIT_ERROR_NOTDOWNLOADED
#define IMM_ERROR_HASEFFECTS				FEELIT_ERROR_HASEFFECTS
#define IMM_ERROR_NOTEXCLUSIVEACQUIRED		FEELIT_ERROR_NOTEXCLUSIVEACQUIRED
#define IMM_ERROR_INCOMPLETEEFFECT			FEELIT_ERROR_INCOMPLETEEFFECT
#define IMM_ERROR_NOTBUFFERED				FEELIT_ERROR_NOTBUFFERED
#define IMM_ERROR_EFFECTPLAYING				FEELIT_ERROR_EFFECTPLAYING
#define	IMM_ERROR_INTERNAL					FEELIT_ERROR_INTERNAL
#define IMM_ERROR_INACTIVE					FEELIT_ERROR_INACTIVE

//================================================================
// GUID WRAPPERS
//================================================================

//
// Immersion --> Feelit Wrappers
//
#define GUID_Imm_ConstantForce	GUID_Feelit_ConstantForce
#define GUID_Imm_RampForce		GUID_Feelit_RampForce
#define GUID_Imm_Square			GUID_Feelit_Square
#define GUID_Imm_Sine			GUID_Feelit_Sine
#define GUID_Imm_Triangle		GUID_Feelit_Triangle
#define GUID_Imm_SawtoothUp		GUID_Feelit_SawtoothUp
#define GUID_Imm_SawtoothDown	GUID_Feelit_SawtoothDown
#define GUID_Imm_Spring			GUID_Feelit_Spring
#define GUID_Imm_DeviceSpring	GUID_Feelit_DeviceSpring
#define GUID_Imm_Damper			GUID_Feelit_Damper
#define GUID_Imm_Inertia		GUID_Feelit_Inertia
#define GUID_Imm_Friction		GUID_Feelit_Friction
#define GUID_Imm_Texture		GUID_Feelit_Texture
#define GUID_Imm_Grid			GUID_Feelit_Grid
#define GUID_Imm_Enclosure		GUID_Feelit_Enclosure
#define GUID_Imm_Ellipse		GUID_Feelit_Ellipse
#define GUID_Imm_CustomForce	GUID_Feelit_CustomForce

#define CLSID_Imm			CLSID_Feelit
#define CLSID_ImmDevice		CLSID_FeelitDevice
#define GUID_Imm_XAxis		GUID_Feelit_XAxis
#define GUID_Imm_YAxis		GUID_Feelit_YAxis
#define GUID_Imm_ZAxis		GUID_Feelit_ZAxis
#define GUID_Imm_RxAxis		GUID_Feelit_RxAxis
#define GUID_Imm_RyAxis		GUID_Feelit_RyAxis
#define GUID_Imm_RzAxis		GUID_Feelit_RzAxis
#define GUID_Imm_Slider		GUID_Feelit_Slider
#define GUID_Imm_Button		GUID_Feelit_Button
#define GUID_Imm_Key		GUID_Feelit_Key
#define GUID_Imm_POV		GUID_Feelit_POV
#define GUID_Imm_Unknown	GUID_Feelit_Unknown
#define GUID_Imm_Mouse		GUID_Feelit_Mouse


#endif // !defined(AFX_IMMBASETYPES_H__135B88C4_4175_11D1_B049_0020AF30269A__INCLUDED_)

















