/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.init;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.block.BlockBRGenericFluid;
import erogenousbeef.bigreactors.common.block.BlockBRMetal;
import erogenousbeef.bigreactors.common.block.BlockBROre;
import erogenousbeef.bigreactors.common.item.ItemBRMetal;
import erogenousbeef.bigreactors.common.item.ItemMineral;
import erogenousbeef.bigreactors.common.item.ItemTieredComponent;
import erogenousbeef.bigreactors.common.item.ItemWrench;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import erogenousbeef.bigreactors.common.multiblock.PowerSystem;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMultiblockCasing;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMultiblockComputerPort;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMultiblockController;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMultiblockGlass;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMultiblockIOPort;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMultiblockPowerTap;
import erogenousbeef.bigreactors.common.multiblock.block.BlockReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.block.BlockReactorFuelRod;
import erogenousbeef.bigreactors.common.multiblock.block.BlockReactorRedNetPort;
import erogenousbeef.bigreactors.common.multiblock.block.BlockReactorRedstonePort;
import erogenousbeef.bigreactors.common.multiblock.block.BlockTurbineRotorBearing;
import erogenousbeef.bigreactors.common.multiblock.block.BlockTurbineRotorBlade;
import erogenousbeef.bigreactors.common.multiblock.block.BlockTurbineRotorShaft;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorAccessPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorComputerPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorController;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorCoolantPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorGlass;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPowerTapRedstoneFlux;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPowerTapTesla;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedNetPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedstonePort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineComputerPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineController;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineFluidPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartGlass;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePowerTapRedstoneFlux;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePowerTapTesla;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorBearing;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorBlade;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorShaft;
import erogenousbeef.bigreactors.common.multiblock.tileentity.creative.TileEntityReactorCreativeCoolantPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.creative.TileEntityTurbineCreativeSteamGenerator;
import erogenousbeef.bigreactors.init.BrBlocks;
import erogenousbeef.bigreactors.init.BrFluids;
import erogenousbeef.bigreactors.init.BrItems;
import erogenousbeef.bigreactors.init.flattening.BlockReplacer;
import erogenousbeef.bigreactors.init.flattening.ItemReplacer;
import erogenousbeef.bigreactors.init.flattening.TileEntityNameFixer;
import it.zerono.mods.zerocore.lib.config.ConfigHandler;
import it.zerono.mods.zerocore.lib.init.GameObjectsHandler;
import it.zerono.mods.zerocore.lib.init.fixer.IGameObjectDataWalker;
import it.zerono.mods.zerocore.util.OreDictionaryHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zero.temp.RecipeHelper2;

public class ObjectsHandler
extends GameObjectsHandler {
    private static final int DATA_VERSION = 1;
    private final BlockReplacer _blockReplacer = new BlockReplacer(1);
    private final ItemReplacer _itemReplacer = new ItemReplacer(1);
    private final TileEntityNameFixer _teFixer = new TileEntityNameFixer(1, "minecraft:bigreactors");

    public ObjectsHandler(ConfigHandler ... configs) {
        super(1, configs);
        this.addBlockRemapper(this._blockReplacer);
        this.addItemRemapper(this._itemReplacer);
    }

    protected void onRegisterBlocks(@Nonnull IForgeRegistry<Block> registry) {
        boolean regCreativeParts = BigReactors.CONFIG.registerCreativeMultiblockParts;
        BrFluids.initialize();
        registry.register((IForgeRegistryEntry)new BlockBROre("oreyellorite", "oreYellorite"));
        registry.register((IForgeRegistryEntry)new BlockBROre("oreanglesite", "oreAnglesite"));
        registry.register((IForgeRegistryEntry)new BlockBROre("orebenitoite", "oreBenitoite"));
        registry.register((IForgeRegistryEntry)new BlockBRMetal("blockyellorium", "blockYellorium"));
        registry.register((IForgeRegistryEntry)new BlockBRMetal("blockcyanite", "blockCyanite"));
        registry.register((IForgeRegistryEntry)new BlockBRMetal("blockgraphite", "blockGraphite"));
        registry.register((IForgeRegistryEntry)new BlockBRMetal("blockblutonium", "blockBlutonium"));
        registry.register((IForgeRegistryEntry)new BlockBRMetal("blockludicrite", "blockLudicrite"));
        registry.register((IForgeRegistryEntry)new BlockBRMetal("blocksteel", "blockSteel"));
        registry.register((IForgeRegistryEntry)new BlockMultiblockCasing(PartType.ReactorCasing, "reactorcasing"));
        registry.register((IForgeRegistryEntry)new BlockMultiblockGlass(PartType.ReactorGlass, "reactorglass"));
        registry.register((IForgeRegistryEntry)new BlockMultiblockController(PartType.ReactorController, "reactorcontroller"));
        registry.register((IForgeRegistryEntry)new BlockMultiblockPowerTap(PartType.ReactorPowerTap, "reactorpowertaprf", PowerSystem.RedstoneFlux));
        registry.register((IForgeRegistryEntry)new BlockMultiblockPowerTap(PartType.ReactorPowerTap, "reactorpowertaptesla", PowerSystem.Tesla));
        registry.register((IForgeRegistryEntry)new BlockMultiblockIOPort(PartType.ReactorAccessPort, "reactoraccessport"));
        registry.register((IForgeRegistryEntry)new BlockMultiblockIOPort(PartType.ReactorCoolantPort, "reactorcoolantport"));
        registry.register((IForgeRegistryEntry)new BlockReactorControlRod("reactorcontrolrod"));
        registry.register((IForgeRegistryEntry)new BlockReactorRedNetPort("reactorrednetport"));
        registry.register((IForgeRegistryEntry)new BlockMultiblockComputerPort(PartType.ReactorComputerPort, "reactorcomputerport"));
        registry.register((IForgeRegistryEntry)new BlockReactorRedstonePort("reactorredstoneport"));
        registry.register((IForgeRegistryEntry)new BlockReactorFuelRod("reactorfuelrod"));
        if (regCreativeParts) {
            registry.register((IForgeRegistryEntry)new BlockMultiblockIOPort(PartType.ReactorCreativeCoolantPort, "reactorcreativecoolantport"));
        }
        registry.register((IForgeRegistryEntry)new BlockMultiblockGlass(PartType.TurbineGlass, "turbineglass"));
        registry.register((IForgeRegistryEntry)new BlockMultiblockCasing(PartType.TurbineHousing, "turbinehousing"));
        registry.register((IForgeRegistryEntry)new BlockMultiblockController(PartType.TurbineController, "turbinecontroller"));
        registry.register((IForgeRegistryEntry)new BlockMultiblockPowerTap(PartType.TurbinePowerPort, "turbinepowertaprf", PowerSystem.RedstoneFlux));
        registry.register((IForgeRegistryEntry)new BlockMultiblockPowerTap(PartType.TurbinePowerPort, "turbinepowertaptesla", PowerSystem.Tesla));
        registry.register((IForgeRegistryEntry)new BlockMultiblockComputerPort(PartType.TurbineComputerPort, "turbinecomputerport"));
        registry.register((IForgeRegistryEntry)new BlockMultiblockIOPort(PartType.TurbineFluidPort, "turbinefluidport"));
        registry.register((IForgeRegistryEntry)new BlockTurbineRotorBearing("turbinebearing"));
        registry.register((IForgeRegistryEntry)new BlockTurbineRotorShaft("turbinerotorshaft"));
        registry.register((IForgeRegistryEntry)new BlockTurbineRotorBlade("turbinerotorblade"));
        if (regCreativeParts) {
            registry.register((IForgeRegistryEntry)new BlockMultiblockIOPort(PartType.TurbineCreativeSteamGenerator, "turbinecreativesteamgenerator"));
        }
        registry.register((IForgeRegistryEntry)new BlockBRGenericFluid(BrFluids.fluidYellorium, "yellorium", (Material)new MaterialLiquid(MapColor.field_151673_t)));
        registry.register((IForgeRegistryEntry)new BlockBRGenericFluid(BrFluids.fluidCyanite, "cyanite", Material.field_151587_i));
    }

    protected void registerTileEntity(@Nonnull Class<? extends TileEntity> tileEntityClass, @Nullable IGameObjectDataWalker walker) {
        super.registerTileEntity(tileEntityClass, walker);
        String name = tileEntityClass.getSimpleName().toLowerCase(Locale.ROOT);
        this._teFixer.addReplacement("minecraft:bigreactors" + name, new ResourceLocation(this.getModId(), name));
    }

    protected void onRegisterTileEntities() {
        this.registerTileEntity(TileEntityReactorPart.class);
        this.registerTileEntity(TileEntityReactorGlass.class);
        this.registerTileEntity(TileEntityReactorController.class);
        this.registerTileEntity(TileEntityReactorPowerTapRedstoneFlux.class);
        this.registerTileEntity(TileEntityReactorPowerTapTesla.class);
        this.registerTileEntity(TileEntityReactorAccessPort.class, TileEntityReactorAccessPort.getObjectDataWalker());
        this.registerTileEntity(TileEntityReactorFuelRod.class);
        this.registerTileEntity(TileEntityReactorControlRod.class);
        this.registerTileEntity(TileEntityReactorRedstonePort.class);
        this.registerTileEntity(TileEntityReactorComputerPort.class);
        this.registerTileEntity(TileEntityReactorCoolantPort.class);
        this.registerTileEntity(TileEntityReactorCreativeCoolantPort.class);
        this.registerTileEntity(TileEntityReactorRedNetPort.class);
        this.registerTileEntity(TileEntityTurbinePart.class);
        this.registerTileEntity(TileEntityTurbinePowerTapRedstoneFlux.class);
        this.registerTileEntity(TileEntityTurbinePowerTapTesla.class);
        this.registerTileEntity(TileEntityTurbineFluidPort.class);
        this.registerTileEntity(TileEntityTurbinePartGlass.class);
        this.registerTileEntity(TileEntityTurbineRotorBearing.class);
        this.registerTileEntity(TileEntityTurbineRotorShaft.class);
        this.registerTileEntity(TileEntityTurbineRotorBlade.class);
        this.registerTileEntity(TileEntityTurbineCreativeSteamGenerator.class);
        this.registerTileEntity(TileEntityTurbineComputerPort.class);
        this.registerTileEntity(TileEntityTurbineController.class);
    }

    protected void onRegisterItems(@Nonnull IForgeRegistry<Item> registry) {
        registry.register((IForgeRegistryEntry)new ItemBRMetal("ingotyellorium", "ingotYellorium"));
        registry.register((IForgeRegistryEntry)new ItemBRMetal("ingotcyanite", "ingotCyanite"));
        registry.register((IForgeRegistryEntry)new ItemBRMetal("ingotgraphite", "ingotGraphite"));
        registry.register((IForgeRegistryEntry)new ItemBRMetal("ingotblutonium", "ingotBlutonium"));
        registry.register((IForgeRegistryEntry)new ItemBRMetal("ingotludicrite", "ingotLudicrite"));
        registry.register((IForgeRegistryEntry)new ItemBRMetal("ingotsteel", "ingotSteel"));
        registry.register((IForgeRegistryEntry)new ItemBRMetal("dustyellorium", "dustYellorium"));
        registry.register((IForgeRegistryEntry)new ItemBRMetal("dustcyanite", "dustCyanite"));
        registry.register((IForgeRegistryEntry)new ItemBRMetal("dustgraphite", "dustGraphite"));
        registry.register((IForgeRegistryEntry)new ItemBRMetal("dustblutonium", "dustBlutonium"));
        registry.register((IForgeRegistryEntry)new ItemBRMetal("dustludicrite", "dustLudicrite"));
        registry.register((IForgeRegistryEntry)new ItemBRMetal("duststeel", "dustSteel"));
        registry.register((IForgeRegistryEntry)new ItemMineral("mineralanglesite"));
        registry.register((IForgeRegistryEntry)new ItemMineral("mineralbenitoite"));
        registry.register((IForgeRegistryEntry)new ItemTieredComponent("reactorcasingcores"));
        registry.register((IForgeRegistryEntry)new ItemTieredComponent("turbinehousingcores"));
        registry.register((IForgeRegistryEntry)new ItemWrench("wrench"));
    }

    protected void onRegisterOreDictionaryEntries() {
        OreDictionary.registerOre((String)"oreYellorium", (ItemStack)BrBlocks.oreYellorite.createItemStack());
        if (BigReactors.CONFIG.registerYelloriumAsUranium) {
            OreDictionary.registerOre((String)"ingotUranium", (ItemStack)((ItemBRMetal)this.getTrackedItem("ingotyellorium")).createItemStack());
            OreDictionary.registerOre((String)"dustUranium", (ItemStack)((ItemBRMetal)this.getTrackedItem("dustyellorium")).createItemStack());
            OreDictionary.registerOre((String)"ingotPlutonium", (ItemStack)((ItemBRMetal)this.getTrackedItem("ingotblutonium")).createItemStack());
            OreDictionary.registerOre((String)"dustPlutonium", (ItemStack)((ItemBRMetal)this.getTrackedItem("dustblutonium")).createItemStack());
        }
        if (!OreDictionaryHelper.doesOreNameExist((String)"blockSnow")) {
            OreDictionary.registerOre((String)"blockSnow", (ItemStack)new ItemStack(Blocks.field_150433_aE, 1));
        }
        if (!OreDictionaryHelper.doesOreNameExist((String)"blockIce")) {
            OreDictionary.registerOre((String)"blockIce", (ItemStack)new ItemStack(Blocks.field_150432_aD, 1));
        }
    }

    protected void onRegisterRecipes(@Nonnull IForgeRegistry<IRecipe> registry) {
        ItemStack result;
        if (BigReactors.CONFIG.registerYelloriteSmeltToUranium) {
            result = OreDictionaryHelper.getOre((String)"ingotUranium");
            if (null == result) {
                BigReactors.getLogger().warn("Config value registerYelloriteSmeltToUranium is set to True, but there are no ores registered as ingotUranium in the ore dictionary! Falling back to using standard yellorium only.");
                result = OreDictionaryHelper.getOre((String)"ingotYellorium");
            }
        } else {
            result = OreDictionaryHelper.getOre((String)"ingotYellorium");
        }
        RecipeHelper2.addSmelting(BrBlocks.oreYellorite.createItemStack(), result, 0.5f);
        RecipeHelper2.addSmelting(BrItems.dustYellorium.createItemStack(), BrItems.ingotYellorium.createItemStack(), 0.0f);
        RecipeHelper2.addSmelting(BrItems.dustCyanite.createItemStack(), BrItems.ingotCyanite.createItemStack(), 0.0f);
        RecipeHelper2.addSmelting(BrItems.dustGraphite.createItemStack(), BrItems.ingotGraphite.createItemStack(), 0.0f);
        RecipeHelper2.addSmelting(BrItems.dustBlutonium.createItemStack(), BrItems.ingotBlutonium.createItemStack(), 0.0f);
        RecipeHelper2.addSmelting(BrItems.dustLudicrite.createItemStack(), BrItems.ingotLudicrite.createItemStack(), 0.0f);
        RecipeHelper2.addSmelting(BrItems.dustSteel.createItemStack(), BrItems.ingotSteel.createItemStack(), 0.0f);
        result = OreDictionaryHelper.getOre((String)"ingotGraphite");
        if (BigReactors.CONFIG.registerCoalForSmelting) {
            RecipeHelper2.addSmelting(new ItemStack(Items.field_151044_h, 1, 0), result, 1.0f);
        }
        if (BigReactors.CONFIG.registerCharcoalForSmelting) {
            RecipeHelper2.addSmelting(new ItemStack(Items.field_151044_h, 1, 1), result, 1.0f);
        }
    }

    public void onInit(FMLInitializationEvent event) {
        super.onInit(event);
        ModFixs fixs = FMLCommonHandler.instance().getDataFixer().init("bigreactors", 1);
        fixs.registerFix((IFixType)FixTypes.CHUNK, (IFixableData)this._blockReplacer);
        fixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)this._itemReplacer);
        fixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)this._teFixer);
        this.registerMissingBlocksReplacements();
        this.registerMissingItemsReplacements();
    }

    private void registerMissingBlocksReplacements() {
        ResourceLocation missingId = BigReactors.createResourceLocation("brore");
        this._blockReplacer.addReplacement(missingId, 0, (Block)BrBlocks.oreYellorite);
        this._blockReplacer.addReplacement(missingId, 1, (Block)BrBlocks.oreAnglesite);
        this._blockReplacer.addReplacement(missingId, 2, (Block)BrBlocks.oreBenitoite);
        missingId = BigReactors.createResourceLocation("blockmetals");
        this._blockReplacer.addReplacement(missingId, 0, (Block)BrBlocks.blockYellorium);
        this._blockReplacer.addReplacement(missingId, 1, (Block)BrBlocks.blockCyanite);
        this._blockReplacer.addReplacement(missingId, 2, (Block)BrBlocks.blockGraphite);
        this._blockReplacer.addReplacement(missingId, 3, (Block)BrBlocks.blockBlutonium);
        this._blockReplacer.addReplacement(missingId, 4, (Block)BrBlocks.blockLudicrite);
        this._blockReplacer.addReplacement(missingId, 5, (Block)BrBlocks.blockSteel);
    }

    private void registerMissingItemsReplacements() {
        ResourceLocation missingId = BigReactors.createResourceLocation("brore");
        this._itemReplacer.addReplacement(missingId, 0, Item.func_150898_a((Block)BrBlocks.oreYellorite));
        this._itemReplacer.addReplacement(missingId, 1, Item.func_150898_a((Block)BrBlocks.oreAnglesite));
        this._itemReplacer.addReplacement(missingId, 2, Item.func_150898_a((Block)BrBlocks.oreBenitoite));
        missingId = BigReactors.createResourceLocation("minerals");
        this._itemReplacer.addReplacement(missingId, 0, (Item)BrItems.mineralAnglesite);
        this._itemReplacer.addReplacement(missingId, 1, (Item)BrItems.mineralBenitoite);
        missingId = BigReactors.createResourceLocation("blockmetals");
        this._itemReplacer.addReplacement(missingId, 0, Item.func_150898_a((Block)BrBlocks.blockYellorium));
        this._itemReplacer.addReplacement(missingId, 1, Item.func_150898_a((Block)BrBlocks.blockCyanite));
        this._itemReplacer.addReplacement(missingId, 2, Item.func_150898_a((Block)BrBlocks.blockGraphite));
        this._itemReplacer.addReplacement(missingId, 3, Item.func_150898_a((Block)BrBlocks.blockBlutonium));
        this._itemReplacer.addReplacement(missingId, 4, Item.func_150898_a((Block)BrBlocks.blockLudicrite));
        this._itemReplacer.addReplacement(missingId, 5, Item.func_150898_a((Block)BrBlocks.blockSteel));
        missingId = BigReactors.createResourceLocation("ingotmetals");
        this._itemReplacer.addReplacement(missingId, 0, (Item)BrItems.ingotYellorium);
        this._itemReplacer.addReplacement(missingId, 1, (Item)BrItems.ingotCyanite);
        this._itemReplacer.addReplacement(missingId, 2, (Item)BrItems.ingotGraphite);
        this._itemReplacer.addReplacement(missingId, 3, (Item)BrItems.ingotBlutonium);
        this._itemReplacer.addReplacement(missingId, 4, (Item)BrItems.ingotLudicrite);
        this._itemReplacer.addReplacement(missingId, 5, (Item)BrItems.ingotSteel);
        missingId = BigReactors.createResourceLocation("dustmetals");
        this._itemReplacer.addReplacement(missingId, 0, (Item)BrItems.dustYellorium);
        this._itemReplacer.addReplacement(missingId, 1, (Item)BrItems.dustCyanite);
        this._itemReplacer.addReplacement(missingId, 2, (Item)BrItems.dustGraphite);
        this._itemReplacer.addReplacement(missingId, 3, (Item)BrItems.dustBlutonium);
        this._itemReplacer.addReplacement(missingId, 4, (Item)BrItems.dustLudicrite);
        this._itemReplacer.addReplacement(missingId, 5, (Item)BrItems.dustSteel);
    }
}

