/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.init.flattening;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import erogenousbeef.bigreactors.init.flattening.MissingRegistryEntryHandler;
import it.zerono.mods.zerocore.lib.init.IGameObjectMapper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GameObjectMapper<T extends IForgeRegistryEntry<T>>
implements IGameObjectMapper<T> {
    private final List<MissingRegistryEntryHandler<T>> _handlers = Lists.newArrayList();

    public void remap(@Nonnull ResourceLocation key, @Nonnull T replacement) {
        this.addHandler(MissingRegistryEntryHandler.remap(key, replacement));
    }

    public void ignore(@Nonnull ResourceLocation key) {
        this.addHandler(MissingRegistryEntryHandler.ignore(key));
    }

    public void warn(@Nonnull ResourceLocation key) {
        this.addHandler(MissingRegistryEntryHandler.warn(key));
    }

    public void fail(@Nonnull ResourceLocation key) {
        this.addHandler(MissingRegistryEntryHandler.fail(key));
    }

    public void linkObjectsMap(@Nonnull ImmutableMap<String, T> map) {
    }

    public void remap(@Nonnull RegistryEvent.MissingMappings.Mapping<T> mapping) {
        this.getHandlers().forEach(handler -> handler.remap(mapping));
    }

    protected void addHandler(MissingRegistryEntryHandler<T> handler) {
        this._handlers.add(handler);
    }

    @Nonnull
    protected List<MissingRegistryEntryHandler<T>> getHandlers() {
        return this._handlers;
    }
}

