/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.init.flattening;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import erogenousbeef.bigreactors.init.flattening.MissingRegistryEntryHandler;
import it.zerono.mods.zerocore.lib.init.IGameObjectMapper;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.event.RegistryEvent;

public class ItemReplacer
implements IFixableData,
IGameObjectMapper<Item> {
    private static final String ITEM_TAG_ID = "id";
    private static final String ITEM_TAG_DAMAGE = "Damage";
    private final int _dataVersion;
    private Map<String, MissingRegistryEntryHandler<Item>> _replacements;

    public ItemReplacer(int dataVersion) {
        this._dataVersion = dataVersion;
        this._replacements = Maps.newHashMap();
    }

    public void addReplacement(@Nonnull ResourceLocation oldItemId, @Nonnull IConverter converter) {
        this._replacements.put(oldItemId.toString(), new MissingItemSingleConverter(oldItemId, converter));
    }

    public void addReplacement(@Nonnull ResourceLocation oldItemId, int oldMetadata, @Nonnull Item newItem) {
        this.addReplacement(oldItemId, oldMetadata, newItem, 0);
    }

    public void addReplacement(@Nonnull ResourceLocation oldItemId, int oldMetadata, @Nonnull Item newItem, int newMetadata) {
        MissingRegistryEntryHandler entry = this._replacements.computeIfAbsent(oldItemId.toString(), k -> new MissingItemMultiConverter(oldItemId));
        if (entry instanceof MissingItemMultiConverter) {
            ((MissingItemMultiConverter)entry).addVariant((short)oldMetadata, itemNBT -> {
                if (itemNBT.func_74764_b(ITEM_TAG_DAMAGE) && itemNBT.func_74765_d(ITEM_TAG_DAMAGE) == oldMetadata) {
                    itemNBT.func_74778_a(ITEM_TAG_ID, newItem.getRegistryName().toString());
                    itemNBT.func_74777_a(ITEM_TAG_DAMAGE, (short)newMetadata);
                }
                return itemNBT;
            });
        }
    }

    public void linkObjectsMap(@Nonnull ImmutableMap<String, Item> map) {
    }

    public void remap(@Nonnull RegistryEvent.MissingMappings.Mapping<Item> mapping) {
        this._replacements.values().forEach(handler -> handler.remap(mapping));
    }

    public int func_188216_a() {
        return this._dataVersion;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        MissingRegistryEntryHandler<Item> entry;
        if (null != compound && compound.func_74764_b(ITEM_TAG_ID) && (entry = this._replacements.get(compound.func_74779_i(ITEM_TAG_ID))) instanceof IConverter) {
            return ((IConverter)((Object)entry)).convert(compound);
        }
        return compound;
    }

    private static class MissingItemMultiConverter
    extends MissingRegistryEntryHandler<Item>
    implements IConverter {
        private final Map<Short, IConverter> _converters = Maps.newHashMap();

        MissingItemMultiConverter(@Nonnull ResourceLocation oldObjectKey) {
            super(oldObjectKey, RegistryEvent.MissingMappings.Action.IGNORE, null);
        }

        void addVariant(short oldMetadata, @Nonnull IConverter converter) {
            this._converters.put(oldMetadata, converter);
        }

        @Override
        public NBTTagCompound convert(@Nonnull NBTTagCompound itemNBT) {
            IConverter converter;
            if (itemNBT.func_74764_b(ItemReplacer.ITEM_TAG_DAMAGE) && null != (converter = this._converters.get(itemNBT.func_74765_d(ItemReplacer.ITEM_TAG_DAMAGE)))) {
                return converter.convert(itemNBT);
            }
            return itemNBT;
        }
    }

    private static class MissingItemSingleConverter
    extends MissingRegistryEntryHandler<Item>
    implements IConverter {
        private final IConverter _converter;

        MissingItemSingleConverter(@Nonnull ResourceLocation oldObjectKey, @Nonnull IConverter converter) {
            super(oldObjectKey, RegistryEvent.MissingMappings.Action.IGNORE, null);
            this._converter = converter;
        }

        @Override
        public NBTTagCompound convert(@Nonnull NBTTagCompound itemNBT) {
            return this._converter.convert(itemNBT);
        }
    }

    @FunctionalInterface
    public static interface IConverter {
        public NBTTagCompound convert(@Nonnull NBTTagCompound var1);
    }
}

