/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.init.flattening;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

class MissingRegistryEntryHandler<T extends IForgeRegistryEntry<T>> {
    private final ResourceLocation _key;
    private final RegistryEvent.MissingMappings.Action _remapAction;
    private final T _replacement;
    private int _oldId;

    static <T extends IForgeRegistryEntry<T>> MissingRegistryEntryHandler<T> remap(@Nonnull ResourceLocation key, @Nonnull T replacement) {
        return new MissingRegistryEntryHandler<T>(key, RegistryEvent.MissingMappings.Action.REMAP, replacement);
    }

    static <T extends IForgeRegistryEntry<T>> MissingRegistryEntryHandler<T> ignore(@Nonnull ResourceLocation key) {
        return new MissingRegistryEntryHandler<Object>(key, RegistryEvent.MissingMappings.Action.IGNORE, null);
    }

    static <T extends IForgeRegistryEntry<T>> MissingRegistryEntryHandler<T> warn(@Nonnull ResourceLocation key) {
        return new MissingRegistryEntryHandler<Object>(key, RegistryEvent.MissingMappings.Action.WARN, null);
    }

    static <T extends IForgeRegistryEntry<T>> MissingRegistryEntryHandler<T> fail(@Nonnull ResourceLocation key) {
        return new MissingRegistryEntryHandler<Object>(key, RegistryEvent.MissingMappings.Action.FAIL, null);
    }

    @Nonnull
    ResourceLocation getKey() {
        return this._key;
    }

    @Nonnull
    RegistryEvent.MissingMappings.Action getRemapAction() {
        return this._remapAction;
    }

    @Nonnull
    T getReplacement() {
        return this._replacement;
    }

    int getOldId() {
        return this._oldId;
    }

    void remap(@Nonnull RegistryEvent.MissingMappings.Mapping<T> mapping) {
        if (this.getKey().equals((Object)mapping.key)) {
            this._oldId = mapping.id;
            switch (this.getRemapAction()) {
                case FAIL: {
                    mapping.fail();
                    break;
                }
                case IGNORE: {
                    mapping.ignore();
                    break;
                }
                case REMAP: {
                    mapping.remap(this.getReplacement());
                    break;
                }
                case WARN: {
                    mapping.warn();
                }
            }
        }
    }

    protected MissingRegistryEntryHandler(@Nonnull ResourceLocation key, @Nonnull RegistryEvent.MissingMappings.Action action, @Nullable T replacement) {
        this._key = key;
        this._remapAction = action;
        this._replacement = replacement;
        this._oldId = -1;
    }
}

