/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.init.flattening;

import com.google.common.collect.Maps;
import erogenousbeef.bigreactors.common.BigReactors;
import java.util.Map;
import javax.annotation.Nonnull;
import joptsimple.internal.Strings;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixableData;

public class TileEntityNameFixer
implements IFixableData {
    private final int _dataVersion;
    private final String _filterPrefix;
    private final Map<String, String> _remappings;

    public TileEntityNameFixer(int dataVersion, @Nonnull String filterPrefix) {
        this._dataVersion = dataVersion;
        this._filterPrefix = filterPrefix;
        this._remappings = Maps.newHashMap();
    }

    public void addReplacement(@Nonnull String oldName, @Nonnull ResourceLocation newId) {
        this._remappings.put(oldName, newId.toString());
    }

    public int func_188216_a() {
        return this._dataVersion;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        String teName = compound.func_74779_i("id");
        if (teName.startsWith(this._filterPrefix)) {
            String newName = this._remappings.get(teName);
            if (!Strings.isNullOrEmpty((String)newName)) {
                compound.func_74778_a("id", newName);
                BigReactors.getLogger().debug("Remapped old TileEntity ID '{}' with '{}'", (Object)teName, (Object)newName);
            } else {
                BigReactors.getLogger().debug("No remapping found for TileEntity ID '{}'", (Object)teName);
            }
        }
        return compound;
    }
}

