/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.data.numbers.ConstantProvider;
import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.data.numbers.random.SkellamRandomProvider;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.world.generator.WorldGen;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class WorldGenDecoration
extends WorldGen {
    private final List<WeightedBlock> cluster;
    private final WeightedBlock[] genBlock;
    private final WeightedBlock[] onBlock;
    private final INumberProvider clusterSize;
    private boolean seeSky = true;
    private boolean checkStay = true;
    private INumberProvider stackHeight;
    private INumberProvider xVar;
    private INumberProvider yVar;
    private INumberProvider zVar;

    public WorldGenDecoration(List<WeightedBlock> blocks, int count, List<WeightedBlock> material, List<WeightedBlock> on) {
        this(blocks, new ConstantProvider(count), material, on);
    }

    public WorldGenDecoration(List<WeightedBlock> blocks, INumberProvider count, List<WeightedBlock> material, List<WeightedBlock> on) {
        this.cluster = blocks;
        this.clusterSize = count;
        this.genBlock = material == null ? null : material.toArray(new WeightedBlock[material.size()]);
        this.onBlock = on == null ? null : on.toArray(new WeightedBlock[on.size()]);
        this.setStackHeight(1);
        this.setXVar(new SkellamRandomProvider(8));
        this.setYVar(new SkellamRandomProvider(4));
        this.setZVar(new SkellamRandomProvider(8));
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos start) {
        int xStart = start.func_177958_n();
        int yStart = start.func_177956_o();
        int zStart = start.func_177952_p();
        INumberProvider.DataHolder data = new INumberProvider.DataHolder(start);
        int clusterSize = this.clusterSize.intValue(world, rand, data);
        boolean r = false;
        int l = clusterSize;
        block0: while (l-- > 0) {
            int z;
            int y;
            int x = xStart + this.xVar.intValue(world, rand, data.setPosition((Vec3i)start));
            BlockPos pos = new BlockPos(x, y = yStart + this.yVar.intValue(world, rand, data.setPosition((Vec3i)start.func_177982_a(x - xStart, 0, (z = zStart + this.zVar.intValue(world, rand, data.setPosition((Vec3i)start.func_177982_a(x - xStart, 0, 0)))) - zStart))), z);
            if (!world.func_175667_e(pos)) {
                ++l;
                continue;
            }
            if (this.seeSky && !world.func_175678_i(pos) || !WorldGenDecoration.canGenerateInBlock(world, x, y - 1, z, this.onBlock) || !WorldGenDecoration.canGenerateInBlock(world, x, y, z, this.genBlock)) continue;
            WeightedBlock block = WorldGenDecoration.selectBlock(rand, this.cluster);
            int stack = this.stackHeight.intValue(world, rand, data.setPosition((Vec3i)pos));
            while (!this.checkStay || block.block.func_176196_c(world, pos)) {
                r |= WorldGenDecoration.setBlock(world, pos, block);
                pos = pos.func_177982_a(0, 1, 0);
                if (WorldGenDecoration.canGenerateInBlock(world, x, ++y, z, this.genBlock) && --stack > 0) continue;
                continue block0;
            }
        }
        return r;
    }

    public WorldGenDecoration setSeeSky(boolean seeSky) {
        this.seeSky = seeSky;
        return this;
    }

    public WorldGenDecoration setCheckStay(boolean checkStay) {
        this.checkStay = checkStay;
        return this;
    }

    public WorldGenDecoration setStackHeight(int stackHeight) {
        return this.setStackHeight(new ConstantProvider(stackHeight));
    }

    public WorldGenDecoration setStackHeight(INumberProvider stackHeight) {
        this.stackHeight = stackHeight;
        return this;
    }

    public WorldGenDecoration setXVar(int xVar) {
        return this.setXVar(new ConstantProvider(xVar));
    }

    public WorldGenDecoration setXVar(INumberProvider xVar) {
        this.xVar = xVar;
        return this;
    }

    public WorldGenDecoration setYVar(int yVar) {
        return this.setYVar(new ConstantProvider(yVar));
    }

    public WorldGenDecoration setYVar(INumberProvider yVar) {
        this.yVar = yVar;
        return this;
    }

    public WorldGenDecoration setZVar(int zVar) {
        return this.setZVar(new ConstantProvider(zVar));
    }

    public WorldGenDecoration setZVar(INumberProvider zVar) {
        this.zVar = zVar;
        return this;
    }
}

