/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class MachineRecipeInput {
    public final int slotNumber;
    @Nonnull
    public final ItemStack item;
    public final FluidStack fluid;

    @Nonnull
    public static ItemStack getInputForSlot(int slot, NNList<MachineRecipeInput> inputs) {
        ItemStack ret = Prep.getEmpty();
        for (MachineRecipeInput ri : inputs) {
            ret = MachineRecipeInput.getInputForSlot(slot, ri);
            if (!Prep.isValid(ret)) continue;
            return ret;
        }
        return ret;
    }

    @Nonnull
    public static ItemStack getInputForSlot(int slot, MachineRecipeInput input) {
        if (input.slotNumber == slot) {
            return input.item;
        }
        return Prep.getEmpty();
    }

    @Nonnull
    public static MachineRecipeInput create(int slotNumber, @Nonnull ItemStack item) {
        return new MachineRecipeInput(slotNumber, item);
    }

    public MachineRecipeInput(int slotNumber, @Nonnull ItemStack item) {
        this.slotNumber = slotNumber;
        this.item = item;
        this.fluid = null;
    }

    public MachineRecipeInput(int slotNumber, FluidStack fluid) {
        this.slotNumber = slotNumber;
        this.item = Prep.getEmpty();
        this.fluid = fluid;
    }

    public MachineRecipeInput(int slotNumber, @Nonnull ItemStack item, FluidStack fluid) {
        this.slotNumber = slotNumber;
        this.item = item;
        this.fluid = fluid;
    }

    public MachineRecipeInput copy() {
        if (this.isFluid()) {
            return new MachineRecipeInput(this.slotNumber, this.fluid.copy());
        }
        return new MachineRecipeInput(this.slotNumber, this.item.func_77946_l());
    }

    public static MachineRecipeInput readFromNBT(@Nonnull NBTTagCompound root) {
        int slotNum = root.func_74762_e("slotNum");
        ItemStack item = Prep.getEmpty();
        FluidStack fluid = null;
        if (root.func_74764_b("itemStack")) {
            NBTTagCompound stackRoot = root.func_74775_l("itemStack");
            item = new ItemStack(stackRoot);
        } else if (root.func_74764_b("fluidStack")) {
            NBTTagCompound stackRoot = root.func_74775_l("fluidStack");
            fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stackRoot);
        }
        return new MachineRecipeInput(slotNum, item, fluid);
    }

    public void writeToNbt(@Nonnull NBTTagCompound root) {
        if (Prep.isValid(this.item)) {
            NBTTagCompound stackRoot = new NBTTagCompound();
            this.item.func_77955_b(stackRoot);
            root.func_74782_a("itemStack", (NBTBase)stackRoot);
        } else if (this.fluid != null) {
            NBTTagCompound stackRoot = new NBTTagCompound();
            this.fluid.writeToNBT(stackRoot);
            root.func_74782_a("fluidStack", (NBTBase)stackRoot);
        }
        root.func_74768_a("slotNum", this.slotNumber);
    }

    public boolean isFluid() {
        return this.fluid != null;
    }
}

