/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import com.yogpc.qp.Config;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.EnergyUsage;
import com.yogpc.qp.tile.TileMiningWell;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class PowerManager {
    private static double QuarryWork_CF;
    private static double QuarryWork_CS;
    private static double MiningWell_CF;
    private static double MiningWell_CS;
    private static double QuarryWork_BP;
    private static double QuarryWork_CE;
    private static double QuarryWork_CU;
    private static double QuarryWork_XR;
    private static double QuarryWork_MS;
    private static double FrameBuild_BP;
    private static double FrameBuild_CE;
    private static double FrameBuild_CU;
    private static double FrameBuild_XR;
    private static double FrameBuild_MS;
    private static double MiningWell_BP;
    private static double MiningWell_CE;
    private static double MiningWell_CU;
    private static double MiningWell_XR;
    private static double MiningWell_MS;
    private static double Laser_BP;
    private static double Laser_CE;
    private static double Laser_CU;
    private static double Laser_XR;
    private static double Laser_MS;
    private static double Laser_CF;
    private static double Laser_CS;
    private static double Refinery_CE;
    private static double Refinery_CU;
    private static double Refinery_XR;
    private static double Refinery_MS;
    private static double PumpFrame_BP;
    private static double PumpFrame_CU;
    private static double PumpDrain_BP;
    private static double PumpDrain_CU;
    private static double MoveHead_BP;
    private static double MoveHead_CU;
    private static final int length;

    private static double get(ConfigCategory c, String name, double def) {
        if (c.containsKey(name)) {
            Property prop = c.get(name);
            if (prop.getType() == null) {
                prop = new Property(prop.getName(), prop.getString(), Property.Type.DOUBLE);
                prop.setComment(c.getQualifiedName().substring(length) + "." + name);
                c.put(name, prop);
            }
            prop.setMinValue(0.1).setMaxValue(2.0E9).setDefaultValue(def);
            return prop.getDouble(def);
        }
        Property prop = new Property(name, Double.toString(def), Property.Type.DOUBLE);
        prop.setComment(c.getQualifiedName().substring(length) + "." + name);
        prop.setMinValue(0.1).setMaxValue(2.0E9).setDefaultValue(def);
        c.put(name, prop);
        return prop.getDouble(def);
    }

    static void loadConfiguration(Configuration cg) throws RuntimeException {
        ConfigCategory powerSetting = cg.getCategory("general.PowerSetting");
        powerSetting.setComment("Quarry PowerSetting (min = 0.1, Max = 2,000,000,000 = 2 billion)");
        String cn = "general.PowerSetting.";
        String cn2 = "general.PowerSetting.Quarry.";
        ConfigCategory c = cg.getCategory(cn2 + "BreakBlock");
        QuarryWork_BP = PowerManager.get(c, "BasePower", 40.0);
        QuarryWork_CE = PowerManager.get(c, "EfficiencyCoefficient", 1.3);
        QuarryWork_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        QuarryWork_CF = PowerManager.get(c, "FortuneCoefficient", 1.3);
        QuarryWork_CS = PowerManager.get(c, "SilktouchCoefficient", 2.0);
        QuarryWork_XR = PowerManager.get(c, "BaseMaxRecieve", 300.0);
        QuarryWork_MS = PowerManager.get(c, "BaseMaxStored", 15000.0);
        c = cg.getCategory(cn2 + "BreakBlock" + "." + "MoveHead");
        MoveHead_BP = PowerManager.get(c, "BasePower", 200.0);
        MoveHead_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        c = cg.getCategory(cn2 + "MakeFrame");
        FrameBuild_BP = PowerManager.get(c, "BasePower", 25.0);
        FrameBuild_CE = PowerManager.get(c, "EfficiencyCoefficient", 1.3);
        FrameBuild_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        FrameBuild_XR = PowerManager.get(c, "BaseMaxRecieve", 100.0);
        FrameBuild_MS = PowerManager.get(c, "BaseMaxStored", 15000.0);
        cn2 = "general.PowerSetting.Pump.";
        c = cg.getCategory(cn2 + "DrainLiquid");
        PumpDrain_BP = PowerManager.get(c, "BasePower", 10.0);
        PumpDrain_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        c = cg.getCategory(cn2 + "MakeFrame");
        PumpFrame_BP = PowerManager.get(c, "BasePower", 25.0);
        PumpFrame_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        c = cg.getCategory("general.PowerSetting.MiningWell");
        MiningWell_BP = PowerManager.get(c, "BasePower", 40.0);
        MiningWell_CE = PowerManager.get(c, "EfficiencyCoefficient", 1.3);
        MiningWell_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        MiningWell_CF = PowerManager.get(c, "FortuneCoefficient", 1.3);
        MiningWell_CS = PowerManager.get(c, "SilktouchCoefficient", 2.0);
        MiningWell_XR = PowerManager.get(c, "BaseMaxRecieve", 100.0);
        MiningWell_MS = PowerManager.get(c, "BaseMaxStored", 1000.0);
        c = cg.getCategory("general.PowerSetting.Laser");
        Laser_BP = PowerManager.get(c, "BasePower", 4.0);
        Laser_CE = PowerManager.get(c, "EfficiencyCoefficient", 2.0);
        Laser_CU = PowerManager.get(c, "UnbreakingCoefficient", 0.1);
        Laser_CF = PowerManager.get(c, "FortuneCoefficient", 1.05);
        Laser_CS = PowerManager.get(c, "SilktouchCoefficient", 1.1);
        Laser_XR = PowerManager.get(c, "BaseMaxRecieve", 100.0);
        Laser_MS = PowerManager.get(c, "BaseMaxStored", 1000.0);
        c = cg.getCategory("general.PowerSetting.Refinery");
        Refinery_CE = PowerManager.get(c, "EfficiencyCoefficient", 1.2);
        Refinery_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        Refinery_XR = PowerManager.get(c, "BaseMaxRecieve", 6.0);
        Refinery_MS = PowerManager.get(c, "BaseMaxStored", 1000.0);
    }

    public static void configure0(APowerTile pp) {
        pp.configure(0.0, pp.getMaxStored());
    }

    private static void configure(APowerTile pp, double CE, byte efficiencyLevel, byte unbreakingLevel, double CU, double XR, double MS, int pump2) {
        pp.configure(XR * Math.pow(CE, efficiencyLevel) / ((double)unbreakingLevel * CU + 1.0), MS * Math.pow(CE, efficiencyLevel) / ((double)unbreakingLevel * CU + 1.0) + (pump2 > 0 ? 65536.0 * PumpDrain_BP / ((double)pump2 * PumpDrain_CU + 1.0) + 1020.0 * PumpFrame_BP / ((double)pump2 * PumpFrame_CU + 1.0) : 0.0));
    }

    public static void configureQuarryWork(APowerTile pp, byte efficiencyLevel, byte unbreakingLevel, int pump2) {
        PowerManager.configure(pp, QuarryWork_CE, efficiencyLevel, unbreakingLevel, QuarryWork_CU, QuarryWork_XR, QuarryWork_MS, pump2);
    }

    public static void configureMiningWell(APowerTile pp, byte efficiencyLevel, byte unbreakingLevel, int pump2) {
        PowerManager.configure(pp, MiningWell_CE, efficiencyLevel, unbreakingLevel, MiningWell_CU, MiningWell_XR, MiningWell_MS, pump2);
    }

    public static void configureLaser(APowerTile pp, byte efficiencyLevel, byte unbreakingLevel) {
        PowerManager.configure(pp, Laser_CE, efficiencyLevel, unbreakingLevel, Laser_CU, Laser_XR, Laser_MS, 0);
    }

    public static void configureFrameBuild(APowerTile pp, byte efficiencyLevel, byte unbreakingLevel, int pump2) {
        PowerManager.configure(pp, FrameBuild_CE, efficiencyLevel, unbreakingLevel, FrameBuild_CU, FrameBuild_XR, FrameBuild_MS, pump2);
    }

    public static void configureRefinery(APowerTile pp, byte efficiencyLevel, byte unbreakingLevel) {
        PowerManager.configure(pp, Refinery_CE, efficiencyLevel, unbreakingLevel, Refinery_CU, Refinery_XR, Refinery_MS, 0);
    }

    public static boolean useEnergyBreak(APowerTile pp, float hardness, byte enchantMode, byte unbreaking, boolean replacer) {
        if (enchantMode == -2) {
            return true;
        }
        double pw = PowerManager.calcEnergyBreak(pp, hardness, enchantMode, unbreaking) * (replacer ? 1.1 : 1.0);
        if (pp.useEnergy(pw, pw, false, EnergyUsage.BREAK_BLOCK) != pw) {
            return false;
        }
        pp.useEnergy(pw, pw, true, EnergyUsage.BREAK_BLOCK);
        return true;
    }

    private static double calcEnergyBreak(APowerTile pp, float hardness, byte enchantMode, byte unbreaking) {
        double CSP;
        double CU;
        double BP;
        if (pp instanceof TileMiningWell) {
            BP = MiningWell_BP;
            CU = MiningWell_CU;
            CSP = enchantMode < 0 ? MiningWell_CS : Math.pow(MiningWell_CF, enchantMode);
        } else {
            BP = QuarryWork_BP;
            CU = QuarryWork_CU;
            CSP = enchantMode < 0 ? QuarryWork_CS : Math.pow(QuarryWork_CF, enchantMode);
        }
        return BP * (double)hardness * CSP / ((double)unbreaking * CU + 1.0);
    }

    public static double calcEnergyBreak(float hardness, int enchantMode, int unbreaking) {
        double BP = QuarryWork_BP;
        double CU = QuarryWork_CU;
        double CSP = enchantMode < 0 ? QuarryWork_CS : Math.pow(QuarryWork_CF, enchantMode);
        return BP * (double)hardness * CSP / ((double)unbreaking * CU + 1.0);
    }

    public static boolean useEnergyPump(APowerTile pp, byte U, long liquidsCount, long framesToBuild) {
        double pw = PowerManager.calcEnergyPumpDrain(U, liquidsCount, framesToBuild);
        if (pp.useEnergy(pw, pw, false, EnergyUsage.PUMP_FLUID) != pw) {
            return false;
        }
        pp.useEnergy(pw, pw, true, EnergyUsage.PUMP_FLUID);
        return true;
    }

    public static double calcEnergyPumpDrain(int unbreaking, long liquids, long frames) {
        return PumpDrain_BP * (double)liquids / ((double)unbreaking * PumpDrain_CU + 1.0) + PumpFrame_BP * (double)frames / ((double)unbreaking * PumpFrame_CU + 1.0);
    }

    private static boolean useEnergy(APowerTile pp, double BP, int U, double CU, int E, double CE, EnergyUsage usage) {
        double pw = BP / Math.pow(CE, E) / ((double)U * CU + 1.0);
        if (pp.useEnergy(pw, pw, false, usage) != pw) {
            return false;
        }
        pp.useEnergy(pw, pw, true, usage);
        return true;
    }

    public static boolean useEnergyFrameBuild(APowerTile pp, int U) {
        return PowerManager.useEnergy(pp, FrameBuild_BP, U, FrameBuild_CU, 0, 1.0, EnergyUsage.FRAME_BUILD);
    }

    public static boolean useEnergyRefinery(APowerTile pp, double BP, byte U, byte E) {
        return PowerManager.useEnergy(pp, BP, U, Refinery_CU, E, Refinery_CE, EnergyUsage.REFINERY);
    }

    public static double useEnergyQuarryHead(APowerTile pp, double dist, byte U) {
        double pw = !Config.content().fastQuarryHeadMove() ? Math.min(2.0 + pp.getStoredEnergy() / 500.0, (dist / 2.0 - 0.05) * MoveHead_BP / ((double)U * MoveHead_CU + 1.0)) : (dist / 2.0 - 0.05) * MoveHead_BP / ((double)U * MoveHead_CU + 1.0);
        pw = pp.useEnergy(0.0, pw, true, EnergyUsage.MOVE_HEAD);
        return pw * ((double)U * MoveHead_CU + 1.0) / MoveHead_BP + 0.05;
    }

    public static double simulateEnergyLaser(APowerTile pp, byte U, byte F2, boolean S, byte E) {
        double pw = Laser_BP * Math.pow(Laser_CF, F2) * Math.pow(Laser_CE, E) / ((double)U * Laser_CU + 1.0);
        if (S) {
            pw *= Laser_CS;
        }
        pw = pp.useEnergy(0.0, pw, false, EnergyUsage.LASER);
        if (S) {
            pw /= Laser_CS;
        }
        return pw * ((double)U * Laser_CU + 1.0) / Math.pow(Laser_CF, F2);
    }

    public static void useEnergyLaser(APowerTile pp, double power, byte U, byte F2, boolean S, boolean simulate) {
        double pw = power * Math.pow(Laser_CF, F2) * (S ? Laser_CS : 1.0) / ((double)U * Laser_CU + 1.0);
        pp.useEnergy(pw, pw, !simulate, EnergyUsage.LASER);
    }

    public static double calcEnergyAdvSearch(int unbreakingLevel, int targetY) {
        return MoveHead_BP * (double)targetY / (MoveHead_CU * (double)unbreakingLevel + 1.0) / 4.0;
    }

    static {
        length = "general.".length();
    }
}

