/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import com.yogpc.qp.ChunkLoadingHandler;
import com.yogpc.qp.Config;
import com.yogpc.qp.Loot;
import com.yogpc.qp.ProxyClient;
import com.yogpc.qp.ProxyCommon;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.gui.GuiFactory;
import com.yogpc.qp.gui.GuiHandler;
import com.yogpc.qp.item.ItemTool;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.tile.ItemDamage;
import com.yogpc.qp.tile.TileAdvPump;
import com.yogpc.qp.tile.TileAdvQuarry;
import com.yogpc.qp.tile.TileBookMover;
import com.yogpc.qp.tile.TileBreaker;
import com.yogpc.qp.tile.TileExpPump;
import com.yogpc.qp.tile.TileLaser;
import com.yogpc.qp.tile.TileMarker;
import com.yogpc.qp.tile.TileMiningWell;
import com.yogpc.qp.tile.TilePlacer;
import com.yogpc.qp.tile.TilePump;
import com.yogpc.qp.tile.TileQuarry;
import com.yogpc.qp.tile.TileRefinery;
import com.yogpc.qp.tile.TileReplacer;
import com.yogpc.qp.tile.TileSolidQuarry;
import com.yogpc.qp.tile.TileWorkbench;
import com.yogpc.qp.tile.WorkbenchRecipes;
import com.yogpc.qp.version.VersionDiff;
import com.yogpc.qp.version.VersionUtil;
import java.io.File;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="quarryplus", name="QuarryPlus", version="1.0.5", guiFactory="com.yogpc.qp.gui.GuiFactory", updateJSON="https://raw.githubusercontent.com/Kotori316/QuarryPlus/1.12/update.json", certificateFingerprint="617a4e95f0af9de5402bb9883abe0f53a6bfa230", dependencies="required:forge@[14.23.4.2705,);", acceptedMinecraftVersions="[1.12.2]")
public class QuarryPlus {
    @SidedProxy(clientSide="com.yogpc.qp.ProxyClient", serverSide="com.yogpc.qp.ProxyCommon")
    public static ProxyCommon proxy;
    public static final QuarryPlus INSTANCE;
    public static final VersionDiff DIFF;
    public static final String Mod_Name = "QuarryPlus";
    public static final String modID = "quarryplus";
    private static final String prefix = "quarryplus:";
    public static final Logger LOGGER;
    public boolean inDev;

    private QuarryPlus() {
    }

    @Mod.InstanceFactory
    public static QuarryPlus instance() {
        return INSTANCE;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.setConfigFile(event.getSuggestedConfigurationFile(), new File(event.getModConfigurationDirectory(), "quarryplus/quarryplus.cfg"));
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)QuarryPlus.instance(), (ForgeChunkManager.LoadingCallback)ChunkLoadingHandler.instance());
        MinecraftForge.EVENT_BUS.register((Object)QuarryPlus.instance());
        if (!Config.content().disableDungeonLoot()) {
            MinecraftForge.EVENT_BUS.register((Object)Loot.instance());
        }
        proxy.registerTextures();
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)GuiHandler.instance());
        this.inDev = Launch.blackboard.getOrDefault("fml.deobfuscatedEnvironment", Boolean.FALSE);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PacketHandler.init();
        WorkbenchRecipes.registerRecipes();
        Config.content().outputRecipeJson();
        Config.recipeSync();
        if (this.inDev && Loader.isModLoaded((String)"buildcraftlib")) {
            BuildcraftHelper.disableFacade();
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{QuarryPlusI.blockQuarry(), QuarryPlusI.blockPump(), QuarryPlusI.blockMarker(), QuarryPlusI.blockMover(), QuarryPlusI.blockMiningWell(), QuarryPlusI.blockPlacer(), QuarryPlusI.blockBreaker(), QuarryPlusI.blockPlainPipe(), QuarryPlusI.blockFrame(), QuarryPlusI.blockWorkbench(), QuarryPlusI.blockController(), QuarryPlusI.blockLaser(), QuarryPlusI.blockRefinery(), QuarryPlusI.blockChunkDestroyer(), QuarryPlusI.blockStandalonePump(), QuarryPlusI.blockBookMover(), QuarryPlusI.blockExpPump(), QuarryPlusI.blockSolidQuarry(), QuarryPlusI.dummyBlock(), QuarryPlusI.blockReplacer()});
        GameRegistry.registerTileEntity(TileWorkbench.class, (ResourceLocation)new ResourceLocation(modID, "workbenchplus"));
        GameRegistry.registerTileEntity(TileQuarry.class, (ResourceLocation)new ResourceLocation(modID, modID));
        GameRegistry.registerTileEntity(TileMarker.class, (ResourceLocation)new ResourceLocation(modID, "markerplus"));
        GameRegistry.registerTileEntity(TileMiningWell.class, (ResourceLocation)new ResourceLocation(modID, "miningwellplus"));
        GameRegistry.registerTileEntity(TilePump.class, (ResourceLocation)new ResourceLocation(modID, "pumpplus"));
        GameRegistry.registerTileEntity(TileRefinery.class, (ResourceLocation)new ResourceLocation(modID, "refineryplus"));
        GameRegistry.registerTileEntity(TilePlacer.class, (ResourceLocation)new ResourceLocation(modID, "placerplus"));
        GameRegistry.registerTileEntity(TileBreaker.class, (ResourceLocation)new ResourceLocation(modID, "breakerplus"));
        GameRegistry.registerTileEntity(TileLaser.class, (ResourceLocation)new ResourceLocation(modID, "laserplus"));
        GameRegistry.registerTileEntity(TileAdvQuarry.class, (ResourceLocation)new ResourceLocation(modID, "chunkdestroyer"));
        GameRegistry.registerTileEntity(TileAdvPump.class, (ResourceLocation)new ResourceLocation(modID, "standalonepump"));
        GameRegistry.registerTileEntity(TileBookMover.class, (ResourceLocation)new ResourceLocation(modID, "enchantmoverfrombook"));
        GameRegistry.registerTileEntity(TileExpPump.class, (ResourceLocation)new ResourceLocation(modID, "exppump"));
        GameRegistry.registerTileEntity(TileSolidQuarry.class, (ResourceLocation)new ResourceLocation(modID, "solidquarry"));
        GameRegistry.registerTileEntity(TileReplacer.class, (ResourceLocation)new ResourceLocation(modID, "quarryreplacer"));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{QuarryPlusI.blockQuarry().itemBlock(), QuarryPlusI.blockPump().itemBlock(), QuarryPlusI.blockMarker().itemBlock, QuarryPlusI.blockMover().itemBlock, QuarryPlusI.blockMiningWell().itemBlock(), QuarryPlusI.blockPlacer().itemBlock(), QuarryPlusI.blockBreaker().itemBlock(), QuarryPlusI.blockPlainPipe().itemBlock, QuarryPlusI.blockFrame().itemBlock, QuarryPlusI.blockWorkbench().itemBlock(), QuarryPlusI.blockController().itemBlock, QuarryPlusI.blockLaser().itemBlock(), QuarryPlusI.blockRefinery().itemBlock(), QuarryPlusI.blockChunkDestroyer().itemBlock(), QuarryPlusI.blockStandalonePump().itemBlock(), QuarryPlusI.blockBookMover().itemBlock(), QuarryPlusI.blockExpPump().itemBlock(), QuarryPlusI.blockSolidQuarry().itemBlock(), QuarryPlusI.dummyBlock().itemBlock(), QuarryPlusI.blockReplacer().itemBlock(), QuarryPlusI.itemTool(), QuarryPlusI.magicMirror(), QuarryPlusI.debugItem()});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockQuarry().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockQuarry()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockFrame().itemBlock, (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockFrame()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockFrame().itemBlock, (int)1, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockFrame()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockMarker().itemBlock, (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockMarker()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockWorkbench().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockWorkbench()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockPump().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockPump()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockMover().itemBlock, (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockMover()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockBreaker().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockBreaker()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockPlacer().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockPlacer()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockMiningWell().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockMiningWell()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockPlainPipe().itemBlock, (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockPlainPipe()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockRefinery().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockRefinery()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockController().itemBlock, (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockController()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockLaser().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockLaser()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockChunkDestroyer().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockChunkDestroyer()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockStandalonePump().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockStandalonePump()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockBookMover().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockBookMover()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockExpPump().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockExpPump()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockSolidQuarry().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockSolidQuarry()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.dummyBlock().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.dummyBlock()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.blockReplacer().itemBlock(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.blockReplacer()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.itemTool(), (int)ItemTool.meta_StatusChecker(), (ModelResourceLocation)ModelLoader.getInventoryVariant((String)(prefix + ItemTool.statuschecker())));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.itemTool(), (int)ItemTool.meta_ListEditor(), (ModelResourceLocation)ModelLoader.getInventoryVariant((String)(prefix + ItemTool.listeditor())));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.itemTool(), (int)ItemTool.meta_LiquidSelector(), (ModelResourceLocation)ModelLoader.getInventoryVariant((String)(prefix + ItemTool.liquidselector())));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.itemTool(), (int)ItemTool.meta_YSetter(), (ModelResourceLocation)ModelLoader.getInventoryVariant((String)(prefix + ItemTool.ySetter())));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.magicMirror(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.magicMirror()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.magicMirror(), (int)1, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.magicMirror()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.magicMirror(), (int)2, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.magicMirror()));
        ModelLoader.setCustomModelResourceLocation((Item)QuarryPlusI.debugItem(), (int)0, (ModelResourceLocation)proxy.fromEntry((IForgeRegistryEntry<?>)QuarryPlusI.debugItem()));
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        TileMarker.Laser[] lb;
        TileMarker.Link[] la;
        for (TileMarker.Link link : la = TileMarker.linkList.toArray(new TileMarker.Link[0])) {
            if (link.w != event.getWorld()) continue;
            link.removeConnection(false);
        }
        for (TileMarker.Laser laser : lb = TileMarker.laserList.toArray(new TileMarker.Laser[0])) {
            if (laser.w != event.getWorld()) continue;
            laser.destructor();
        }
    }

    @Mod.EventHandler
    public void message(FMLInterModComms.IMCEvent event) {
        event.getMessages().forEach(imcMessage -> {
            NBTTagCompound nbtValue = imcMessage.getNBTValue();
            Function<NBTTagCompound, ItemStack> toStack = VersionUtil::fromNBTTag;
            if ("IMC_RemoveRecipe".equals(imcMessage.key)) {
                WorkbenchRecipes.removeRecipe(ItemDamage.apply(toStack.apply(nbtValue)));
            } else if ("IMC_AddRecipe".equals(imcMessage.key)) {
                Function<ItemStack, IntFunction> toFunc = stack -> integer -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(VersionUtil.getCount(stack) * integer));
                NBTTagList list = nbtValue.func_150295_c("IMC_AddRecipe", 10);
                ResourceLocation location = new ResourceLocation(nbtValue.func_74779_i("id"));
                ItemDamage result = ItemDamage.apply(toStack.apply(list.func_150305_b(0)));
                List<IntFunction<ItemStack>> functionList = VersionUtil.nbtListStream(list).skip(1L).map(toStack.andThen(toFunc)).collect(Collectors.toList());
                WorkbenchRecipes.addListRecipe(location, result, nbtValue.func_74762_e("energy"), functionList, true, WorkbenchRecipes.UnitRF());
            }
        });
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (!event.isDirectory()) {
            LOGGER.warn("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!" + System.lineSeparator() + "Download: https://minecraft.curseforge.com/projects/additional-enchanted-miner");
        }
    }

    static {
        VersionDiff diff;
        LOGGER = LogManager.getLogger((String)Mod_Name);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && !"com.yogpc.qp.ProxyClient".equals(ProxyClient.class.getName())) {
            throw new AssertionError((Object)"Client Proxy name doesn't match!");
        }
        if (!"com.yogpc.qp.ProxyCommon".equals(ProxyCommon.class.getName())) {
            throw new AssertionError((Object)"Server Proxy name doesn't match!");
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && !"com.yogpc.qp.gui.GuiFactory".equals(GuiFactory.class.getName())) {
            throw new AssertionError((Object)"GuiFactory name doesn't match!");
        }
        INSTANCE = new QuarryPlus();
        try {
            diff = (VersionDiff)Class.forName("com.yogpc.qp.version.Diff" + (ForgeVersion.getMajorVersion() - 2)).newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError("VersionDiff doesn't exist!", e);
        }
        DIFF = diff;
    }

    public static class Names {
        public static final String advpump = "standalonepump";
        public static final String advquarry = "chunkdestroyer";
        public static final String breaker = "breakerplus";
        public static final String controller = "spawnercontroller";
        public static final String debug = "quarrydebug";
        public static final String dummyblock = "dummyblock";
        public static final String exppump = "exppump";
        public static final String frame = "quarryframe";
        public static final String laser = "laserplus";
        public static final String marker = "markerplus";
        public static final String miningwell = "miningwellplus";
        public static final String mirror = "magicmirror";
        public static final String mover = "enchantmover";
        public static final String moverfrombook = "enchantmoverfrombook";
        public static final String placer = "placerplus";
        public static final String plainpipe = "plainpipe";
        public static final String pump = "pumpplus";
        public static final String quarry = "quarryplus";
        public static final String refinery = "refineryplus";
        public static final String replacer = "quarryreplacer";
        public static final String solidquarry = "solidquarry";
        public static final String tool = "tool";
        public static final String workbench = "workbenchplus";
    }

    public static class Optionals {
        public static final String Buildcraft_modID = "buildcraftlib";
        public static final String BuildCraft_core = "buildcraftlib";
        public static final String Buildcraft_facades = "buildcraftlib";
        public static final String Buildcraft_recipes = "buildcraftlib";
        public static final String Buildcraft_tiles = "buildcraftlib";
        public static final String Buildcraft_tools = "buildcraftlib";
        public static final String Buildcraft_transport = "buildcraftlib";
        public static final String Buildcraft_silicon_modID = "buildcraftsilicon";
        public static final String Buildcraft_factory_modID = "buildcraftfactory";
        public static final String COFH_modID = "cofhcore";
        public static final String IC2_modID = "ic2";
        public static final String IMC_Add = "IMC_AddRecipe";
        public static final String IMC_Energy = "energy";
        public static final String IMC_Remove = "IMC_RemoveRecipe";
        public static final String Mekanism_modID = "mekanism";
        public static final String RedstoneFlux_modID = "redstoneflux";
        public static final String Thaumcraft_modID = "thaumcraft";
        public static final String clientProxy = "com.yogpc.qp.ProxyClient";
        public static final String configFactory = "com.yogpc.qp.gui.GuiFactory";
        public static final String serverProxy = "com.yogpc.qp.ProxyCommon";
        public static final String updateJson = "https://raw.githubusercontent.com/Kotori316/QuarryPlus/1.12/update.json";
    }
}

