/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.ADismCBlock;
import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.item.ItemBlockEnchantable;
import com.yogpc.qp.item.ItemTool;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.TileQuarry;
import com.yogpc.qp.version.VersionUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockQuarry
extends ADismCBlock {
    private final ArrayList<ItemStack> drops = new ArrayList();

    public BlockQuarry() {
        super(Material.field_151573_f, "quarryplus", ItemBlockEnchantable::new);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileQuarry tile;
        this.drops.clear();
        if (!worldIn.field_72995_K && (tile = (TileQuarry)worldIn.func_175625_s(pos)) != null) {
            this.addEnchantedItem(worldIn, state, tile, this.drops);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.addAll(this.drops);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity t;
        if (super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        if (BuildcraftHelper.isWrench(playerIn, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, pos))) {
            Optional.ofNullable((TileQuarry)worldIn.func_175625_s(pos)).ifPresent(TileQuarry::G_ReInit);
            return true;
        }
        if (!worldIn.field_72995_K && (t = worldIn.func_175625_s(pos)) != null) {
            TileQuarry quarry = (TileQuarry)t;
            if (stack.func_77973_b() == QuarryPlusI.itemTool() && stack.func_77952_i() == ItemTool.meta_StatusChecker()) {
                quarry.sendEnchantMassage(playerIn);
                VersionUtil.sendMessage(playerIn, (ITextComponent)new TextComponentTranslation("chat.currentmode", new Object[]{new TextComponentTranslation(quarry.filler ? "chat.fillermode" : "chat.quarrymode", new Object[0])}));
            } else if (stack.func_77973_b() == QuarryPlusI.itemTool() && stack.func_77952_i() == ItemTool.meta_YSetter()) {
                playerIn.openGui((Object)QuarryPlus.instance(), QuarryPlusI.guiIdQuarryYLevel(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else if (quarry.G_getNow() == TileQuarry.Mode.NOT_NEED_BREAK) {
                quarry.filler = !quarry.filler;
                VersionUtil.sendMessage(playerIn, (ITextComponent)new TextComponentTranslation("chat.changemode", new Object[]{new TextComponentTranslation(quarry.filler ? "chat.fillermode" : "chat.quarrymode", new Object[0])}));
            }
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            EnumFacing facing = BlockQuarry.get2dOrientation(placer.field_70165_t, placer.field_70161_v, pos.func_177958_n(), pos.func_177952_p()).func_176734_d();
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
            Consumer consumer = IEnchantableTile.Util.initConsumer(stack);
            Optional.ofNullable((TileQuarry)worldIn.func_175625_s(pos)).ifPresent(consumer.andThen(TileQuarry.requestTicket));
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!worldIn.field_72995_K) {
            Optional.ofNullable((TileQuarry)worldIn.func_175625_s(pos)).ifPresent(TileQuarry::G_renew_powerConfigure);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTING});
    }

    public TileQuarry createNewTileEntity(World worldIn, int meta) {
        return new TileQuarry();
    }

    public int func_176201_c(IBlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)ACTING);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing.func_176745_a() | (powered ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)ACTING, (Comparable)Boolean.valueOf((meta & 8) == 8));
    }

    @Override
    protected boolean canRotate() {
        return true;
    }
}

