/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration.jei;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.BlockBookMover;
import com.yogpc.qp.gui.GuiBookMover;
import com.yogpc.qp.gui.GuiWorkbench;
import com.yogpc.qp.integration.jei.BookRecipeCategory;
import com.yogpc.qp.integration.jei.BookRecipeWrapper;
import com.yogpc.qp.integration.jei.MoverRecipeCategory;
import com.yogpc.qp.integration.jei.MoverRecipeWrapper;
import com.yogpc.qp.integration.jei.WorkBenchRecipeCategory;
import com.yogpc.qp.integration.jei.WorkBenchRecipeWrapper;
import com.yogpc.qp.tile.WorkbenchRecipes;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@JEIPlugin
public class QuarryJeiPlugin
implements IModPlugin {
    static IJeiRuntime jeiRuntime;
    static WorkBenchRecipeCategory workBenchRecipeCategory;
    static MoverRecipeCategory moverRecipeCategory;
    static BookRecipeCategory bookRecipeCategory;

    public void register(IModRegistry registry) {
        registry.handleRecipes(WorkbenchRecipes.class, WorkBenchRecipeWrapper::new, WorkBenchRecipeCategory.UID());
        registry.addRecipeCatalyst((Object)new ItemStack((Block)QuarryPlusI.blockWorkbench()), new String[]{WorkBenchRecipeCategory.UID()});
        registry.addRecipeClickArea(GuiWorkbench.class, 7, 74, 161, 11, new String[]{WorkBenchRecipeCategory.UID()});
        registry.addRecipes(WorkBenchRecipeWrapper.getAll(), WorkBenchRecipeCategory.UID());
        registry.handleRecipes(MoverRecipeWrapper.MoverRecipe.class, MoverRecipeWrapper::new, MoverRecipeCategory.UID());
        registry.addRecipeCatalyst((Object)new ItemStack((Block)QuarryPlusI.blockMover()), new String[]{MoverRecipeCategory.UID()});
        registry.addRecipes(MoverRecipeWrapper.recipes(), MoverRecipeCategory.UID());
        if (!Config.content().disableMapJ().get(BlockBookMover.SYMBOL).booleanValue()) {
            registry.handleRecipes(BookRecipeWrapper.BookRecipe.class, BookRecipeWrapper::new, BookRecipeCategory.UID());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)QuarryPlusI.blockBookMover()), new String[]{BookRecipeCategory.UID()});
            registry.addRecipeClickArea(GuiBookMover.class, 79, 35, 23, 16, new String[]{BookRecipeCategory.UID()});
            registry.addRecipes(BookRecipeWrapper.recipes(), BookRecipeCategory.UID());
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        workBenchRecipeCategory = new WorkBenchRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{workBenchRecipeCategory});
        moverRecipeCategory = new MoverRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{moverRecipeCategory});
        if (!Config.content().disableMapJ().get(BlockBookMover.SYMBOL).booleanValue()) {
            bookRecipeCategory = new BookRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{bookRecipeCategory});
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        QuarryJeiPlugin.jeiRuntime = jeiRuntime;
        WorkBenchRecipeWrapper.hideRecipe(jeiRuntime);
    }

    @SubscribeEvent
    public void onPostChanged(ConfigChangedEvent.PostConfigChangedEvent event) {
        if (event.getModID().equals("quarryplus")) {
            WorkBenchRecipeWrapper.hideRecipe(jeiRuntime);
        }
    }
}

