/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.advpump;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.tile.TileAdvPump;
import java.util.Optional;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class AdvPumpChangeMessage
implements IMessage {
    int dim;
    BlockPos pos;
    boolean placeFrame;
    ToStart toStart;

    public static AdvPumpChangeMessage create(TileAdvPump tile, ToStart start) {
        AdvPumpChangeMessage message = new AdvPumpChangeMessage();
        message.placeFrame = tile.placeFrame();
        message.pos = tile.func_174877_v();
        message.dim = tile.func_145831_w().field_73011_w.getDimension();
        message.toStart = start;
        return message;
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        this.placeFrame = buffer.readBoolean();
        this.toStart = ToStart.valueOf(buffer.readInt());
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim).writeBoolean(this.placeFrame).writeInt(this.toStart.ordinal());
    }

    @Override
    public IMessage onReceive(IMessage message, MessageContext ctx) {
        World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
        MinecraftServer server = world.func_73046_m();
        if (world.field_73011_w.getDimension() == this.dim && server != null) {
            Optional.ofNullable((TileAdvPump)world.func_175625_s(this.pos)).ifPresent(tileAdvPump -> server.func_152344_a(() -> {
                tileAdvPump.placeFrame_$eq(this.placeFrame);
                if (this.toStart == ToStart.START) {
                    tileAdvPump.start();
                }
            }));
        }
        return null;
    }

    public static enum ToStart {
        UNCHANGED,
        START,
        STOP;


        public static ToStart valueOf(int i) {
            switch (i) {
                case 0: {
                    return UNCHANGED;
                }
                case 1: {
                    return START;
                }
                case 2: {
                    return STOP;
                }
            }
            QuarryPlus.LOGGER.error("ToStart undefined enum = " + i);
            return null;
        }
    }
}

