/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.advquarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.tile.TileAdvQuarry;
import com.yogpc.qp.tile.TileAdvQuarry$DigRange$;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class AdvActionMessage
implements IMessage {
    private BlockPos pos;
    private int dim;
    private Actions action;
    private NBTTagCompound tag;

    public static AdvActionMessage create(TileAdvQuarry quarry, Actions action) {
        return AdvActionMessage.create(quarry, action, new NBTTagCompound());
    }

    public static AdvActionMessage create(TileAdvQuarry quarry, Actions action, NBTTagCompound compound) {
        AdvActionMessage message = new AdvActionMessage();
        message.pos = quarry.func_174877_v();
        message.dim = quarry.func_145831_w().field_73011_w.getDimension();
        message.action = action;
        message.tag = compound;
        return message;
    }

    @Override
    public void fromBytes(PacketBuffer buffer) throws IOException {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        this.action = (Actions)buffer.func_179257_a(Actions.class);
        this.tag = buffer.func_150793_b();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim);
        buffer.func_179249_a((Enum)this.action);
        buffer.func_150786_a(this.tag);
    }

    @Override
    public IMessage onReceive(IMessage message, MessageContext ctx) {
        TileEntity entity;
        World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
        if (world.field_73011_w.getDimension() == this.dim && (entity = world.func_175625_s(this.pos)) instanceof TileAdvQuarry) {
            TileAdvQuarry quarry = (TileAdvQuarry)entity;
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(this.action.runnable(quarry, this.tag));
        }
        return null;
    }

    public static enum Actions {
        QUICK_START(TileAdvQuarry::noFrameStart),
        CHANGE_RANGE((quarry, rangeNBT) -> quarry.digRange_$eq(TileAdvQuarry$DigRange$.MODULE$.readFromNBT((NBTTagCompound)rangeNBT)));

        private final BiConsumer<TileAdvQuarry, NBTTagCompound> consumer;

        private Actions(Consumer<TileAdvQuarry> consumer) {
            this.consumer = (quarry, nbtTagCompound) -> consumer.accept((TileAdvQuarry)quarry);
        }

        private Actions(BiConsumer<TileAdvQuarry, NBTTagCompound> consumer) {
            this.consumer = consumer;
        }

        Runnable runnable(TileAdvQuarry quarry, NBTTagCompound compound) {
            return () -> this.consumer.accept(quarry, compound);
        }
    }
}

