/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.controller;

import com.yogpc.qp.gui.GuiController;
import com.yogpc.qp.packet.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AvailableEntities
implements IMessage {
    BlockPos pos;
    int dim;
    List<ResourceLocation> entities;

    public static AvailableEntities create(BlockPos pos, int dim, List<EntityEntry> list) {
        AvailableEntities availableEntities = new AvailableEntities();
        availableEntities.pos = pos;
        availableEntities.entities = list.stream().map(IForgeRegistryEntry.Impl::getRegistryName).collect(Collectors.toList());
        availableEntities.dim = dim;
        return availableEntities;
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        int i = buffer.readInt();
        this.entities = new ArrayList<ResourceLocation>(i);
        for (int j = 0; j < i; ++j) {
            this.entities.add(new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE)));
        }
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeInt(this.dim);
        buffer.writeInt(this.entities.size());
        this.entities.forEach(resourceLocation -> buffer.func_180714_a(resourceLocation.toString()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage onReceive(IMessage message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiController(this.dim, this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), this.entities)));
        return null;
    }
}

