/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.marker;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.tile.TileMarker;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RemoveLink
implements IMessage {
    BlockPos minPos;
    BlockPos maxPos;
    int dimensionId;

    public static RemoveLink create(BlockPos minPos, BlockPos maxPos, int dimensionId) {
        RemoveLink link = new RemoveLink();
        link.dimensionId = dimensionId;
        link.maxPos = maxPos;
        link.minPos = minPos;
        return link;
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.minPos = buffer.func_179259_c();
        this.maxPos = buffer.func_179259_c();
        this.dimensionId = buffer.readInt();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.minPos).func_179255_a(this.maxPos).writeInt(this.dimensionId);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage onReceive(IMessage message, MessageContext ctx) {
        int index;
        World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
        if (world.field_73011_w.getDimension() == this.dimensionId && (index = TileMarker.linkList.indexOf(new TileMarker.Link(world, this.maxPos, this.minPos))) >= 0) {
            TileMarker.linkList.get(index).removeConnection(false);
        }
        return null;
    }
}

