/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.pump;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.tile.TilePump;
import java.util.EnumMap;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Mappings {

    public static enum Type {
        None(0),
        Remove(1),
        Add(2),
        Up(3),
        Top(4),
        Down(5),
        Bottom(6);

        public final int id;

        private Type(int i) {
            this.id = i;
        }

        public int getId() {
            return this.id;
        }

        public static Type fromID(int id) {
            switch (id) {
                case 1: {
                    return Remove;
                }
                case 2: {
                    return Add;
                }
                case 3: {
                    return Up;
                }
                case 4: {
                    return Top;
                }
                case 5: {
                    return Down;
                }
                case 6: {
                    return Bottom;
                }
            }
            return None;
        }
    }

    public static class Copy
    implements IMessage {
        BlockPos pos;
        int dim;
        EnumFacing dest;
        LinkedList<String> list;

        public static Copy create(TilePump pump2, EnumFacing dest, LinkedList<String> list) {
            Copy copy = new Copy();
            copy.dest = dest;
            copy.pos = pump2.func_174877_v();
            copy.list = list;
            copy.dim = pump2.func_145831_w().field_73011_w.getDimension();
            return copy;
        }

        @Override
        public void fromBytes(PacketBuffer buffer) {
            this.pos = buffer.func_179259_c();
            this.dest = (EnumFacing)buffer.func_179257_a(EnumFacing.class);
            this.dim = buffer.readInt();
            int length = buffer.readInt();
            this.list = new LinkedList();
            for (int i = 0; i < length; ++i) {
                this.list.add(buffer.func_150789_c(Short.MAX_VALUE));
            }
        }

        @Override
        public void toBytes(PacketBuffer buffer) {
            buffer.func_179255_a(this.pos).func_179249_a((Enum)this.dest).writeInt(this.dim).writeInt(this.list.size());
            this.list.forEach(arg_0 -> ((PacketBuffer)buffer).func_180714_a(arg_0));
        }

        @Override
        public IMessage onReceive(IMessage message, MessageContext ctx) {
            TilePump pump2;
            World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
            MinecraftServer server = world.func_73046_m();
            if (world.field_73011_w.getDimension() == this.dim && server != null && (pump2 = (TilePump)world.func_175625_s(this.pos)) != null) {
                server.func_152344_a(() -> pump2.mapping.put(this.dest, this.list));
            }
            return null;
        }
    }

    public static class Update
    implements IMessage {
        Type type;
        EnumFacing facing;
        BlockPos pos;
        int dim;
        String fluidName;

        public static Update create(TilePump pump2, EnumFacing facing, Type type, String fluidName) {
            Update update2 = new Update();
            update2.facing = facing;
            update2.pos = pump2.func_174877_v();
            update2.type = type;
            update2.fluidName = fluidName;
            update2.dim = pump2.func_145831_w().field_73011_w.getDimension();
            return update2;
        }

        @Override
        public void fromBytes(PacketBuffer buffer) {
            this.pos = buffer.func_179259_c();
            this.facing = (EnumFacing)buffer.func_179257_a(EnumFacing.class);
            this.type = (Type)buffer.func_179257_a(Type.class);
            this.fluidName = buffer.func_150789_c(Short.MAX_VALUE);
            this.dim = buffer.readInt();
        }

        @Override
        public void toBytes(PacketBuffer buffer) {
            buffer.func_179255_a(this.pos).func_179249_a((Enum)this.facing).func_179249_a((Enum)this.type).func_180714_a(this.fluidName).writeInt(this.dim);
        }

        @Override
        public IMessage onReceive(IMessage message, MessageContext ctx) {
            TilePump pump2;
            World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
            MinecraftServer server = world.func_73046_m();
            if (world.field_73011_w.getDimension() == this.dim && server != null && (pump2 = (TilePump)world.func_175625_s(this.pos)) != null) {
                server.func_152344_a(() -> {
                    LinkedList<String> list = pump2.mapping.get(this.facing);
                    Update.typeAction(list, this.fluidName, this.type);
                });
            }
            return null;
        }

        public static void typeAction(LinkedList<String> list, String fluidName, Type type) {
            int i = list.indexOf(fluidName);
            switch (type) {
                case Add: {
                    list.add(fluidName);
                    break;
                }
                case Remove: {
                    list.remove(fluidName);
                    break;
                }
                case Up: {
                    if (i <= 0) break;
                    list.remove(i);
                    list.add(i - 1, fluidName);
                    break;
                }
                case Top: {
                    if (i <= 0) break;
                    list.remove(i);
                    list.addFirst(fluidName);
                    break;
                }
                case Down: {
                    if (i < 0 || i == list.size() - 1) break;
                    list.remove(i);
                    list.add(i + 1, fluidName);
                    break;
                }
                case Bottom: {
                    if (i < 0 || i == list.size() - 1) break;
                    list.remove(i);
                    list.addLast(fluidName);
                    break;
                }
            }
        }
    }

    public static class All
    implements IMessage {
        BlockPos pos;
        EnumFacing facing;
        EnumMap<EnumFacing, LinkedList<String>> map = new EnumMap(EnumFacing.class);

        public static All create(TilePump pump2, EnumFacing facing) {
            All message = new All();
            message.pos = pump2.func_174877_v();
            message.facing = facing;
            message.map = new EnumMap<EnumFacing, LinkedList<String>>(pump2.mapping);
            return message;
        }

        @Override
        public void fromBytes(PacketBuffer buffer) {
            this.pos = buffer.func_179259_c();
            this.facing = (EnumFacing)buffer.func_179257_a(EnumFacing.class);
            for (EnumFacing VALUE : EnumFacing.field_82609_l) {
                int l = buffer.readInt();
                LinkedList<String> strings = new LinkedList<String>();
                for (int j = 0; j < l; ++j) {
                    strings.add(buffer.func_150789_c(Short.MAX_VALUE));
                }
                this.map.put(VALUE, strings);
            }
        }

        @Override
        public void toBytes(PacketBuffer buffer) {
            buffer.func_179255_a(this.pos).func_179249_a((Enum)this.facing);
            for (LinkedList<String> strings : this.map.values()) {
                buffer.writeInt(strings.size());
                strings.forEach(arg_0 -> ((PacketBuffer)buffer).func_180714_a(arg_0));
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IMessage onReceive(IMessage message, MessageContext ctx) {
            TilePump pumpC = (TilePump)QuarryPlus.proxy.getPacketWorld(ctx.netHandler).func_175625_s(this.pos);
            if (pumpC != null) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    pumpC.mapping.clear();
                    pumpC.mapping.putAll(this.map);
                });
            }
            return null;
        }
    }
}

