/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.quarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.tile.TileBasic;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class LevelMessage
implements IMessage {
    protected int yLevel;
    protected BlockPos pos;
    protected int dim;

    public static LevelMessage create(TileBasic tileBasic) {
        LevelMessage message = new LevelMessage();
        message.yLevel = tileBasic.yLevel;
        message.pos = tileBasic.func_174877_v();
        message.dim = tileBasic.func_145831_w().field_73011_w.getDimension();
        return message;
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        this.yLevel = buffer.readInt();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim);
        buffer.writeInt(this.yLevel);
    }

    @Override
    public IMessage onReceive(IMessage message, MessageContext ctx) {
        TileEntity entity;
        World world = QuarryPlus.proxy.getPacketWorld(ctx.netHandler);
        if (world.field_73011_w.getDimension() == this.dim && (entity = world.func_175625_s(this.pos)) instanceof TileBasic) {
            TileBasic quarry = (TileBasic)entity;
            switch (ctx.side) {
                case CLIENT: {
                    quarry.setYLevel(this.yLevel);
                    break;
                }
                case SERVER: {
                    FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> quarry.setYLevel(this.yLevel));
                }
            }
        }
        return null;
    }
}

