/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.google.common.base.Stopwatch;
import com.yogpc.qp.Config$;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.EnergyUsage;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001-\u00111\"\u00128fe\u001eLH)\u001a2vO*\u00111\u0001B\u0001\u0005i&dWM\u0003\u0002\u0006\r\u0005\u0011\u0011\u000f\u001d\u0006\u0003\u000f!\tQ!_8ha\u000eT\u0011!C\u0001\u0004G>l7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\n\u0011\u0005Q)R\"\u0001\u0002\n\u0005Y\u0011!AC!Q_^,'\u000fV5mK\")\u0001\u0004\u0001C\u00013\u00051A(\u001b8jiz\"\"AG\u000e\u0011\u0005Q\u0001\u0001\"B\u0002\u0018\u0001\u0004\u0019\u0002BB\u000f\u0001A\u0003%a$\u0001\u0005uS2,g*Y7f!\tyB%D\u0001!\u0015\t\t#%\u0001\u0003mC:<'\"A\u0012\u0002\t)\fg/Y\u0005\u0003K\u0001\u0012aa\u0015;sS:<\u0007BB\u0014\u0001A\u0003%\u0001&A\u0002h_R\u00042!D\u0015,\u0013\tQcBA\u0003BeJ\f\u0017\u0010\u0005\u0002\u000eY%\u0011QF\u0004\u0002\u0005\u0019>tw\r\u0003\u00040\u0001\u0001\u0006I\u0001K\u0001\u0005kN,G\r\u0003\u00042\u0001\u0001\u0006KAM\u0001\tO>$8i\\;oiB\u0011QbM\u0005\u0003i9\u00111!\u00138u\u0011\u00191\u0004\u0001)Q\u0005e\u0005IQo]3e\u0007>,h\u000e\u001e\u0005\u0007q\u0001\u0001\u000b\u0015B\u0016\u0002\u0013Q|G/\u00197Vg\u0016$\u0007B\u0002\u001e\u0001A\u0003&1&A\u0005v\u0019\u0006\u001cH\u000fV5dW\"1A\b\u0001Q!\n-\n\u0011b\u001a'bgR$\u0016nY6\t\ry\u0002\u0001\u0015)\u0003,\u0003)a\u0017m\u001d;PkR\u0004X\u000f\u001e\u0005\u0007\u0001\u0002\u0001\u000bQB!\u0002\u00055Tw\"\u0001\"\u001f\u0007=\u0011\u0005\t\u0003\u0004E\u0001\u0001\u0006I!R\u0001\ngR|\u0007oV1uG\"\u0004\"AR'\u000e\u0003\u001dS!\u0001S%\u0002\t\t\f7/\u001a\u0006\u0003\u0015.\u000baaY8n[>t'B\u0001'\t\u0003\u00199wn\\4mK&\u0011aj\u0012\u0002\n'R|\u0007o^1uG\"Da\u0001\u0015\u0001!B\u0013Y\u0013!C:uCJ$H+[7f\u0011\u0019\u0011\u0006\u0001)A\u0005'\u0006AQo]1hK6\u000b\u0007\u000f\u0005\u0003U3n[S\"A+\u000b\u0005Y;\u0016aB7vi\u0006\u0014G.\u001a\u0006\u00031:\t!bY8mY\u0016\u001cG/[8o\u0013\tQVKA\u0002NCB\u0004\"\u0001\u0006/\n\u0005u\u0013!aC#oKJ<\u00170V:bO\u0016DQa\u0018\u0001\u0005\u0002\u0001\fqa\u001d;beR,G-F\u0001b!\ti!-\u0003\u0002d\u001d\t9!i\\8mK\u0006t\u0007\"B3\u0001\t\u00031\u0017!B:uCJ$H#A4\u0011\u00055A\u0017BA5\u000f\u0005\u0011)f.\u001b;\t\u000b-\u0004A\u0011\u00027\u0002\u000f\u001d,G\u000fV5nKV\t1\u0006C\u0003o\u0001\u0011%\u0001-\u0001\u0006pkR\u0004X\u000f^%oM>DQ\u0001\u001d\u0001\u0005\u0002E\f1!^:f)\u00119'o^=\t\u000bM|\u0007\u0019\u0001;\u0002\r\u0005lw.\u001e8u!\tiQ/\u0003\u0002w\u001d\t1Ai\\;cY\u0016DQ\u0001_8A\u0002\u0005\f\u0001b]5nk2\fG/\u001a\u0005\u0006u>\u0004\raW\u0001\u0006kN\fw-\u001a\u0005\u0006y\u0002!\t!`\u0001\u0004O\u0016$HCA4\u007f\u0011\u0015\u00198\u00101\u0001u\u0011\u0019\t\t\u0001\u0001C\u0001M\u0006!A/[2l\u0011\u0019\t)\u0001\u0001C\u0005M\u0006I\u0001O]5oi&sgm\u001c\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0003)9W\r^!oIRK7m\u001b\u000b\u0004O\u00065\u0001BB:\u0002\b\u0001\u0007A\u000f\u0003\u0004\u0002\u0012\u0001!\tAZ\u0001\u0007M&t\u0017n\u001d5\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u001aA!\u00111DA\u0011\u001d\ri\u0011QD\u0005\u0004\u0003?q\u0011A\u0002)sK\u0012,g-C\u0002&\u0003GQ1!a\b\u000f\u0001")
public class EnergyDebug {
    private final APowerTile tile;
    private final String tileName;
    private final long[] got;
    private final long[] used;
    private int gotCount;
    private int usedCount;
    private long totalUsed;
    private long uLastTick;
    private long gLastTick;
    private long lastOutput;
    private final long mj;
    private final Stopwatch stopWatch;
    private long startTime;
    private final Map<EnergyUsage, Object> usageMap;

    public boolean started() {
        return this.stopWatch.isRunning();
    }

    public void start() {
        if (this.started()) {
            return;
        }
        this.stopWatch.start();
        this.startTime = this.getTime();
    }

    private long getTime() {
        return this.tile.func_145831_w().func_82737_E();
    }

    private boolean outputInfo() {
        return Config$.MODULE$.content().debug() && this.tile.isOutputEnergyInfo();
    }

    public void use(double amount, boolean simulate, EnergyUsage usage) {
        if (this.outputInfo() && !simulate) {
            if (!this.started()) {
                this.start();
            }
            long tick = this.getTime();
            long energy = Math.round(amount * (double)1000000L);
            if (tick == this.uLastTick) {
                int n = this.usedCount - 1;
                this.used[n] = this.used[n] + energy;
            } else {
                ++this.usedCount;
                this.used[this.usedCount - 1] = energy;
                this.uLastTick = tick;
            }
            this.totalUsed += energy;
            this.usageMap.update((Object)usage, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.usageMap.getOrElse((Object)usage, (Function0)new Serializable(this){

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            })) + energy)));
            return;
        }
    }

    public void get(double amount) {
        if (this.outputInfo()) {
            long tick = this.getTime();
            long energy = Math.round(amount * (double)1000000L);
            if (tick == this.gLastTick) {
                int n = this.gotCount - 1;
                this.got[n] = this.got[n] + energy;
            } else {
                ++this.gotCount;
                if (this.gotCount > 100) {
                    Predef$.MODULE$.print((Object)BoxesRunTime.boxToInteger((int)this.gotCount));
                    return;
                }
                this.got[this.gotCount - 1] = energy;
                this.gLastTick = tick;
            }
            return;
        }
    }

    public void tick() {
        if (this.getTime() - this.lastOutput >= 100L) {
            if (this.lastOutput == 0L) {
                this.usedCount = 0;
                this.gotCount = 0;
                this.lastOutput = this.getTime();
            } else if (this.outputInfo()) {
                this.printInfo();
            }
        }
    }

    private void printInfo() {
        long allUsed = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(this.used).take(this.usedCount)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / 1000000L;
        long allGot = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(this.got).take(this.gotCount)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / 1000000L;
        if (allUsed != 0L || allGot != 0L) {
            if (allUsed == 0L || this.usedCount == 0) {
                if (this.gotCount == 0) {
                    QuarryPlus.LOGGER.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " used 0 MJ, got 0 MJ"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tileName})));
                } else {
                    QuarryPlus.LOGGER.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " used 0 MJ, got ", " in 100 ticks (", " RF/t)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tileName, BoxesRunTime.boxToLong((long)allGot), BoxesRunTime.boxToLong((long)(allGot * 10L / (long)this.gotCount))})));
                }
            } else if (this.gotCount == 0) {
                QuarryPlus.LOGGER.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " used ", " MJ in ", " ticks (", " RF/t), got 0 MJ"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tileName, BoxesRunTime.boxToLong((long)allUsed), BoxesRunTime.boxToInteger((int)this.usedCount), BoxesRunTime.boxToLong((long)(allUsed * 10L / (long)this.usedCount))})));
            } else {
                QuarryPlus.LOGGER.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " used ", " MJ in ", " ticks (", " RF/t), got ", " in ", " ticks (", " RF/t)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tileName, BoxesRunTime.boxToLong((long)allUsed), BoxesRunTime.boxToInteger((int)this.usedCount), BoxesRunTime.boxToLong((long)(allUsed * 10L / (long)this.usedCount)), BoxesRunTime.boxToLong((long)allGot), BoxesRunTime.boxToInteger((int)this.gotCount), BoxesRunTime.boxToLong((long)(allGot * 10L / (long)this.gotCount))})));
            }
        }
        this.usedCount = 0;
        this.gotCount = 0;
        this.lastOutput = this.getTime();
    }

    public void getAndTick(double amount) {
        this.get(amount);
        this.tick();
    }

    public void finish() {
        if (this.started()) {
            this.stopWatch.stop();
            if (this.outputInfo()) {
                this.printInfo();
                long time = this.getTime() - this.startTime;
                QuarryPlus.LOGGER.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " finished its work and took ", ", ", " ticks. Used ", " MJ at ", " RF/t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tileName, this.stopWatch.toString(), BoxesRunTime.boxToLong((long)time), BoxesRunTime.boxToLong((long)(this.totalUsed / 1000000L)), BoxesRunTime.boxToLong((long)(this.totalUsed * 10L / time / 1000000L))})));
                this.usageMap.foreach((Function1)new Serializable(this){

                    public final void apply(Tuple2<EnergyUsage, Object> x0$1) {
                        Tuple2<EnergyUsage, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            EnergyUsage usage = (EnergyUsage)((Object)tuple2._1());
                            long amount = tuple2._2$mcJ$sp();
                            QuarryPlus.LOGGER.info(new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)((Object)usage)), " used ")).append((Object)BoxesRunTime.boxToLong((long)(amount / 1000000L))).append((Object)"MJ.").toString());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                });
                this.usageMap.clear();
                this.totalUsed = 0L;
                this.startTime = 0L;
                this.uLastTick = 0L;
                this.gLastTick = 0L;
                this.lastOutput = 0L;
            }
            this.stopWatch.reset();
            return;
        }
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Debugger for ", ". ", " t: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tileName, this.stopWatch, BoxesRunTime.boxToLong((long)this.totalUsed)}));
    }

    public EnergyDebug(APowerTile tile) {
        this.tile = tile;
        this.tileName = ((Object)((Object)tile)).getClass().getSimpleName();
        this.got = (long[])Array$.MODULE$.ofDim(100, ClassTag$.MODULE$.Long());
        this.used = (long[])Array$.MODULE$.ofDim(100, ClassTag$.MODULE$.Long());
        this.gotCount = 0;
        this.usedCount = 0;
        this.totalUsed = 0L;
        this.uLastTick = 0L;
        this.gLastTick = 0L;
        this.lastOutput = 0L;
        this.stopWatch = Stopwatch.createUnstarted();
        this.startTime = 0L;
        this.usageMap = Map$.MODULE$.empty();
    }
}

