/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.tile.APacketTile;
import com.yogpc.qp.tile.TileExpPump;
import com.yogpc.qp.tile.TilePump;
import com.yogpc.qp.tile.TileReplacer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public interface IAttachment {
    public void setConnectTo(@Nullable EnumFacing var1);

    public static class Attachments<T extends APacketTile>
    implements Predicate<TileEntity>,
    Function<TileEntity, Optional<T>> {
        public static final Attachments<TilePump> FLUID_PUMP = new Attachments("FLUID_PUMP", (APacketTile[])new TilePump[0]);
        public static final Attachments<TileExpPump> EXP_PUMP = new Attachments("EXP_PUMP", (APacketTile[])new TileExpPump[0]);
        public static final Attachments<TileReplacer> REPLACER = new Attachments("REPLACER", (APacketTile[])new TileReplacer[0]);
        public static final Set<Attachments<? extends APacketTile>> ALL = Collections.unmodifiableSet(Arrays.stream(Attachments.class.getDeclaredFields()).filter(field -> field.getType() == Attachments.class).map(field -> {
            try {
                return (Attachments)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet()));
        @Nonnull
        private final String name;
        @Nonnull
        private final Class<T> clazz;

        private Attachments(@Nonnull String name, T ... ts) {
            this.name = name;
            this.clazz = ts.getClass().getComponentType();
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Optional<T> apply(TileEntity tileEntity) {
            if (this.clazz.isInstance(tileEntity)) {
                return Optional.of(this.clazz.cast(tileEntity));
            }
            return Optional.empty();
        }

        @Override
        public boolean test(TileEntity tileEntity) {
            return this.clazz.isInstance(tileEntity);
        }

        static {
            assert (!ALL.isEmpty());
        }
    }
}

