/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.tile.APowerTile;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.mj.IMjReceiver", modid="buildcraftlib"), @Optional.Interface(iface="buildcraft.api.mj.IMjReadable", modid="buildcraftlib")})
public class MjReceiver
implements IMjReceiver,
IMjReadable {
    private final APowerTile tile;
    private static final Constructor<?> CONSTRUCTOR;

    public static Object mjCapabilityHelper(APowerTile tile) {
        if (CONSTRUCTOR == null) {
            return null;
        }
        try {
            return CONSTRUCTOR.newInstance(new MjReceiver(tile));
        }
        catch (ReflectiveOperationException e) {
            if (Config.content().debug()) {
                QuarryPlus.LOGGER.error(MjReceiver.class.getSimpleName(), (Throwable)e);
            }
            return null;
        }
    }

    @Optional.Method(modid="buildcraftlib")
    public static double getMJFromMicro(long microJoules) {
        return (double)microJoules / (double)MjAPI.MJ;
    }

    private MjReceiver(APowerTile tile) {
        this.tile = tile;
    }

    @Optional.Method(modid="buildcraftlib")
    public long getStored() {
        return (long)(this.tile.getStoredEnergy() * (double)MjAPI.MJ);
    }

    @Optional.Method(modid="buildcraftlib")
    public long getCapacity() {
        return (long)(this.tile.getMaxStored() * (double)MjAPI.MJ);
    }

    @Optional.Method(modid="buildcraftlib")
    public long getPowerRequested() {
        return (long)(Math.min(this.tile.maxGot - this.tile.got, this.tile.getMaxStored() - this.tile.getStoredEnergy() - this.tile.got) * (double)MjAPI.MJ);
    }

    @Optional.Method(modid="buildcraftlib")
    public long receivePower(long microJoules, boolean simulate) {
        if (this.tile.canReceive()) {
            return (long)((double)microJoules - this.tile.getEnergy(MjReceiver.getMJFromMicro(microJoules), !simulate) * (double)MjAPI.MJ);
        }
        return microJoules;
    }

    @Optional.Method(modid="buildcraftlib")
    public boolean canConnect(@Nonnull IMjConnector other) {
        return true;
    }

    static {
        Constructor<?> temp;
        boolean b = Loader.isModLoaded((String)"buildcraftlib");
        if (b) {
            try {
                temp = Class.forName("buildcraft.api.mj.MjCapabilityHelper").getConstructor(Class.forName("buildcraft.api.mj.IMjConnector"));
            }
            catch (ReflectiveOperationException e) {
                if (Config.content().debug()) {
                    QuarryPlus.LOGGER.error(MjReceiver.class.getSimpleName(), (Throwable)e);
                }
                temp = null;
            }
        } else {
            temp = null;
        }
        CONSTRUCTOR = temp;
    }
}

