/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.google.common.collect.ImmutableMap;
import com.yogpc.qp.Config;
import com.yogpc.qp.PowerManager;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.BlockPump;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.pump.Mappings;
import com.yogpc.qp.packet.pump.Now;
import com.yogpc.qp.tile.APacketTile;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.IAttachable;
import com.yogpc.qp.tile.IAttachment;
import com.yogpc.qp.tile.IDebugSender;
import com.yogpc.qp.tile.IDummyFluidHandler;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.TileQuarry;
import com.yogpc.qp.version.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import scala.Symbol;

public class TilePump
extends APacketTile
implements IEnchantableTile,
ITickable,
IDebugSender,
IAttachment {
    @Nullable
    public EnumFacing connectTo = null;
    private boolean initialized = false;
    private EnumFacing preFacing;
    protected byte unbreaking;
    protected byte fortune;
    protected boolean silktouch;
    private final List<FluidStack> liquids = new ArrayList<FluidStack>();
    public final EnumMap<EnumFacing, LinkedList<String>> mapping = new EnumMap(EnumFacing.class);
    public final EnumMap<EnumFacing, PumpTank> tankMap = new EnumMap(EnumFacing.class);
    private static final int Y_SIZE = 256;
    private static final int CHUNK_SCALE = 16;
    private byte[][][] blocks;
    private ExtendedBlockStorage[][][] storageArray;
    private int xOffset;
    private int yOffset;
    private int zOffset;
    private int px;
    private int py;
    private int cx;
    private int cy;
    private int cz;
    private byte range;
    private boolean quarryRange;
    private boolean autoChangedRange;
    private int block_side_x;
    private int block_side_z;
    private static final int ARRAY_MAX = 524288;
    private static final int[] xb = new int[524288];
    private static final int[] yb = new int[524288];
    private static final int[] zb = new int[524288];
    private static int cp = 0;
    private long fwt;
    private final IFluidHandler tankAll;

    public TilePump() {
        for (EnumFacing value : EnumFacing.field_82609_l) {
            this.tankMap.put(value, new PumpTank(value));
            this.mapping.put(value, new LinkedList());
        }
        this.py = Integer.MIN_VALUE;
        this.cy = -1;
        this.range = 0;
        this.quarryRange = true;
        this.autoChangedRange = false;
        this.tankAll = () -> {
            IFluidTankProperties[] array = (IFluidTankProperties[])this.liquids.stream().map(fluidStack -> new FluidTankProperties(fluidStack, fluidStack.amount, false, false)).toArray(IFluidTankProperties[]::new);
            return array.length == 0 ? IDummyFluidHandler.emptyPropertyArray : array;
        };
    }

    public IAttachable G_connected() {
        if (this.connectTo != null) {
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.connectTo));
            if (te instanceof IAttachable) {
                return (IAttachable)te;
            }
            this.setConnectTo(null);
            if (!this.func_145831_w().field_72995_K) {
                this.S_sendNowPacket();
            }
            return null;
        }
        return null;
    }

    public boolean G_working() {
        return this.py >= this.cy;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.silktouch = nbt.func_74767_n("silktouch");
        this.fortune = nbt.func_74771_c("fortune");
        this.unbreaking = nbt.func_74771_c("unbreaking");
        if (nbt.func_74764_b("connectTo")) {
            this.setConnectTo(EnumFacing.func_82600_a((int)nbt.func_74771_c("connectTo")));
            this.preFacing = this.connectTo;
        }
        if (nbt.func_74781_a("mapping0") instanceof NBTTagList) {
            for (int i = 0; i < this.mapping.size(); ++i) {
                TilePump.readStringCollection(nbt.func_150295_c("mapping" + i, 8), (Collection<String>)this.mapping.get(EnumFacing.func_82600_a((int)i)));
            }
        }
        this.range = nbt.func_74771_c("range");
        this.quarryRange = nbt.func_74767_n("quarryRange");
        this.autoChangedRange = nbt.func_74767_n("autoChangedRange");
        if (this.silktouch) {
            this.liquids.clear();
            NBTTagList liquids = nbt.func_150295_c("liquids", 10);
            for (int i = 0; i < liquids.func_74745_c(); ++i) {
                this.liquids.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)liquids.func_150305_b(i)));
            }
        }
    }

    private static void readStringCollection(NBTTagList list, Collection<String> target) {
        target.clear();
        IntStream.range(0, list.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)list).func_150307_f(arg_0)).forEach(target::add);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("silktouch", this.silktouch);
        nbt.func_74774_a("fortune", this.fortune);
        nbt.func_74774_a("unbreaking", this.unbreaking);
        if (this.connectTo != null) {
            nbt.func_74774_a("connectTo", (byte)this.connectTo.ordinal());
        }
        for (int i = 0; i < this.mapping.size(); ++i) {
            nbt.func_74782_a("mapping" + i, (NBTBase)TilePump.writeStringCollection((Collection<String>)this.mapping.get(EnumFacing.func_82600_a((int)i))));
        }
        nbt.func_74774_a("range", this.range);
        nbt.func_74757_a("quarryRange", this.quarryRange);
        nbt.func_74757_a("autoChangedRange", this.autoChangedRange);
        if (this.silktouch) {
            NBTTagList list = new NBTTagList();
            for (FluidStack l : this.liquids) {
                list.func_74742_a((NBTBase)l.writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("liquids", (NBTBase)list);
        }
        return super.func_189515_b(nbt);
    }

    private static NBTTagList writeStringCollection(Collection<String> target) {
        NBTTagList list = new NBTTagList();
        target.stream().map(NBTTagString::new).forEach(arg_0 -> ((NBTTagList)list).func_74742_a(arg_0));
        return list;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos offset = this.func_174877_v().func_177972_a(facing);
                IBlockState state = this.func_145831_w().func_180495_p(offset);
                if (!state.func_177230_c().hasTileEntity(state)) continue;
                Optional.ofNullable(this.func_145831_w().func_175625_s(offset)).filter(t -> t.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())).map(t -> (IFluidHandler)t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())).ifPresent(handler -> {
                    int fill;
                    PumpTank tank = this.tankMap.get(facing);
                    FluidStack resource = tank.drain(1000, false);
                    if (resource != null && (fill = handler.fill(resource, false)) > 0) {
                        handler.fill(tank.drain(fill, true), true);
                    }
                });
            }
            if (!this.initialized && this.connectTo != null) {
                TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.connectTo));
                if (te instanceof IAttachable && ((IAttachable)te).connect(this.connectTo.func_176734_d(), IAttachment.Attachments.FLUID_PUMP)) {
                    this.S_sendNowPacket();
                    this.initialized = true;
                } else if (this.func_145831_w().func_175623_d(this.func_174877_v().func_177972_a(this.connectTo))) {
                    this.setConnectTo(null);
                    this.S_sendNowPacket();
                    this.initialized = true;
                }
            }
        }
    }

    @Override
    public void G_ReInit() {
        if (!this.func_145831_w().field_72995_K) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing));
                if (!(te instanceof IAttachable) || !((IAttachable)te).connect(facing.func_176734_d(), IAttachment.Attachments.FLUID_PUMP)) continue;
                this.setConnectTo(facing);
                this.S_sendNowPacket();
                return;
            }
            this.setConnectTo(null);
            this.S_sendNowPacket();
        }
    }

    private void S_sendNowPacket() {
        if (this.preFacing != this.connectTo || ((Boolean)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockPump.ACTING)).booleanValue() != this.G_working()) {
            this.preFacing = this.connectTo;
            PacketHandler.sendToAround(Now.create(this), this.func_145831_w(), this.func_174877_v());
        }
    }

    @Override
    public void setConnectTo(@Nullable EnumFacing connectTo) {
        IBlockState state;
        this.connectTo = connectTo;
        if (this.func_145830_o() && connectTo != null ^ (Boolean)(state = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177229_b((IProperty)BlockPump.CONNECTED)) {
            InvUtils.setNewState(this.func_145831_w(), this.func_174877_v(), this, state.func_177226_a((IProperty)BlockPump.CONNECTED, (Comparable)Boolean.valueOf(connectTo != null)));
        }
    }

    public void setWorking(boolean b) {
        if (b) {
            this.py = -1;
            this.cy = -1;
        } else {
            this.py = Integer.MIN_VALUE;
        }
        if (!this.func_145831_w().field_72995_K) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            InvUtils.setNewState(this.func_145831_w(), this.func_174877_v(), this, state.func_177226_a((IProperty)BlockPump.ACTING, (Comparable)Boolean.valueOf(b)));
        }
    }

    public void S_OpenGUI(EnumFacing facing, EntityPlayer ep) {
        PacketHandler.sendToClient(Mappings.All.create(this, facing), (EntityPlayerMP)ep);
    }

    public void S_changeRange(EntityPlayer ep) {
        if (this.range >= (this.fortune + 1) * 2) {
            if (this.G_connected() instanceof TileQuarry) {
                this.quarryRange = true;
            }
            this.range = 0;
        } else if (this.quarryRange) {
            this.quarryRange = false;
        } else {
            this.range = (byte)(this.range + 1);
        }
        if (this.quarryRange) {
            VersionUtil.sendMessage(ep, (ITextComponent)new TextComponentTranslation("chat.pump_rtoggle.quarry", new Object[0]));
        } else {
            VersionUtil.sendMessage(ep, (ITextComponent)new TextComponentTranslation("chat.pump_rtoggle.num", new Object[]{Integer.toString(this.range * 2 + 1)}));
        }
        this.fwt = 0L;
    }

    private static void S_put(int x, int y, int z) {
        TilePump.xb[TilePump.cp] = x;
        TilePump.yb[TilePump.cp] = y;
        TilePump.zb[TilePump.cp] = z;
        if (++cp == 524288) {
            cp = 0;
        }
    }

    private void S_searchLiquid(int x, int y, int z) {
        int chunk_side_z;
        int chunk_side_x;
        this.fwt = this.func_145831_w().func_72820_D();
        int cg = 0;
        cp = 0;
        this.cx = x;
        this.cy = y;
        this.cz = z;
        this.yOffset = y & 0xFFFFFFF0;
        this.py = 255;
        this.px = -1;
        IAttachable tb = this.G_connected();
        TileQuarry b = null;
        if (tb instanceof TileQuarry) {
            b = (TileQuarry)tb;
        }
        if (b != null && b.yMax != Integer.MIN_VALUE) {
            int z_add;
            chunk_side_x = 1 + (b.xMax >> 4) - (b.xMin >> 4);
            chunk_side_z = 1 + (b.zMax >> 4) - (b.zMin >> 4);
            this.xOffset = b.xMin & 0xFFFFFFF0;
            this.zOffset = b.zMin & 0xFFFFFFF0;
            int x_add = this.range * 2 + 1 - chunk_side_x;
            if (x_add > 0) {
                chunk_side_x += x_add;
                this.xOffset -= ((x_add & 0xFFFFFFFE) << 3) + (x_add % 2 != 0 && (b.xMax + b.xMin + 1) / 2 % 16 <= 8 ? 16 : 0);
            }
            if ((z_add = this.range * 2 + 1 - chunk_side_z) > 0) {
                chunk_side_z += z_add;
                this.zOffset -= ((z_add & 0xFFFFFFFE) << 3) + (z_add % 2 != 0 && (b.zMax + b.zMin + 1) / 2 % 16 <= 8 ? 16 : 0);
            }
        } else {
            this.quarryRange = false;
            chunk_side_x = chunk_side_z = 1 + this.range * 2;
            this.xOffset = (x >> 4) - this.range << 4;
            this.zOffset = (z >> 4) - this.range << 4;
        }
        if (!this.quarryRange) {
            b = null;
        }
        this.block_side_x = chunk_side_x * 16;
        this.block_side_z = chunk_side_z * 16;
        this.blocks = new byte[256 - this.yOffset][this.block_side_x][this.block_side_z];
        this.storageArray = new ExtendedBlockStorage[chunk_side_x][chunk_side_z][];
        for (int kx = 0; kx < chunk_side_x; ++kx) {
            for (int kz = 0; kz < chunk_side_z; ++kz) {
                this.storageArray[kx][kz] = this.func_145831_w().func_72863_F().func_186025_d(kx + (this.xOffset >> 4), kz + (this.zOffset >> 4)).func_76587_i();
            }
        }
        TilePump.S_put(x - this.xOffset, y, z - this.zOffset);
        while (cp != cg) {
            ExtendedBlockStorage ebs_c = this.storageArray[xb[cg] >> 4][zb[cg] >> 4][yb[cg] >> 4];
            if (ebs_c != null) {
                IBlockState b_c = ebs_c.func_177485_a(xb[cg] & 0xF, yb[cg] & 0xF, zb[cg] & 0xF);
                if (this.blocks[yb[cg] - this.yOffset][xb[cg]][zb[cg]] == 0 && TilePump.isLiquid(b_c)) {
                    this.blocks[TilePump.yb[cg] - this.yOffset][TilePump.xb[cg]][TilePump.zb[cg]] = 63;
                    if ((b != null ? b.xMin & 0xF : 0) < xb[cg]) {
                        TilePump.S_put(xb[cg] - 1, yb[cg], zb[cg]);
                    } else {
                        this.blocks[TilePump.yb[cg] - this.yOffset][TilePump.xb[cg]][TilePump.zb[cg]] = 127;
                    }
                    if (xb[cg] < (b != null ? b.xMax - this.xOffset : this.block_side_x - 1)) {
                        TilePump.S_put(xb[cg] + 1, yb[cg], zb[cg]);
                    } else {
                        this.blocks[TilePump.yb[cg] - this.yOffset][TilePump.xb[cg]][TilePump.zb[cg]] = 127;
                    }
                    if ((b != null ? b.zMin & 0xF : 0) < zb[cg]) {
                        TilePump.S_put(xb[cg], yb[cg], zb[cg] - 1);
                    } else {
                        this.blocks[TilePump.yb[cg] - this.yOffset][TilePump.xb[cg]][TilePump.zb[cg]] = 127;
                    }
                    if (zb[cg] < (b != null ? b.zMax - this.zOffset : this.block_side_z - 1)) {
                        TilePump.S_put(xb[cg], yb[cg], zb[cg] + 1);
                    } else {
                        this.blocks[TilePump.yb[cg] - this.yOffset][TilePump.xb[cg]][TilePump.zb[cg]] = 127;
                    }
                    if (yb[cg] + 1 < 256) {
                        TilePump.S_put(xb[cg], yb[cg] + 1, zb[cg]);
                    }
                }
            }
            if (++cg != 524288) continue;
            cg = 0;
        }
    }

    boolean S_removeLiquids(APowerTile tile, int x, int y, int z) {
        int bz;
        int bx;
        this.S_sendNowPacket();
        if (this.cx != x || this.cy != y || this.cz != z || this.py < this.cy || this.func_145831_w().func_72820_D() - this.fwt > 200L) {
            this.S_searchLiquid(x, y, z);
        } else {
            this.storageArray = new ExtendedBlockStorage[this.storageArray.length][this.storageArray[0].length][];
            for (int kx = 0; kx < this.storageArray.length; ++kx) {
                for (int kz = 0; kz < this.storageArray[0].length; ++kz) {
                    this.storageArray[kx][kz] = this.func_145831_w().func_72863_F().func_186025_d(kx + (this.xOffset >> 4), kz + (this.zOffset >> 4)).func_76587_i();
                }
            }
        }
        int count = 0;
        while (true) {
            if (this.px == -1) {
                for (bx = 0; bx < this.block_side_x; ++bx) {
                    for (bz = 0; bz < this.block_side_z; ++bz) {
                        IBlockState bb;
                        if ((this.blocks[this.py - this.yOffset][bx][bz] & 0x40) == 0 || !TilePump.isLiquid(bb = this.storageArray[bx >> 4][bz >> 4][this.py >> 4].func_177485_a(bx & 0xF, this.py & 0xF, bz & 0xF))) continue;
                        ++count;
                    }
                }
            } else {
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (bz = 0; bz < this.block_side_z; ++bz) {
                    if (this.blocks[this.py - this.yOffset][this.px][bz] == 0) continue;
                    IBlockState bb = this.storageArray[this.px >> 4][bz >> 4][this.py >> 4].func_177485_a(this.px & 0xF, this.py & 0xF, bz & 0xF);
                    mutableBlockPos.func_181079_c(this.px + this.xOffset, this.py, bz + this.zOffset);
                    if (!TilePump.isLiquid(bb, Config.content().removeOnlySource(), this.func_145831_w(), (BlockPos)mutableBlockPos)) continue;
                    ++count;
                }
            }
            if (count <= 0 && ++this.px < this.block_side_x) continue;
            if (count > 0) break;
            this.px = -1;
            if (--this.py < this.cy) break;
        }
        if (count > 0 && PowerManager.useEnergyPump(tile, this.unbreaking, count, this.px == -1 ? (long)count : 0L)) {
            if (this.px == -1) {
                for (bx = 0; bx < this.block_side_x; ++bx) {
                    for (bz = 0; bz < this.block_side_z; ++bz) {
                        if ((this.blocks[this.py - this.yOffset][bx][bz] & 0x40) == 0) continue;
                        this.drainBlock(bx, bz, QuarryPlusI.blockFrame().getDammingState());
                        if (!(tile instanceof TileQuarry)) continue;
                        TileQuarry quarry = (TileQuarry)tile;
                        int xTarget = bx + this.xOffset;
                        int zTarget = bz + this.zOffset;
                        if (quarry.G_getNow() != TileQuarry.Mode.NOT_NEED_BREAK) {
                            if (Config.content().debug() && quarry.xMin < xTarget && xTarget < quarry.xMax && quarry.zMin < zTarget && zTarget < quarry.zMax) {
                                QuarryPlus.LOGGER.warn(String.format("Quarry placed frame at %d, %d, %d", xTarget, this.py, zTarget));
                            }
                            this.autoChange(false);
                            continue;
                        }
                        if (quarry.xMin > xTarget || xTarget > quarry.xMax || quarry.zMin > zTarget || zTarget > quarry.zMax) continue;
                        if (Config.content().debug()) {
                            QuarryPlus.LOGGER.warn(String.format("Quarry placed frame at %d, %d, %d", xTarget, this.py, zTarget));
                        }
                        this.autoChange(true);
                    }
                }
            } else {
                for (bz = 0; bz < this.block_side_z; ++bz) {
                    if (this.blocks[this.py - this.yOffset][this.px][bz] == 0) continue;
                    this.drainBlock(this.px, bz, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        this.S_sendNowPacket();
        return this.py < this.cy;
    }

    private void autoChange(boolean on) {
        if (on) {
            this.autoChangedRange = true;
            this.quarryRange = false;
        } else if (this.autoChangedRange) {
            this.autoChangedRange = false;
            this.quarryRange = true;
        }
    }

    public static boolean isLiquid(@Nonnull IBlockState state, boolean findSource, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            return !findSource || ((IFluidBlock)block).canDrain(world, pos);
        }
        return !(block != Blocks.field_150355_j && block != Blocks.field_150358_i && block != Blocks.field_150353_l && block != Blocks.field_150356_k || findSource && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0);
    }

    public static boolean isLiquid(@Nonnull IBlockState state) {
        return TilePump.isLiquid(state, false, null, null);
    }

    @Override
    protected Symbol getSymbol() {
        return Symbol.apply((String)"PumpPlus");
    }

    private void drainBlock(int bx, int bz, IBlockState tb) {
        if (TilePump.isLiquid(this.storageArray[bx >> 4][bz >> 4][this.py >> 4].func_177485_a(bx & 0xF, this.py & 0xF, bz & 0xF))) {
            BlockPos blockPos = new BlockPos(bx + this.xOffset, this.py, bz + this.zOffset);
            IFluidHandler handler = FluidUtil.getFluidHandler((World)this.func_145831_w(), (BlockPos)blockPos, (EnumFacing)EnumFacing.UP);
            if (handler != null) {
                FluidStack stack = handler.drain(1000, true);
                if (stack != null) {
                    int index = this.liquids.indexOf(stack);
                    if (index != -1) {
                        this.liquids.get((int)index).amount += stack.amount;
                    } else {
                        this.liquids.add(stack);
                    }
                }
                this.func_145831_w().func_175656_a(blockPos, tb);
            }
        }
    }

    public List<ITextComponent> C_getNames() {
        if (!this.liquids.isEmpty()) {
            ArrayList<ITextComponent> list = new ArrayList<ITextComponent>(this.liquids.size() + 1);
            list.add((ITextComponent)new TextComponentTranslation("chat.pumpcontain", new Object[0]));
            this.liquids.forEach(s -> list.add((ITextComponent)new TextComponentTranslation("yog.pump.liquid", new Object[]{new TextComponentTranslation(s.getUnlocalizedName(), new Object[0]), Integer.toString(s.amount)})));
            return list;
        }
        return Collections.singletonList(new TextComponentTranslation("chat.pumpcontainno", new Object[0]));
    }

    public List<ITextComponent> getDebugMessages() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)toComponentString.apply("Connection : " + this.connectTo));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.mapping.get(facing).stream().reduce(combiner).map(toComponentString).ifPresent(list::add);
        }
        if (!this.liquids.isEmpty()) {
            list.add((ITextComponent)new TextComponentTranslation("chat.pumpcontain", new Object[0]));
            this.liquids.stream().map(fluidStack -> fluidStack.getLocalizedName() + fluidStack.amount + "mB").reduce(combiner).map(toComponentString).ifPresent(list::add);
        } else {
            list.add((ITextComponent)new TextComponentTranslation("chat.pumpcontainno", new Object[0]));
        }
        return list;
    }

    @Override
    public String getDebugName() {
        return "tile.pumpplus.name";
    }

    public ImmutableMap<Integer, Integer> getEnchantments() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.fortune > 0) {
            builder.put((Object)FortuneID, (Object)this.fortune);
        }
        if (this.unbreaking > 0) {
            builder.put((Object)UnbreakingID, (Object)this.unbreaking);
        }
        if (this.silktouch) {
            builder.put((Object)SilktouchID, (Object)1);
        }
        return builder.build();
    }

    @Override
    public void setEnchantment(short id, short val) {
        if (id == FortuneID) {
            this.fortune = (byte)val;
        } else if (id == UnbreakingID) {
            this.unbreaking = (byte)val;
        } else if (id == SilktouchID) {
            this.silktouch = val > 0;
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)(facing == null ? this.tankAll : (IFluidHandler)this.tankMap.get(facing)));
        }
        return (T)super.getCapability(capability, facing);
    }

    private class PumpTank
    extends FluidTank {
        final EnumFacing facing;

        private PumpTank(EnumFacing facing) {
            super(Integer.MAX_VALUE);
            this.facing = facing;
            this.setCanFill(false);
            this.setTileEntity(TilePump.this);
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || resource.amount <= 0) {
                return null;
            }
            int index = TilePump.this.liquids.indexOf(resource);
            if (index == -1) {
                return null;
            }
            FluidStack fs = (FluidStack)TilePump.this.liquids.get(index);
            if (fs == null) {
                return null;
            }
            int drained = Math.min(fs.amount, resource.amount);
            FluidStack ret = new FluidStack(fs, drained);
            if (doDrain) {
                this.doDrain(() -> TilePump.this.liquids.remove(fs), fs, ret.amount);
            }
            return ret;
        }

        public IFluidTankProperties[] getTankProperties() {
            LinkedList<FluidTankProperties> ret = new LinkedList<FluidTankProperties>();
            if (TilePump.this.mapping.get(this.facing).isEmpty()) {
                if (TilePump.this.liquids.isEmpty()) {
                    return IDummyFluidHandler.emptyPropertyArray;
                }
                for (FluidStack fs : TilePump.this.liquids) {
                    ret.add(new FluidTankProperties(fs, Integer.MAX_VALUE, false, true));
                }
            } else {
                for (String s : TilePump.this.mapping.get(this.facing)) {
                    Optional.ofNullable(FluidRegistry.getFluidStack((String)s, (int)0)).ifPresent(fluidStack -> {
                        int index = TilePump.this.liquids.indexOf(fluidStack);
                        if (index != -1) {
                            ret.add(new FluidTankProperties((FluidStack)TilePump.this.liquids.get(index), Integer.MAX_VALUE, false, true));
                        } else {
                            ret.add(new FluidTankProperties(fluidStack, Integer.MAX_VALUE, false, true));
                        }
                    });
                }
            }
            return (IFluidTankProperties[])ret.toArray(new FluidTankProperties[0]);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (TilePump.this.mapping.get(this.facing).isEmpty()) {
                return TilePump.this.liquids.isEmpty() ? null : this.drainI(0, maxDrain, doDrain);
            }
            for (String s : TilePump.this.mapping.get(this.facing)) {
                int index;
                FluidStack fs = FluidRegistry.getFluidStack((String)s, (int)maxDrain);
                if (fs == null || (index = TilePump.this.liquids.indexOf(fs)) == -1) continue;
                return this.drainI(index, maxDrain, doDrain);
            }
            return null;
        }

        private FluidStack drainI(int index, int maxDrain, boolean doDrain) {
            FluidStack stack = (FluidStack)TilePump.this.liquids.get(index);
            int drained = Math.min(maxDrain, stack.amount);
            FluidStack ret = new FluidStack(stack, drained);
            if (doDrain) {
                this.doDrain(() -> {
                    FluidStack cfr_ignored_0 = (FluidStack)TilePump.this.liquids.remove(index);
                }, stack, drained);
            }
            return ret;
        }

        private void doDrain(Runnable remove, FluidStack stack, int drained) {
            stack.amount -= drained;
            if (stack.amount <= 0) {
                remove.run();
            }
            this.onContentsChanged();
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(stack.amount <= 0 ? null : stack, TilePump.this.func_145831_w(), TilePump.this.func_174877_v(), (IFluidTank)this, drained));
        }
    }
}

