/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.block.BlockSolidQuarry;
import com.yogpc.qp.tile.TileQuarry;
import com.yogpc.qp.version.VersionUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import scala.Symbol;

public class TileSolidQuarry
extends TileQuarry {
    private static final double fuelEfficiency = 4.0;
    private ItemStack fuel = VersionUtil.empty();
    private int fuelCount = 0;

    @Override
    public boolean canReceive() {
        return false;
    }

    @Override
    protected void S_updateEntity() {
        if (this.machineDisabled) {
            return;
        }
        if (this.fuelCount > 0) {
            --this.fuelCount;
            this.getEnergy(4.0, true);
        } else {
            int burn = TileEntityFurnace.func_145952_a((ItemStack)this.fuel) / 5;
            if (burn > 0) {
                this.fuelCount += burn;
                this.func_70298_a(0, 1);
            }
        }
        super.S_updateEntity();
    }

    @Override
    protected IBlockState S_getFillBlock() {
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fuelCount = nbt.func_74762_e("fuelCount");
        this.fuel = VersionUtil.fromNBTTag(nbt.func_74775_l("fuel"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("fuelCount", this.fuelCount);
        nbt.func_74782_a("fuel", (NBTBase)this.fuel.serializeNBT());
        return super.func_189515_b(nbt);
    }

    @Override
    protected Symbol getSymbol() {
        return BlockSolidQuarry.SYMBOL;
    }

    @Override
    public String getDebugName() {
        return "tile.solidquarry.name";
    }

    @Override
    public String func_70005_c_() {
        return "tile.solidquarry.name";
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this;
    }

    @Override
    public int func_70302_i_() {
        return 2;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        if (i == 0) {
            return this.fuel;
        }
        return super.func_70301_a(i - 1);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        if (index == 0) {
            ItemStack temp = this.fuel;
            this.fuel = VersionUtil.empty();
            return temp;
        }
        return super.func_70304_b(index - 1);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (index == 0) {
            this.fuel = stack;
        } else {
            super.func_70299_a(index - 1, stack);
        }
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        if (index == 0) {
            if (VersionUtil.getCount(this.fuel) <= count) {
                return this.func_70304_b(0);
            }
            return this.fuel.func_77979_a(count);
        }
        return super.func_70298_a(index - 1, count);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    @Override
    public void func_174888_l() {
        this.fuel = VersionUtil.empty();
        super.func_174888_l();
    }

    @Override
    public boolean func_191420_l() {
        return super.func_191420_l() && VersionUtil.isEmpty(this.fuel);
    }

    @Override
    public IItemHandlerModifiable createHandler() {
        return new InvWrapper(this){

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return slot == 0 ? ItemStack.field_190927_a : super.extractItem(slot, amount, simulate);
            }
        };
    }

    @Override
    protected boolean isWorking() {
        return super.isWorking() && (this.fuelCount > 0 || VersionUtil.nonEmpty(this.fuel));
    }

    @Override
    public List<ITextComponent> getDebugMessages() {
        List<ITextComponent> list = super.getDebugMessages();
        list.add((ITextComponent)new TextComponentString("FuelCount : " + this.fuelCount));
        return list;
    }
}

