/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;

public class IndexOnlyList<T> {
    private final List<T> tList;
    private final List<BiPredicate<T, Object>> predicates;
    private final int defaultIndex;
    private final Object mutex;

    public IndexOnlyList(@Nonnull List<T> tList, int defaultIndex, @Nonnull Object mutex) {
        this.tList = tList;
        this.defaultIndex = defaultIndex;
        this.mutex = mutex;
        BiPredicate<Object, Object> equals = Object::equals;
        this.predicates = new LinkedList<BiPredicate<T, Object>>();
        this.predicates.add(equals);
    }

    public IndexOnlyList(@Nonnull List<T> tList, @Nonnull Object mutex) {
        this(tList, -1, mutex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o) {
        Object object = this.mutex;
        synchronized (object) {
            for (int i = 0; i < this.tList.size(); ++i) {
                Object item = this.tList.get(i);
                if (!this.predicates.stream().anyMatch(biPredicate -> biPredicate.test(item, o))) continue;
                return i;
            }
            return this.defaultIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        Object object = this.mutex;
        synchronized (object) {
            for (Object item : this.tList) {
                if (!this.predicates.stream().anyMatch(biPredicate -> biPredicate.test(item, o))) continue;
                return true;
            }
            return false;
        }
    }

    public void addPredicate(BiPredicate<T, Object> predicate) {
        this.predicates.add(predicate);
    }
}

