/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class NBTBuilder {
    public static <K, V> NBTTagList fromMap(Map<? extends K, ? extends V> map, String keyName, String valueName, Function<? super K, ? extends NBTBase> keyFunction, Function<? super V, ? extends NBTBase> valueFunction) {
        NBTTagList list = new NBTTagList();
        map.forEach((key, value) -> {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a(keyName, (NBTBase)keyFunction.apply((Object)key));
            compound.func_74782_a(valueName, (NBTBase)valueFunction.apply((Object)value));
            list.func_74742_a((NBTBase)compound);
        });
        return list;
    }

    public static <K, V> Map<K, V> fromList(NBTTagList list, Function<? super NBTTagCompound, ? extends K> keyFunction, Function<? super NBTTagCompound, ? extends V> valueFunction, Predicate<? super K> keyFilter, Predicate<? super V> valuePredicate) {
        HashMap<K, V> map = new HashMap<K, V>(list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound at = list.func_150305_b(i);
            K key = keyFunction.apply((NBTTagCompound)at);
            V value = valueFunction.apply((NBTTagCompound)at);
            if (!keyFilter.test(key) || !valuePredicate.test(value)) continue;
            map.put(key, value);
        }
        return map;
    }

    public static JsonObject fromBlockState(IBlockState state) {
        JsonObject object = new JsonObject();
        object.addProperty("name", Objects.requireNonNull(state.func_177230_c().getRegistryName()).toString());
        JsonObject properties = new JsonObject();
        state.func_177228_b().entrySet().stream().map(MapStreamSyntax.valuesBi(NBTBuilder::getPropertyName)).map(MapStreamSyntax.keys(IProperty::func_177701_a)).forEach(MapStreamSyntax.entry((arg_0, arg_1) -> ((JsonObject)properties).addProperty(arg_0, arg_1)));
        object.add("properties", (JsonElement)properties);
        return object;
    }

    public static Optional<IBlockState> getStateFromJson(JsonObject object) {
        return Optional.ofNullable(ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)object, (String)"name")))).filter(Predicate.isEqual(Blocks.field_150350_a).negate()).map(Block::func_176223_P).map(iBlockState -> {
            IBlockState state = iBlockState;
            JsonObject properties = JsonUtils.func_152754_s((JsonObject)object, (String)"properties");
            Map map = iBlockState.func_177227_a().stream().map(MapStreamSyntax.toEntry(IProperty::func_177701_a, Function.identity())).collect(MapStreamSyntax.entryToMap());
            List collect = properties.entrySet().stream().map(MapStreamSyntax.values(JsonElement::getAsString)).map(MapStreamSyntax.keys(map::get)).filter(MapStreamSyntax.byKey(Objects::nonNull)).map(MapStreamSyntax.valuesBi(IProperty::func_185929_b)).flatMap(e -> ((com.google.common.base.Optional)e.getValue()).asSet().stream().map(MapStreamSyntax.toEntry(o -> (IProperty)e.getKey(), Function.identity()))).collect(Collectors.toList());
            for (Map.Entry e2 : collect) {
                state = NBTBuilder.setValue(state, (IProperty)e2.getKey(), e2.getValue());
            }
            return state;
        });
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> entry) {
        return property.func_177702_a(entry);
    }

    private static <T extends Comparable<T>> IBlockState setValue(IBlockState state, IProperty<T> property, Object entry) {
        return state.func_177226_a(property, (Comparable)entry);
    }
}

