/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.yogpc.qp.QuarryPlus;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ReflectionHelper {
    public static List<Method> getMethods(Class<?> t, Class<? extends Annotation> a) {
        ArrayList<Method> ms = new ArrayList<Method>();
        for (Class<?> c = t; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(a)) continue;
                m.setAccessible(true);
                ms.add(m);
            }
        }
        return ms;
    }

    public static Method getMethod(Class<?> t, String[] sv, Class<?>[] ... av) {
        ArrayList<Exception> ec = new ArrayList<Exception>();
        for (Class<?> c = t; c != null && c != Object.class; c = c.getSuperclass()) {
            for (String element : sv) {
                for (Class<?>[] element2 : av) {
                    try {
                        Method tmp = c.getDeclaredMethod(element, element2);
                        tmp.setAccessible(true);
                        return tmp;
                    }
                    catch (Exception e) {
                        ec.add(e);
                    }
                }
            }
        }
        for (Exception e : ec) {
            e.printStackTrace();
        }
        return null;
    }

    public static Field getField(Class<?> t, String ... sv) {
        ArrayList<Exception> ec = new ArrayList<Exception>();
        for (Class<?> c = t; c != null && c != Object.class; c = c.getSuperclass()) {
            for (String s : sv) {
                try {
                    Field tmp = c.getDeclaredField(s);
                    tmp.setAccessible(true);
                    return tmp;
                }
                catch (Exception e) {
                    ec.add(e);
                }
            }
        }
        for (Exception e : ec) {
            e.printStackTrace();
        }
        return null;
    }

    public static Class<?> getClass(String ... sv) {
        ArrayList<Exception> ec = new ArrayList<Exception>();
        for (String s : sv) {
            try {
                return Class.forName(s, false, ReflectionHelper.class.getClassLoader());
            }
            catch (Exception e) {
                ec.add(e);
            }
        }
        for (Exception e : ec) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object invoke(Method m, Object obj, Object ... args) {
        try {
            return m.invoke(obj, args);
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void checkGetDrops(World world, BlockPos pos, IBlockState state, Block block, int fortuneLevel, NonNullList<ItemStack> list) {
        if (block.getClass() == Block.class || block.func_180660_a(state, world.field_73012_v, fortuneLevel) == Items.field_190931_a || block.quantityDropped(state, fortuneLevel, world.field_73012_v) == 0) {
            QuarryPlus.LOGGER.info("Block " + block.getRegistryName() + " has no drops.");
            return;
        }
        for (Class<?> aClass = block.getClass(); Block.class != aClass; aClass = aClass.getSuperclass()) {
            try {
                aClass.getDeclaredMethod("getDrops", IBlockAccess.class, BlockPos.class, IBlockState.class, Integer.TYPE);
                list.addAll((Collection)block.getDrops((IBlockAccess)world, pos, state, fortuneLevel));
                QuarryPlus.LOGGER.info("Block " + block.getRegistryName() + " implements getDrops(IBlockAccess, BlockPos, IBlockState, int).");
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    aClass.getDeclaredMethod("getDrops", NonNullList.class, IBlockAccess.class, BlockPos.class, IBlockState.class, Integer.TYPE);
                    block.getDrops(list, (IBlockAccess)world, pos, state, fortuneLevel);
                    QuarryPlus.LOGGER.info("Block " + block.getRegistryName() + " implements getDrops(NonNullList, IBlockAccess, BlockPos, IBlockState, int).");
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    continue;
                }
            }
        }
        QuarryPlus.LOGGER.info("Block " + block.getRegistryName() + " doesn't implement getDrop.");
    }

    public static List<Path> paths(Path path) {
        try {
            return Files.find(path, Integer.MAX_VALUE, (path1, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path1.getFileName().toString().endsWith(".json"), new FileVisitOption[0]).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }
}

