/*
 * Decompiled with CFR 0.152.
 */
package jp.t2v.lab.syntax;

import java.util.AbstractMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MapStreamSyntax {
    private static final Predicate<Object> ALWAYS_FALSE = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return false;
        }

        @Override
        public Predicate<Object> negate() {
            return ALWAYS_TRUE;
        }

        @Override
        public Predicate<Object> or(Predicate<? super Object> other) {
            return other;
        }

        @Override
        public Predicate<Object> and(Predicate<? super Object> other) {
            return this;
        }
    };
    private static final Predicate<Object> ALWAYS_TRUE = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return true;
        }

        @Override
        public Predicate<Object> negate() {
            return ALWAYS_FALSE;
        }

        @Override
        public Predicate<Object> or(Predicate<? super Object> other) {
            return this;
        }

        @Override
        public Predicate<Object> and(Predicate<? super Object> other) {
            return other;
        }
    };

    public static <E, K, V> Function<E, Map.Entry<K, V>> toEntry(Function<? super E, ? extends K> ketFactory, Function<? super E, ? extends V> valueFactory) {
        return e -> new AbstractMap.SimpleImmutableEntry(ketFactory.apply((Object)e), valueFactory.apply((Object)e));
    }

    public static <K1, V1, R> Function<Map.Entry<K1, V1>, R> toAny(BiFunction<? super K1, ? super V1, ? extends R> f) {
        return e -> f.apply((Object)e.getKey(), (Object)e.getValue());
    }

    public static <K1, K2, V> Function<Map.Entry<K1, V>, Map.Entry<K2, V>> keys(Function<? super K1, ? extends K2> f) {
        return e -> new AbstractMap.SimpleImmutableEntry(f.apply((Object)e.getKey()), e.getValue());
    }

    public static <K, V, R> Function<Map.Entry<K, V>, R> keyToAny(Function<? super K, ? extends R> f) {
        return e -> f.apply((Object)e.getKey());
    }

    public static <K, V> Predicate<Map.Entry<K, V>> byKey(Predicate<? super K> f) {
        return e -> f.test((Object)e.getKey());
    }

    public static <K, V1, V2> Function<Map.Entry<K, V1>, Map.Entry<K, V2>> values(Function<? super V1, ? extends V2> f) {
        return e -> new AbstractMap.SimpleImmutableEntry(e.getKey(), f.apply((Object)e.getValue()));
    }

    public static <K, V1, V2> Function<Map.Entry<K, V1>, Map.Entry<K, V2>> valuesBi(BiFunction<? super K, ? super V1, ? extends V2> f) {
        return e -> new AbstractMap.SimpleImmutableEntry(e.getKey(), f.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    public static <K, V1, V2> IntFunction<Map.Entry<Integer, V2>> valuesInt(IntFunction<? extends V2> f) {
        return e -> new AbstractMap.SimpleImmutableEntry(e, f.apply(e));
    }

    public static <K, V, R> Function<Map.Entry<K, V>, R> valueToAny(Function<? super V, ? extends R> f) {
        return e -> f.apply((Object)e.getValue());
    }

    public static <K, V> Predicate<Map.Entry<K, V>> byValue(Predicate<? super V> f) {
        return e -> f.test((Object)e.getValue());
    }

    public static <K, V> Predicate<Map.Entry<K, V>> byEntry(BiPredicate<? super K, ? super V> f) {
        return e -> f.test((Object)e.getKey(), (Object)e.getValue());
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> entryToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> entryToMap(BinaryOperator<V> mergeFunction) {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction);
    }

    public static <K, V, M extends Map<K, V>> Collector<Map.Entry<K, V>, ?, M> entryToMap(BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction, mapSupplier);
    }

    public static <K, V> Consumer<Map.Entry<K, V>> entry(BiConsumer<? super K, ? super V> biConsumer) {
        return kvEntry -> biConsumer.accept((Object)kvEntry.getKey(), (Object)kvEntry.getValue());
    }

    public static <T> Predicate<T> not(Predicate<T> original) {
        return original.negate();
    }

    public static <T> Function<Object, Stream<T>> streamCast(Class<T> aClass) {
        return o -> Stream.of(o).filter(aClass::isInstance).map(aClass::cast);
    }

    public static <T> Predicate<T> always_false() {
        return ALWAYS_FALSE;
    }

    public static <T> Predicate<T> always_true() {
        return ALWAYS_TRUE;
    }
}

