--[[#######################################################################
#  File     :  /hook/lua/factions.lua
#  Author(s):  GPG Devs
#  Summary  :  
#  -----------------------------
#  Modif.by :  Manimal
#  Mod.Date :  06 juillet 2010 -> Derived from MANIMAL's Mod "SupCivs"
#  -----------------------------
#  Revis.by :  Manimal
#  Rev.Date :  28 janvier 2011 14:15 -> Ajout des Nouveaux Idles
#  Rev.Date :  10 fvrier 2011 17:35 -> Ajout des Idles Supplmentaires
#  Rev.Date :  25 fvrier 2011 14:10 -> Ajout de Textures Supplmentaires
#  -----------------------------
#  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--

-- Note that the order here will determine the faction index
-- (it's the automatically assigned array index)

Factions = {

	--# UEF AKA EARTH AKA TERRANS
    {
        Key = 'uef',
        Category = 'UEF',
        DisplayName = "<LOC _UEF>UEF",
        SoundPrefix = 'UEF',
        InitialUnit = 'mel0001',
        CampaignFileDesignator = 'E',
        TransmissionLogColor = 'ff00c1ff',
        Icon = "/widgets/faction-icons-alpha_bmp/uef_ico.dds",
        VeteranIcon = "/game/veteran-logo_bmp/uef-veteran_bmp.dds",
        SmallIcon = "/faction_icon-sm/uef_ico.dds",
        LargeIcon = "/faction_icon-lg/uef_ico.dds",
        TooltipID = 'lob_uef',
        DefaultSkin = 'uef',
        loadingMovie = '/movies/UEF_load.sfd',
        loadingColor = 'FFbadbdb',
        loadingTexture = '/UEF_load.dds',
        IdleACUTextures = {
            ACU = '/icons/units/mel0001_icon.dds',
			T1 = '/icons/units/uel0002_icon.dds',
        },
        IdleSCUTextures = {
            T3 = '/icons/units/uel0301_icon.dds',
        },
        IdleEngTextures = {
			LAND = {
				T1 = '/icons/units/uel0105_icon.dds',
				T2 = '/icons/units/uel0208_icon.dds',
				T2F = '/icons/units/xel0209_icon.dds',
				T3 = '/icons/units/uel0309_icon.dds',
			},
			AIR = {
				T1 = '/icons/units/uea0115_icon.dds',
				T2 = '/icons/units/uea0215_icon.dds',
			},
			NAVAL = {
				T1 = '/icons/units/ues0105_icon.dds',
				T2 = '/icons/units/ues0208_icon.dds',
			},
        },
		IdleLaboTextures = {
			LAND = {
				T1 = '/icons/units/reb7100_icon.dds',
				T2 = '/icons/units/reb7200_icon.dds',
				T3 = '/icons/units/reb7300_icon.dds',
			},
			AIR = {
				T1 = '/icons/units/reb8100_icon.dds',
				T2 = '/icons/units/reb8200_icon.dds',
				T3 = '/icons/units/reb8300_icon.dds',
			},
			NAVAL = {
				T1 = '/icons/units/reb9100_icon.dds',
				T2 = '/icons/units/reb9200_icon.dds',
				T3 = '/icons/units/reb9300_icon.dds',
			},
        },
        IdleFactoryTextures = {
            LAND = {
                T1 = '/icons/units/ueb0101_icon.dds',
                T2 = '/icons/units/ueb0201_icon.dds',
                T3 = '/icons/units/ueb0301_icon.dds',
            },
            AIR = {
                T1 = '/icons/units/ueb0102_icon.dds',
                T2 = '/icons/units/ueb0202_icon.dds',
                T3 = '/icons/units/ueb0302_icon.dds',
            },
            NAVAL = {
                T1 = '/icons/units/ueb0103_icon.dds',
                T2 = '/icons/units/ueb0203_icon.dds',
                T3 = '/icons/units/ueb0303_icon.dds',
            },
			SUBMERSIBLE = {
				T1 = '/icons/units/ueb0100_icon.dds',
				--T2 = '/icons/units/ueb0200_icon.dds',
				--T3 = '/icons/units/ueb0300_icon.dds',
			},
        },
        IdleQuGateTextures = {
            T3 = '/icons/units/ueb0304_icon.dds',
        },
		IdlePortailTextures = {
			T1 = '/icons/units/ueb0110_icon.dds',
		},
    },


	--# AEON AKA ILLUMINATES AKA ALIENS however they are NOT bloody aliens !!!
    {
        Key = 'aeon',
        Category = 'AEON',
        DisplayName = "<LOC _Aeon>Aeon",
        SoundPrefix = 'Aeon',
        InitialUnit = 'mal0001',
        CampaignFileDesignator = 'A',
        TransmissionLogColor = 'ffff0000',
        Icon = "/widgets/faction-icons-alpha_bmp/aeon_ico.dds",
        VeteranIcon = "/game/veteran-logo_bmp/aeon-veteran_bmp.dds",
        SmallIcon = "/faction_icon-sm/aeon_ico.dds",
        LargeIcon = "/faction_icon-lg/aeon_ico.dds",
        TooltipID = 'lob_aeon',
        DefaultSkin = 'aeon',
        loadingMovie = '/movies/aeon_load.sfd',
        loadingColor = 'FFc7e98a',
        loadingTexture = '/aeon_load.dds',
        IdleACUTextures = {
            ACU = '/icons/units/mal0001_icon.dds',
			T1 = '/icons/units/ual0002_icon.dds',
        },
        IdleSCUTextures = {
            T3 = '/icons/units/ual0301_icon.dds',
        },
        IdleEngTextures = {
			LAND = {
				T1 = '/icons/units/ual0105_icon.dds',
				T2 = '/icons/units/ual0208_icon.dds',
				--T2F = '/icons/units/xal0209_icon.dds',
				T3 = '/icons/units/ual0309_icon.dds',
			},
			AIR = {
				T1 = '/icons/units/uaa0105_icon.dds',
				T2 = '/icons/units/uaa0205_icon.dds',
			},
			NAVAL = {
				T1 = '/icons/units/uas0105_icon.dds',
				T2 = '/icons/units/uas0208_icon.dds',
			},
        },
		IdleLaboTextures = {
			LAND = {
				T1 = '/icons/units/rab7100_icon.dds',
				T2 = '/icons/units/rab7200_icon.dds',
				T3 = '/icons/units/rab7300_icon.dds',
			},
			AIR = {
				T1 = '/icons/units/rab8100_icon.dds',
				T2 = '/icons/units/rab8200_icon.dds',
				T3 = '/icons/units/rab8300_icon.dds',
			},
			NAVAL = {
				T1 = '/icons/units/rab9100_icon.dds',
				T2 = '/icons/units/rab9200_icon.dds',
				T3 = '/icons/units/rab9300_icon.dds',
			},
        },
        IdleFactoryTextures = {
            LAND = {
                T1 = '/icons/units/uab0101_icon.dds',
                T2 = '/icons/units/uab0201_icon.dds',
                T3 = '/icons/units/uab0301_icon.dds',
            },
            AIR = {
                T1 = '/icons/units/uab0102_icon.dds',
                T2 = '/icons/units/uab0202_icon.dds',
                T3 = '/icons/units/uab0302_icon.dds',
            },
            NAVAL = {
                T1 = '/icons/units/uab0103_icon.dds',
                T2 = '/icons/units/uab0203_icon.dds',
                T3 = '/icons/units/uab0303_icon.dds',
            },
			SUBMERSIBLE = {
				T1 = '/icons/units/uab0100_icon.dds',
				--T2 = '/icons/units/uab0200_icon.dds',
				--T3 = '/icons/units/uab0300_icon.dds',
			},
        },
        IdleQuGateTextures = {
            T3 = '/icons/units/uab0304_icon.dds',
        },
		IdlePortailTextures = {
			T1 = '/icons/units/uab0110_icon.dds',
		},
    },


	--# CYBRAN AKA RECYCLER
    {
        Key = 'cybran',
        Category = 'CYBRAN',
        DisplayName = "<LOC _Cybran>Cybran",
        SoundPrefix = 'Cybran',
        InitialUnit = 'mrl0001',
        CampaignFileDesignator = 'R',
        TransmissionLogColor = 'ff89d300',
        Icon = "/widgets/faction-icons-alpha_bmp/cybran_ico.dds",
        VeteranIcon = "/game/veteran-logo_bmp/cybran-veteran_bmp.dds",
        SmallIcon = "/faction_icon-sm/cybran_ico.dds",
        LargeIcon = "/faction_icon-lg/cybran_ico.dds",
        TooltipID = 'lob_cybran',
        DefaultSkin = 'cybran',
        loadingMovie = '/movies/cybran_load.sfd',
        loadingColor = 'FFe24f2d',
        loadingTexture = '/cybran_load.dds',
        IdleACUTextures = {
            ACU = '/icons/units/mrl0001_icon.dds',
			T1 = '/icons/units/url0002_icon.dds',
        },
        IdleSCUTextures = {
            T3 = '/icons/units/url0301_icon.dds',
        },
        IdleEngTextures = {
			LAND = {
				T1 = '/icons/units/url0105_icon.dds',
				T2 = '/icons/units/url0208_icon.dds',
				--T2F = '/icons/units/xrl0209_icon.dds',
				T3 = '/icons/units/url0309_icon.dds',
			},
			AIR = {
				T1 = '/icons/units/ura0105_icon.dds',
				T2 = '/icons/units/ura0208_icon.dds',
			},
			NAVAL = {
				T1 = '/icons/units/urs0105_icon.dds',
				T2 = '/icons/units/urs0208_icon.dds',
			},
        },
		IdleLaboTextures = {
			LAND = {
				T1 = '/icons/units/rrb7100_icon.dds',
				T2 = '/icons/units/rrb7200_icon.dds',
				T3 = '/icons/units/rrb7300_icon.dds',
			},
			AIR = {
				T1 = '/icons/units/rrb8100_icon.dds',
				T2 = '/icons/units/rrb8200_icon.dds',
				T3 = '/icons/units/rrb8300_icon.dds',
			},
			NAVAL = {
				T1 = '/icons/units/rrb9100_icon.dds',
				T2 = '/icons/units/rrb9200_icon.dds',
				T3 = '/icons/units/rrb9300_icon.dds',
			},
        },
        IdleFactoryTextures = {
            LAND = {
                T1 = '/icons/units/urb0101_icon.dds',
                T2 = '/icons/units/urb0201_icon.dds',
                T3 = '/icons/units/urb0301_icon.dds',
            },
            AIR = {
                T1 = '/icons/units/urb0102_icon.dds',
                T2 = '/icons/units/urb0202_icon.dds',
                T3 = '/icons/units/urb0302_icon.dds',
            },
            NAVAL = {
                T1 = '/icons/units/urb0103_icon.dds',
                T2 = '/icons/units/urb0203_icon.dds',
                T3 = '/icons/units/urb0303_icon.dds',
            },
			SUBMERSIBLE = {
				T1 = '/icons/units/urb0100_icon.dds',
				--T2 = '/icons/units/urb0200_icon.dds',
				--T3 = '/icons/units/urb0300_icon.dds',
			},
        },
        IdleQuGateTextures = {
            T3 = '/icons/units/urb0304_icon.dds',
        },
		IdlePortailTextures = {
			T1 = '/icons/units/urb0110_icon.dds',
		},
    },


	--# SERAPHIM should be AKA ALIENS given they ARE bloody aliens !!!
    {
        Key = 'seraphim',
        Category = 'SERAPHIM',
        DisplayName = "<LOC _Seraphim>Seraphim",
        SoundPrefix = 'Seraphim',
        InitialUnit = 'msl0001',
        CampaignFileDesignator = 'S',
        TransmissionLogColor = 'ff00FF00',
        Icon = "/widgets/faction-icons-alpha_bmp/seraphim_ico.dds",
        VeteranIcon = "/game/veteran-logo_bmp/seraphim-veteran_bmp.dds",
        SmallIcon = "/faction_icon-sm/seraphim_ico.dds",
        LargeIcon = "/faction_icon-lg/seraphim_ico.dds",
        TooltipID = 'lob_seraphim',
        DefaultSkin = 'seraphim',
        loadingMovie = '/movies/seraphim_load.sfd',
        loadingColor = 'FFffd700',
        loadingTexture = '/seraphim_load.dds',
        IdleACUTextures = {
            ACU = '/icons/units/msl0001_icon.dds',
			T1 = '/icons/units/xsl0002_icon.dds',
        },
        IdleSCUTextures = {
            T3 = '/icons/units/xsl0301_icon.dds',
        },
        IdleEngTextures = {
			LAND = {
				T1 = '/icons/units/xsl0105_icon.dds',
				T2 = '/icons/units/xsl0208_icon.dds',
				--T2F = '/icons/units/xsl0209_icon.dds',
				T3 = '/icons/units/xsl0309_icon.dds',
			},
			AIR = {
				T1 = '/icons/units/xsa0105_icon.dds',
				T2 = '/icons/units/xsa0205_icon.dds',
			},
			NAVAL = {
				T1 = '/icons/units/xss0105_icon.dds',
				T2 = '/icons/units/xss0208_icon.dds',
			},
        },
		IdleLaboTextures = {
			LAND = {
				T1 = '/icons/units/rsb7100_icon.dds',
				T2 = '/icons/units/rsb7200_icon.dds',
				T3 = '/icons/units/rsb7300_icon.dds',
			},
			AIR = {
				T1 = '/icons/units/rsb8100_icon.dds',
				T2 = '/icons/units/rsb8200_icon.dds',
				T3 = '/icons/units/rsb8300_icon.dds',
			},
			NAVAL = {
				T1 = '/icons/units/rsb9100_icon.dds',
				T2 = '/icons/units/rsb9200_icon.dds',
				T3 = '/icons/units/rsb9300_icon.dds',
			},
        },
        IdleFactoryTextures = {
            LAND = {
                T1 = '/icons/units/xsb0101_icon.dds',
                T2 = '/icons/units/xsb0201_icon.dds',
                T3 = '/icons/units/xsb0301_icon.dds',
            },
            AIR = {
                T1 = '/icons/units/xsb0102_icon.dds',
                T2 = '/icons/units/xsb0202_icon.dds',
                T3 = '/icons/units/xsb0302_icon.dds',
            },
            NAVAL = {
                T1 = '/icons/units/xsb0103_icon.dds',
                T2 = '/icons/units/xsb0203_icon.dds',
                T3 = '/icons/units/xsb0303_icon.dds',
            },
			SUBMERSIBLE = {
				T1 = '/icons/units/xsb0100_icon.dds',
				--T2 = '/icons/units/xsb0200_icon.dds',
				--T3 = '/icons/units/xsb0300_icon.dds',
			},
        },
        IdleQuGateTextures = {
            T3 = '/icons/units/xsb0304_icon.dds',
        },
		IdlePortailTextures = {
			T1 = '/icons/units/xsb0110_icon.dds',
		},
    },
}

-- map faction key to index, as this lookup is done frequently
FactionIndexMap = {}

-- file designator to faction key
FactionDesToKey = {}

for index, value in Factions do
    FactionIndexMap[value.Key] = index
    FactionDesToKey[value.CampaignFileDesignator] = value.Key
end


