--[[#######################################################################
#  File     :  /hook/lua/ui/game/layouts/avatars_mini.lua
#  Author(s):  GPG devs
#  Summary  :  In Game Avatar Layout
#  -----------------------------
#  Modif.by :  Manimal
#  Mod.Date :  21 mars 2008 -> Avatars pour SupCivs
#  -----------------------------
#  Revis.by :  Manimal
#  Rev.Date :  08 fvrier 2011 08:02 -> Avatar ACUs SCUs CEs QGs PHs et Labos
#  Rev.Date :  24 fvrier 2011 15:55 -> Mises au point.
#  -----------------------------
#  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--




local UIUtil = import('/lua/ui/uiutil.lua')
local LayoutHelpers = import('/lua/maui/layouthelpers.lua')

function SetLayout()
    local controls = import('/lua/ui/game/avatars.lua').controls
    
    LayoutHelpers.AtRightTopIn(controls.avatarGroup, controls.parent, 0, 200)
    controls.avatarGroup.Height:Set(0)
    controls.avatarGroup.Width:Set(200)
    
    controls.bgTop:SetTexture(UIUtil.UIFile('/game/bracket-right/bracket_bmp_t.dds'))
    controls.bgStretch:SetTexture(UIUtil.UIFile('/game/bracket-right/bracket_bmp_m.dds'))
    controls.bgBottom:SetTexture(UIUtil.UIFile('/game/bracket-right/bracket_bmp_b.dds'))
    
    LayoutHelpers.AtTopIn(controls.collapseArrow, controls.avatarGroup, 22)
    LayoutHelpers.AtRightIn(controls.collapseArrow, controls.parent, -3)
    
    LayoutHelpers.AtRightIn(controls.bgTop, controls.avatarGroup)
    LayoutHelpers.AtRightIn(controls.bgBottom, controls.avatarGroup)
    
    controls.bgTop.Bottom:Set(function() return controls.avatarGroup.Top() + 70 end)
    controls.bgBottom.Top:Set(function() return math.max(controls.bgTop.Bottom(), controls.avatarGroup.Bottom() + 0) end)
    controls.bgStretch.Top:Set(controls.bgTop.Bottom)
    controls.bgStretch.Bottom:Set(controls.bgBottom.Top)
    controls.bgStretch.Right:Set(function() return controls.bgTop.Right() - 7 end)
    
    controls.collapseArrow.Depth:Set(function() return controls.bgTop.Depth() + 1 end)
    controls.collapseArrow:SetTexture(UIUtil.UIFile('/game/tab-r-btn/tab-close_btn_up.dds'))
    controls.collapseArrow:SetNewTextures(UIUtil.UIFile('/game/tab-r-btn/tab-close_btn_up.dds'),
        UIUtil.UIFile('/game/tab-r-btn/tab-open_btn_up.dds'),
        UIUtil.UIFile('/game/tab-r-btn/tab-close_btn_over.dds'),
        UIUtil.UIFile('/game/tab-r-btn/tab-open_btn_over.dds'),
        UIUtil.UIFile('/game/tab-r-btn/tab-close_btn_dis.dds'),
        UIUtil.UIFile('/game/tab-r-btn/tab-open_btn_dis.dds'))
        
    LayoutAvatars()
end

function LayoutAvatars()
    local controls = import('/lua/ui/game/avatars.lua').controls
    
    local rightOffset, topOffset, space = 14, 14, -5
    
    local prevControl = false
    local height = 0
	
    for _, control in controls.avatars do
        if prevControl then
            control.Top:Set(function() return prevControl.Bottom() + space end)
            LayoutHelpers.AtRightIn(control, prevControl)
            height = height + (control.Bottom() - prevControl.Bottom())
        else
            LayoutHelpers.AtRightTopIn(control, controls.avatarGroup, rightOffset, topOffset)
            height = control.Height()
        end
        prevControl = control
    end
	
	
    if controls.idleLabos then
        if prevControl then
            controls.idleLabos.prevControl = prevControl
            controls.idleLabos.Top:Set(function() return controls.idleLabos.prevControl.Bottom() + space end)
            LayoutHelpers.AtRightIn(controls.idleLabos, controls.idleLabos.prevControl)
            height = height + (controls.idleLabos.Bottom() - controls.idleLabos.prevControl.Bottom())
        else
            LayoutHelpers.AtRightTopIn(controls.idleLabos, controls.avatarGroup, rightOffset, topOffset)
            height = controls.idleLabos.Height()
        end
        prevControl = controls.idleLabos  -- Ligne ajoute, semble indiquer au control ci-dessous qu'il est prcd par le prsent controle !
    end
	
	
    if controls.idlePortails then
        if prevControl then
            controls.idlePortails.prevControl = prevControl
            controls.idlePortails.Top:Set(function() return controls.idlePortails.prevControl.Bottom() + space end)
            LayoutHelpers.AtRightIn(controls.idlePortails, controls.idlePortails.prevControl)
            height = height + (controls.idlePortails.Bottom() - controls.idlePortails.prevControl.Bottom())
        else
            LayoutHelpers.AtRightTopIn(controls.idlePortails, controls.avatarGroup, rightOffset, topOffset)
            height = controls.idlePortails.Height()
        end
        prevControl = controls.idlePortails  -- Ligne ajoute, semble indiquer au control ci-dessous qu'il est prcd par le prsent controle !
    end
	
	
    if controls.idleHeros then
        if prevControl then
            controls.idleHeros.prevControl = prevControl
            controls.idleHeros.Top:Set(function() return controls.idleHeros.prevControl.Bottom() + space end)
            LayoutHelpers.AtRightIn(controls.idleHeros, controls.idleHeros.prevControl)
            height = height + (controls.idleHeros.Bottom() - controls.idleHeros.prevControl.Bottom())
        else
            LayoutHelpers.AtRightTopIn(controls.idleHeros, controls.avatarGroup, rightOffset, topOffset)
            height = controls.idleHeros.Height()
        end
        prevControl = controls.idleHeros  -- Ligne ajoute, semble indiquer au control ci-dessous qu'il est prcd par le prsent controle !
    end
	
	
    if controls.idleQuantGates then
        if prevControl then
            controls.idleQuantGates.prevControl = prevControl
            controls.idleQuantGates.Top:Set(function() return controls.idleQuantGates.prevControl.Bottom() + space end)
            LayoutHelpers.AtRightIn(controls.idleQuantGates, controls.idleQuantGates.prevControl)
            height = height + (controls.idleQuantGates.Bottom() - controls.idleQuantGates.prevControl.Bottom())
        else
            LayoutHelpers.AtRightTopIn(controls.idleQuantGates, controls.avatarGroup, rightOffset, topOffset)
            height = controls.idleQuantGates.Height()
        end
        prevControl = controls.idleQuantGates  -- Ligne ajoute, semble indiquer au control ci-dessous qu'il est prcd par le prsent controle !
    end
	
	
	if controls.idleSCUs then
        if prevControl then
            controls.idleSCUs.prevControl = prevControl
            controls.idleSCUs.Top:Set(function() return controls.idleSCUs.prevControl.Bottom() + space end)
            LayoutHelpers.AtRightIn(controls.idleSCUs, controls.idleSCUs.prevControl)
            height = height + (controls.idleSCUs.Bottom() - controls.idleSCUs.prevControl.Bottom())
        else
            LayoutHelpers.AtRightTopIn(controls.idleSCUs, controls.avatarGroup, rightOffset, topOffset)
            height = controls.idleSCUs.Height()
        end
        prevControl = controls.idleSCUs
    end
	
	
    if controls.idleFactories then
        if prevControl then
            controls.idleFactories.prevControl = prevControl
            controls.idleFactories.Top:Set(function() return controls.idleFactories.prevControl.Bottom() + space end)
            LayoutHelpers.AtRightIn(controls.idleFactories, controls.idleFactories.prevControl)
            height = height + (controls.idleFactories.Bottom() - controls.idleFactories.prevControl.Bottom())
        else
            LayoutHelpers.AtRightTopIn(controls.idleFactories, controls.avatarGroup, rightOffset, topOffset)
            height = controls.idleFactories.Height()
        end
        prevControl = controls.idleFactories
    end
	
	
    if controls.idleEngineers then
        if prevControl then
            controls.idleEngineers.prevControl = prevControl
            controls.idleEngineers.Top:Set(function() return controls.idleEngineers.prevControl.Bottom() + space end)
            LayoutHelpers.AtRightIn(controls.idleEngineers, controls.idleEngineers.prevControl)
            height = height + (controls.idleEngineers.Bottom() - controls.idleEngineers.prevControl.Bottom())
        else
            LayoutHelpers.AtRightTopIn(controls.idleEngineers, controls.avatarGroup, rightOffset, topOffset)
            height = controls.idleEngineers.Height()
        end
        prevControl = controls.idleEngineers
    end
	
	
    controls.avatarGroup.Height:Set(function() return height - 5 end)
end
    