#****************************************************************************
#**
#**  File     :  /cdimage/units/UAL0103/UAL0103_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**				Model By Asdrubaelvect, Script By Manimal For Experimental Wars 1.8
#**  Summary  :  Aeon Mobile Light Artillery Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#######################################################################
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#######################################################################
local AHoverLandUnit = import('/lua/aeonunits.lua').AHoverLandUnit
local AIFMortarWeapon = import('/lua/aeonweapons.lua').AIFMortarWeapon

local Buff = import('/lua/sim/Buff.lua')


local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UAL0103 = Class(AHoverLandUnit) {
    Weapons = {
        MainGun = Class(AIFMortarWeapon) {
            FxMuzzleFlash = {
                '/effects/emitters/aeon_mortar_flash_01_emit.bp',
                '/effects/emitters/aeon_mortar_flash_02_emit.bp',
            },
        },
        UpgradeGun01 = Class(AIFMortarWeapon) {
            FxMuzzleFlash = {
                '/effects/emitters/aeon_mortar_flash_01_emit.bp',
                '/effects/emitters/aeon_mortar_flash_02_emit.bp',
            },
        },
		UpgradeGun02 = Class(AIFMortarWeapon) {
            FxMuzzleFlash = {
                '/effects/emitters/aeon_mortar_flash_01_emit.bp',
                '/effects/emitters/aeon_mortar_flash_02_emit.bp',
            },
        },
    },
    OnCreate = function(self)
        AHoverLandUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true)  
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)	
			self:HideBone('Upgrade02_02', true)					
			##UPGRADE03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true)
			self:HideBone('Upgrade03_03', true)
			###UPGRADE04
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade04_02', true)
			###UPGRADE05
			self:HideBone('Upgrade05_01', true)
			self:HideBone('Upgrade05_02', true)
			self:HideBone('Upgrade05_03', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
    OnStopBeingBuilt = function(self, builder, layer)
        AHoverLandUnit.OnStopBeingBuilt(self,builder,layer)
	        self:SetWeaponEnabledByLabel('MainGun', true)
	        self:SetWeaponEnabledByLabel('UpgradeGun01', false)
			self:SetWeaponEnabledByLabel('UpgradeGun02', false)
       self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran')
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				##Meshe
				self:ShowBone('Upgrade01_01', true)
				self:HideBone('Upgrade03_01', true)
				###DAMAGES 20% and Range 20%
				local wep1 = self:GetWeaponByLabel('MainGun')
    		    wep1:AddDamageMod(bpEnh.ArtyIDamageMod) 
				wep1:ChangeMaxRadius(36)				
				local wep2 = self:GetWeaponByLabel('UpgradeGun01')
				wep2:ChangeMaxRadius(36)
				local wep3 = self:GetWeaponByLabel('UpgradeGun02')
				wep3:ChangeMaxRadius(36)				
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'AENHEALTHBUFF1',
                    DisplayName = 'AENHEALTHBUFF1',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AENHEALTHBUFF1')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				##Meshe
				self:ShowBone('Upgrade02_01', true)
				self:ShowBone('Upgrade02_02', true)
				self:ShowBone('Upgrade02_03', true)
				self:HideBone('Upgrade03_02', true)
				###NEW WEAPONS
				self:SetWeaponEnabledByLabel('UpgradeGun01', true)
				###DAMAGES 10%
				local wep1 = self:GetWeaponByLabel('MainGun')
				wep1:AddDamageMod(bpEnh.ArtyIIDamageMod) 
				local wep2 = self:GetWeaponByLabel('UpgradeGun01')
				wep2:AddDamageMod(bpEnh.ArtyIIDamageMod) 		
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'AENHEALTHBUFF2',
                    DisplayName = 'AENHEALTHBUFF2',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AENHEALTHBUFF2')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				##Meshe
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				self:ShowBone('Upgrade03_03', true)
				###DAMAGES 10% and Range 15%
				local wep1 = self:GetWeaponByLabel('MainGun')
				wep1:AddDamageMod(bpEnh.ArtyIIIDamageMod) 
				wep1:ChangeMaxRadius(41)
				local wep2 = self:GetWeaponByLabel('UpgradeGun01')
				wep2:AddDamageMod(bpEnh.ArtyIIIDamageMod) 
				wep2:ChangeMaxRadius(41)
				local wep3 = self:GetWeaponByLabel('UpgradeGun02')
				wep3:ChangeMaxRadius(41)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'AENHEALTHBUFF3',
                    DisplayName = 'AENHEALTHBUFF3',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AENHEALTHBUFF3')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				##Meshe
				self:ShowBone('Upgrade04_01', true)
				self:HideBone('Upgrade02_01', true) ###Masquer arme 2
				###NEW WEAPONS
				self:SetWeaponEnabledByLabel('UpgradeGun01', false) ###Desactivation arme 2
				self:SetWeaponEnabledByLabel('UpgradeGun02', true)
				###DAMAGES 5%
				local wep1 = self:GetWeaponByLabel('MainGun')
				wep1:AddDamageMod(bpEnh.ArtyIVDamageMod) 
				local wep3 = self:GetWeaponByLabel('UpgradeGun02')
    		    wep3:AddDamageMod(bpEnh.ArtyIVDamageMod) 
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
			BuffBlueprint {
                    Name = 'AENHEALTHBUFF4',
                    DisplayName = 'AENHEALTHBUFF4',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AENHEALTHBUFF4')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				####MESHE
				self:ShowBone('Upgrade05_01', true)
				self:ShowBone('Upgrade05_02', true)
				####SHIELD
				ForkThread(function()
				self.Trash:Add(CreateRotator(self, 'Upgrade05_02', 'x', nil, 120, 0, 120))
                self.Trash:Add(CreateRotator(self, 'Upgrade05_01', 'x', nil, 120, 0, 120))
				self:AddToggleCap('RULEUTC_ShieldToggle')
				self:SetEnergyMaintenanceConsumptionOverride(bpEnh.MaintenanceConsumptionPerSecondEnergy or 0)
				self:SetMaintenanceConsumptionActive()
				self:CreatePersonalShield(bpEnh)
				end)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
            BuffBlueprint {
                    Name = 'AENHEALTHBUFF5',
                    DisplayName = 'AENHEALTHBUFF5',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AENHEALTHBUFF5')
		end	
	end,
}

TypeClass = UAL0103