#****************************************************************************
#**
#**  File     :  /cdimage/units/UAL0106/UAL0106_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  Aeon Light Assault Bot Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#######################################################################
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#######################################################################
local AWalkingLandUnit = import( MyModPath .. '/hook/lua/aeonunits.lua' ).AWalkingLandUnit
local ADFSonicPulsarWeapon = import('/lua/aeonweapons.lua').ADFSonicPulsarWeapon
local ADFLaserLightWeapon = import('/lua/aeonweapons.lua').ADFLaserLightWeapon
local Buff = import('/lua/sim/Buff.lua')

###UPGRADE04Gun
local ADFGravitonProjectorWeapon = import('/lua/aeonweapons.lua').ADFGravitonProjectorWeapon

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UAL0106 = Class(AWalkingLandUnit) {
    Weapons = {
        ArmLaserTurret = Class(ADFLaserLightWeapon) {},
		####UPGRADE02
		UpgradeGun01 = Class(ADFSonicPulsarWeapon) {},
		####UPGRADE04
		UpgradeGun02 = Class(ADFGravitonProjectorWeapon) {},
    },
	
    OnCreate = function(self)
		AWalkingLandUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true)  
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)	
			self:HideBone('Upgrade02_02', true)	
			self:HideBone('Upgrade02_03', true)				
			##UPGRADE03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true)
			self:HideBone('Upgrade03_03', true)
			###UPGRADE04
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade04_02', true)
			###UPGRADE05
			self:HideBone('Upgrade05_01', true)	
			self:HideBone('Upgrade05_02', true)	
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
    OnStopBeingBuilt = function(self, builder, layer)
        AWalkingLandUnit.OnStopBeingBuilt(self,builder,layer)
	        self:SetWeaponEnabledByLabel('ArmLaserTurret', true)
			###UPGRADE02
			self:SetWeaponEnabledByLabel('UpgradeGun01', false)
			###UPGRADE04
			self:SetWeaponEnabledByLabel('UpgradeGun02', false)
	   self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran') # Ajouter 1 Trigger pour lancer Enhancement
    end,
	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				##Meshe
				self:ShowBone('Upgrade01_01', true)
				###DAMAGES 20% and Range 10%
				local wep1 = self:GetWeaponByLabel('ArmLaserTurret')
    		    wep1:AddDamageMod(bpEnh.LaserIDamageMod) 
				wep1:ChangeMaxRadius(15.5)				
				local wep2 = self:GetWeaponByLabel('UpgradeGun01')
				wep2:ChangeMaxRadius(15.5)
				local wep3 = self:GetWeaponByLabel('UpgradeGun02')
				wep3:ChangeMaxRadius(15.5)
				
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'AENHEALTHBUFF1',
                    DisplayName = 'AENHEALTHBUFF1',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AENHEALTHBUFF1')
		end	
		######################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				##Meshe
				self:ShowBone('Upgrade02_01', true)
				self:ShowBone('Upgrade02_02', true)
				self:ShowBone('Upgrade02_03', true)
				self:HideBone('Upgrade03_01', true)
				self:HideBone('Upgrade03_02', true)
				self:HideBone('Upgrade04_01', true)
				self:HideBone('Upgrade04_02', true)
				###NEW WEAPONS
				self:SetWeaponEnabledByLabel('UpgradeGun01', true)
				###DAMAGES 10%
				local wep1 = self:GetWeaponByLabel('ArmLaserTurret')
				wep1:AddDamageMod(bpEnh.LaserIIDamageMod) 
				local wep2 = self:GetWeaponByLabel('UpgradeGun01')
				wep2:AddDamageMod(bpEnh.LaserIIDamageMod) 
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'AENHEALTHBUFF2',
                    DisplayName = 'AENHEALTHBUFF2',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AENHEALTHBUFF2')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				##Meshe
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				self:ShowBone('Upgrade03_03', true)
				###DAMAGES 10% and Range 10%
				local wep1 = self:GetWeaponByLabel('ArmLaserTurret')
				wep1:AddDamageMod(bpEnh.LaserIIIDamageMod) 
				wep1:ChangeMaxRadius(17)
				local wep2 = self:GetWeaponByLabel('UpgradeGun01')
				wep2:AddDamageMod(bpEnh.LaserIIIDamageMod) 
				wep2:ChangeMaxRadius(17)
				local wep3 = self:GetWeaponByLabel('UpgradeGun02')
				wep3:ChangeMaxRadius(17)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'AENHEALTHBUFF3',
                    DisplayName = 'AENHEALTHBUFF3',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AENHEALTHBUFF3')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
			##Meshe
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				###NEW WEAPONS
				self:SetWeaponEnabledByLabel('UpgradeGun01', false) ###unable
				self:SetWeaponEnabledByLabel('UpgradeGun02', true)
				###DAMAGES 5%
				local wep1 = self:GetWeaponByLabel('ArmLaserTurret')
				wep1:AddDamageMod(bpEnh.LaserIVDamageMod)  
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
			BuffBlueprint {
                    Name = 'AENHEALTHBUFF4',
                    DisplayName = 'AENHEALTHBUFF4',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AENHEALTHBUFF4')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				####MESHE
				self:ShowBone('Upgrade05_01', true)
				self:ShowBone('Upgrade05_02', true)
				####SHIELD
				ForkThread(function()
                self.Trash:Add(CreateRotator(self, 'Upgrade05_01', 'z', nil, 120, 0, 120))
				self:AddToggleCap('RULEUTC_ShieldToggle')
				self:SetEnergyMaintenanceConsumptionOverride(bpEnh.MaintenanceConsumptionPerSecondEnergy or 0)
				self:SetMaintenanceConsumptionActive()
				self:CreatePersonalShield(bpEnh)
				end)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
            BuffBlueprint {
                    Name = 'AENHEALTHBUFF5',
                    DisplayName = 'AENHEALTHBUFF5',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AENHEALTHBUFF5')
		end	
	end,	
	
}


TypeClass = UAL0106