#****************************************************************************
#**
#**  File     :  /cdimage/units/UEL0104/UEL0104_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**				Upgrades Model By Asdrubaelvect Script By Manimal For Experimental Wars 1.8
#**  Summary  :  UEF Mobile Anti-Air Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local TLandUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TLandUnit

local TAALinkedRailgun = import('/lua/terranweapons.lua').TAALinkedRailgun

######UPGRADE04
local TSAMLauncher = import('/lua/terranweapons.lua').TSAMLauncher

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UEL0104 = Class(TLandUnit) {
    Weapons = {
        AAGun = Class(TAALinkedRailgun) {
            FxMuzzleFlashScale = 0.25,
        },
		########UPGRADE02
        AAGun02 = Class(TAALinkedRailgun) {
            FxMuzzleFlashScale = 0.25,
        },
		########UPGRADE04
		MissileRack01 = Class(TSAMLauncher) {},
		MissileRack02 = Class(TSAMLauncher) {},
    },

    OnCreate = function(self)
        TLandUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true)  
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)	
			##UPGRADE03
			self:HideBone('Upgrade03_01', true)			
			##UPGRADE04
			self:HideBone('Upgrade04_01', true)
			##UPGRADE05
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
    OnStopBeingBuilt = function(self, builder, layer)
        TLandUnit.OnStopBeingBuilt(self,builder,layer)
	        self:SetWeaponEnabledByLabel('AAGun', true)
			###UPGRADE02
			self:SetWeaponEnabledByLabel('AAGun02', false) 
			###UPGRADE04		
			self:SetWeaponEnabledByLabel('MissileRack01', false) 
			self:SetWeaponEnabledByLabel('MissileRack02', false) 
       self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran')
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				##MESHE
				self:ShowBone('Upgrade01_01', true)
				###RANGE 15%
				local wep = self:GetWeaponByLabel('AAGun')
				wep:ChangeMaxRadius(37)
				local wep2 = self:GetWeaponByLabel('AAGun02')
				wep2:ChangeMaxRadius(37)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF1',
                    DisplayName = 'UEFHEALTHBUFF1',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 19,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF1')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				###MESHE
				self:ShowBone('Upgrade02_01', true)
				self:HideBone('Turret', true) ##Hide main weapon
				self:HideBone('Upgrade03_01', true) ## Hide attached bones
				###NEW WEAPON
				self:SetWeaponEnabledByLabel('AAGun', false)	##DEsactive
				self:SetWeaponEnabledByLabel('AAGun02', true)	
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF2',
                    DisplayName = 'UEFHEALTHBUFF2',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 21,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF2')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				###MESHE
				self:ShowBone('Upgrade03_01', true)
				###Range 15%
				local wep = self:GetWeaponByLabel('AAGun')
				wep:ChangeMaxRadius(37)
				local wep2 = self:GetWeaponByLabel('AAGun02')
				wep2:ChangeMaxRadius(37)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
				BuffBlueprint {
                    Name = 'UEFHEALTHBUFF3',
                    DisplayName = 'UEFHEALTHBUFF3',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 35,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF3')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				####MESHE
				self:ShowBone('Upgrade04_01', true)
				###NEW WEAPON LONG RANGE
				self:SetWeaponEnabledByLabel('MissileRack01', true) 
				self:SetWeaponEnabledByLabel('MissileRack02', true) 
				###WEAPON CONF
				local wep = self:GetWeaponByLabel('MissileRack01')
				wep:ChangeMaxRadius(50)
				local wep2 = self:GetWeaponByLabel('MissileRack02')
				wep2:ChangeMaxRadius(50)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF4',
                    DisplayName = 'UEFHEALTHBUFF4',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 39,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF4')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				####MESHE
				self:ShowBone('Upgrade05_01', true)
				### SPEED MALUS
				self:SetSpeedMult(bp.Physics.Upgrade05SpeedMultiplier)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF5',
                    DisplayName = 'UEFHEALTHBUFF5',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 67,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF5')
		end	
	end,

}

TypeClass = UEL0104