#****************************************************************************
#**
#**  File     :  /cdimage/units/UEL0106/UEL0106_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  UEF Light Assault Bot Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local TWalkingLandUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TWalkingLandUnit

local Unit = import('/lua/sim/Unit.lua').Unit
local TDFMachineGunWeapon = import('/lua/terranweapons.lua').TDFMachineGunWeapon
local TSAMLauncher = import('/lua/terranweapons.lua').TSAMLauncher
local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UEL0106 = Class(TWalkingLandUnit) {
    Weapons = {
        ArmCannonTurret = Class(TDFMachineGunWeapon) {
            DisabledFiringBones = {
                'Torso', 'Head',  'Arm_Right_B01', 'Arm_Right_B02','Arm_Right_Muzzle',
                'Arm_Left_B01', 'Arm_Left_B02','Arm_Left_Muzzle'
                },
        },
		########UPGRADE03#####
		UpgradeGun01 = Class(TSAMLauncher) {},
		########UPGRADE04#####
		UpgradeGun02 = Class(TDFMachineGunWeapon) {},
    },

    OnCreate = function(self)
		TWalkingLandUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true)
			self:HideBone('Upgrade01_02', true) 
			self:HideBone('Upgrade01_03', true) 
			self:HideBone('Upgrade01_04', true) 			
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)
			self:HideBone('Upgrade02_02', true)  			
			##UPGRADE03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true) 
			##UPGRADE04
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade04_02', true) 
			##UPGRADE05
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
    OnStopBeingBuilt = function(self, builder, layer)
        TWalkingLandUnit.OnStopBeingBuilt(self,builder,layer)
	        self:SetWeaponEnabledByLabel('ArmCannonTurret', true)
			self:SetWeaponEnabledByLabel('UpgradeGun01', false)
			self:SetWeaponEnabledByLabel('UpgradeGun02', false)
       self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran') # Ajouter 1 Trigger pour lancer Enhancement
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
			##MESHE
			self:ShowBone('Upgrade01_01', true)
			self:ShowBone('Upgrade01_02', true)
			self:ShowBone('Upgrade01_03', true)
			self:ShowBone('Upgrade01_04', true)
			### DAMAGES 25%
			local wep = self:GetWeaponByLabel('ArmCannonTurret')
			wep:AddDamageMod(bpEnh.TomCatIDamageMod)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 13,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		######################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
			##MESHE
			self:ShowBone('Upgrade02_01', true)
			self:ShowBone('Upgrade02_02', true)
			##MESHE HIDE
			self:HideBone('Upgrade03_03', true)
			self:HideBone('Upgrade03_04', true)
			##WEAPON
			self:SetWeaponEnabledByLabel('UpgradeGun02', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF2',
                    DisplayName = 'UEFHEALTHBUFF2',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 14,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF2')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
			##MESHE
			self:ShowBone('Upgrade03_01', true)
			self:ShowBone('Upgrade03_02', true)
			self:ShowBone('Upgrade03_03', true)
			self:ShowBone('Upgrade03_04', true)
			### DAMAGES 10%
			local wep1 = self:GetWeaponByLabel('ArmCannonTurret')
			wep1:AddDamageMod(bpEnh.TomCatIIDamageMod)
			local wep2 = self:GetWeaponByLabel('UpgradeGun02')
			wep2:AddDamageMod(bpEnh.TomCatIIDamageMod)					
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF3',
                    DisplayName = 'UEFHEALTHBUFF3',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 19,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF3')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				##MESHE
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				##WEAPON rockets
				self:SetWeaponEnabledByLabel('UpgradeGun01', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF4',
                    DisplayName = 'UEFHEALTHBUFF4',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 19,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF4')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				self:ShowBone('Upgrade05_01', true)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF5',
                    DisplayName = 'UEFHEALTHBUFF5',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 32,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF5')
		end	
	end,
	
}
TypeClass = UEL0106

