--[[#######################################################################
#  File     :  /units/MEL0001/MEL0001_script.lua
#  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#  Summary  :  Special UEF Commander Script
#  -----------------------------
#  Modif.by :  Manimal -> Veterancy Upgrades Weapons
#  Rev.Date :  dd mmmmmm 2009
#  -----------------------------
#  Modif.by :  AsdrubaelVect -> home-made cooking
#  Rev.Date :  05 septembre 2009
#  -----------------------------
#  Revis.by :  Manimal -> Fixed up some bugs, not enough time to make Veterancy GENERIC again
#  Rev.Date :  17 fvrier 2010
#  Rev.Date :  27 mai 2010
#  Rev.Date :  14 juillet 2010 -> Ajout de Restrictions Oublies pour LABOS version 4b
#  Rev.Date :  26 janvier 2011 07:16 -> LABOS version 5.2 
#  Rev.Date :  13 fvrier 2011 12:55 -> CORRECTION TYPOS 
#  Rev.Date :  07 mars 2011 01:08 -> AJOUT RESTRICTIONS PODs (oublis)
#  Rev.Date :  20 mars 2011 11:16 -> MODIF KILL UNITS SI ACU MORT + CONDITION ASSASSINAT
#  Rev.Date :  22 mars 2011 00:38 -> CORRECTION OnVeteran
#  -----------------------------
#  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--


#=======================================================================
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#=======================================================================

# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#  FAIRE :
# ~~~~~~~~~
# REVISER LA GESTION DES BuildRestrictions ENHANCEMENT / RGRESSION :
#  LABO CONSTRUIT => INTERDIRE CONSTRUCTION LABOS DU MME TUPE
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local EffectTemplate = import('/lua/EffectTemplates.lua')
local EffectUtil = import('/lua/EffectUtilities.lua')
local Buff = import('/lua/sim/Buff.lua')
local utilities = import('/lua/Utilities.lua')
local RandomFloat = utilities.GetRandomFloat
local explosion = import('/lua/defaultexplosions.lua')

local AIUtils = import('/lua/ai/aiutilities.lua')
local ScenarioUtils = import('/lua/sim/ScenarioUtilities.lua')
local Buff = import('/lua/sim/Buff.lua')

local Shield = import('/lua/shield.lua').Shield

local TWalkingLandUnit = import( MyModPath .. '/hook/lua/terranunits.lua' ).TWalkingLandUnit
local TerranWeaponFile = import('/lua/terranweapons.lua')
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# MODIF PAR MANIMAL
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local TerranWeaponFile2 = import( MyModPath .. '/hook/lua/modweapons.lua' )
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local TDFZephyrCannonWeapon = TerranWeaponFile.TDFZephyrCannonWeapon
local TDFZephyrCannonWeapon02 = TerranWeaponFile.TDFGaussCannonWeapon
local TDFZephyrCannonWeapon03 = TerranWeaponFile.TDFGaussCannonWeapon
local TIFCruiseMissileLauncher = TerranWeaponFile.TIFCruiseMissileLauncher
local TDFOverchargeWeapon = TerranWeaponFile.TDFOverchargeWeapon

local TIFCommanderDeathWeapon = TerranWeaponFile2.TIFCommanderDeathWeapon

# ~~~~~~~~~~~~~~~~~~~
# AJOUT PAR MANIMAL :
# ~~~~~~~~~~~~~~~~~~~
--local EW_DefaultUnits = import( MyModPath .. '/hook/lua/EW_DefaultUnits.lua' ) 
--local hasHEB = false # Flag signalant Enhancement avec Heavy Electron Bolter
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# MODIF PAR ASDRUBAEL + CORRECTION PAR MANIMAL
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
--local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
--local hasHEBII = false
--local hasHEBIII = false
--local hasHEBIV = false
--local hasHEBV = false
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


MEL0001 = Class( TWalkingLandUnit ) {    
    DeathThreadDestructionWaitTime = 1,

    Weapons = {
        DeathWeapon = Class(TIFCommanderDeathWeapon) {
		    OnFire = function(self)
		        local blueprint = self:GetBlueprint()
		        DamageArea(self.unit, self.unit:GetPosition(), blueprint.DamageRadius,
		                   blueprint.Damage, blueprint.DamageType, blueprint.DamageFriendly)
		    end,		
		},
        RightZephyr = Class(TDFZephyrCannonWeapon) {},
        OverCharge = Class(TDFOverchargeWeapon) {

            OnCreate = function(self)
                TDFOverchargeWeapon.OnCreate(self)
                self:SetWeaponEnabled(false)
                self.AimControl:SetEnabled(false)
                self.AimControl:SetPrecedence(0)
                self.unit:SetOverchargePaused(false)
            end,

            OnEnableWeapon = function(self)
                if self:BeenDestroyed() then return end
                self:SetWeaponEnabled(true)
                self.unit:SetWeaponEnabledByLabel('RightZephyr', false)
                self.unit:ResetWeaponByLabel('RightZephyr')
                self.unit:BuildManipulatorSetEnabled(false)
                self.AimControl:SetEnabled(true)
                self.AimControl:SetPrecedence(20)
                self.unit.BuildArmManipulator:SetPrecedence(0)
                self.AimControl:SetHeadingPitch( self.unit:GetWeaponManipulatorByLabel('RightZephyr'):GetHeadingPitch() )
            end,

            OnWeaponFired = function(self)
                TDFOverchargeWeapon.OnWeaponFired(self)
                self:OnDisableWeapon()
                self:ForkThread(self.PauseOvercharge)
            end,
            
            OnDisableWeapon = function(self)
                if self.unit:BeenDestroyed() then return end
                self:SetWeaponEnabled(false)
                self.unit:SetWeaponEnabledByLabel('RightZephyr', true)
                self.unit:BuildManipulatorSetEnabled(false)
                self.AimControl:SetEnabled(false)
                self.AimControl:SetPrecedence(0)
                self.unit.BuildArmManipulator:SetPrecedence(0)
                self.unit:GetWeaponManipulatorByLabel('RightZephyr'):SetHeadingPitch( self.AimControl:GetHeadingPitch() )
            end,
            
            PauseOvercharge = function(self)
                if not self.unit:IsOverchargePaused() then
                    self.unit:SetOverchargePaused(true)
                    WaitSeconds(1/self:GetBlueprint().RateOfFire)
                    self.unit:SetOverchargePaused(false)
                end
            end,
            
            OnFire = function(self)
                if not self.unit:IsOverchargePaused() then
                    TDFOverchargeWeapon.OnFire(self)
                end
            end,
            IdleState = State(TDFOverchargeWeapon.IdleState) {
                OnGotTarget = function(self)
                    if not self.unit:IsOverchargePaused() then
                        TDFOverchargeWeapon.IdleState.OnGotTarget(self)
                    end
                end,            
                OnFire = function(self)
                    if not self.unit:IsOverchargePaused() then
                        ChangeState(self, self.RackSalvoFiringState)
                    end
                end,
            },
            RackSalvoFireReadyState = State(TDFOverchargeWeapon.RackSalvoFireReadyState) {
                OnFire = function(self)
                    if not self.unit:IsOverchargePaused() then
                        TDFOverchargeWeapon.RackSalvoFireReadyState.OnFire(self)
                    end
                end,
            },            
            
        },
        TacMissile = Class(TIFCruiseMissileLauncher) {
        },
        TacNukeMissile = Class(TIFCruiseMissileLauncher) {
        },
##############VETERANCY WEAPONS#########
		VeteUpgrade1Gun = Class(TDFZephyrCannonWeapon02){
            PlayFxWeaponUnpackSequence = function(self)
                if not self.SpinManip then 
                    self.SpinManip = CreateRotator(self.unit, 'VeteUpgradePart0102', 'z', nil, 200, 150, 40)
                    self.unit.Trash:Add(self.SpinManip)
                end
                if self.SpinManip then
                    self.SpinManip:SetTargetSpeed(270)
                end
                TDFZephyrCannonWeapon02.PlayFxWeaponUnpackSequence(self)
            end,

            PlayFxWeaponPackSequence = function(self)
                if self.SpinManip then
                    self.SpinManip:SetTargetSpeed(0)
                end
                TDFZephyrCannonWeapon02.PlayFxWeaponPackSequence(self)
            end,
        },
		VeteUpgrade2Gun = Class(TDFZephyrCannonWeapon03){
            PlayFxWeaponUnpackSequence = function(self)
                if not self.SpinManip then 
                    self.SpinManip = CreateRotator(self.unit, 'VeteUpgradePart0202', 'z', nil, 200, 150, 40)
                    self.unit.Trash:Add(self.SpinManip)
                end
                if self.SpinManip then
                    self.SpinManip:SetTargetSpeed(270)
                end
                TDFZephyrCannonWeapon03.PlayFxWeaponUnpackSequence(self)
            end,

            PlayFxWeaponPackSequence = function(self)
                if self.SpinManip then
                    self.SpinManip:SetTargetSpeed(0)
                end
                TDFZephyrCannonWeapon03.PlayFxWeaponPackSequence(self)
            end,
        },
#############/VETERANCY WEAPONS###########
    },

    OnCreate = function(self)
        TWalkingLandUnit.OnCreate(self)
        self:SetCapturable(false)
		Army = self:GetArmy()
        self:HideBone('Right_Upgrade', true)
        self:HideBone('Left_Upgrade', true)
        self:HideBone('Back_Upgrade_B01', true)
		
		self:HideBone('VeteUpgradePart0101', true)
		self:HideBone('VeteUpgradePart0201', true)
		
        self:SetupBuildBones()
        self.HasLeftPod = false
        self.HasRightPod = false
        # Restrict what enhancements will enable later
        self:AddBuildRestriction( categories.UEF * (categories.BUILTBYTIER2COMMANDER + categories.BUILTBYTIER3COMMANDER) )
		# ~~~~~~~~~~~~~~~~~~~~~
		# AJOUT PAR MANIMAL :
		# ~~~~~~~~~~~~~~~~~~~~~
		self:AddBuildRestriction( categories.UEF * (categories.REBUILTBYCOMMANDER + categories.REBUILTBYTIER2COMMANDER + categories.REBUILTBYTIER3COMMANDER) )
		self:RequestRefreshUI()
		# ~~~~~~~~~~~~~~~~~~~~~
    end,

    OnPrepareArmToBuild = function(self)
        TWalkingLandUnit.OnPrepareArmToBuild(self)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(true)
        self.BuildArmManipulator:SetPrecedence(20)
        self:SetWeaponEnabledByLabel('RightZephyr', false)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self.BuildArmManipulator:SetHeadingPitch( self:GetWeaponManipulatorByLabel('RightZephyr'):GetHeadingPitch() )
    end,

    OnStopCapture = function(self, target)
        TWalkingLandUnit.OnStopCapture(self, target)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightZephyr', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self:GetWeaponManipulatorByLabel('RightZephyr'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnFailedCapture = function(self, target)
        TWalkingLandUnit.OnFailedCapture(self, target)
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightZephyr', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self:GetWeaponManipulatorByLabel('RightZephyr'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnStopReclaim = function(self, target)
        TWalkingLandUnit.OnStopReclaim(self, target)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightZephyr', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
		self:SetWeaponEnabledByLabel('DeathWeapon', false)
        self:GetWeaponManipulatorByLabel('RightZephyr'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    NukeExplosion = function(self)
        local position = self:GetPosition()
		local army = self:GetArmy()
        self:PlayUnitSound('Nuke')
			# ~~~~~~~~~~~~~~~~~
			# MODIF PAR MANIMAL
			# ~~~~~~~~~~~~~~~~~
			nukeProjectile = self:CreateProjectile( MyModPath .. '/hook/effects/Entities/UEFNukeEffectController01/UEFNukeEffectController01_proj.bp', 0, 0, 0, nil, nil, nil ):SetCollision(false)
			# ~~~~~~~~~~~~~~~~~
            nukeProjectile:PassData(self.Data)
			self:ForkThread(self.CreateOuterRingWaveSmokeRing)

		local orientation = RandomFloat( 0, 2 * math.pi )
    end,

    CreateFirePlumes = function( self, army, bones, yBoneOffset )
        local proj, position, offset, velocity
        local basePosition = self:GetPosition()
        for k, vBone in bones do
            position = self:GetPosition(vBone)
            offset = utilities.GetDifferenceVector( position, basePosition )
            velocity = utilities.GetDirectionVector( position, basePosition ) # 
            velocity.x = velocity.x + utilities.GetRandomFloat(-0.3, 0.3)
            velocity.z = velocity.z + utilities.GetRandomFloat(-0.3, 0.3)
            velocity.y = velocity.y + utilities.GetRandomFloat( 9, 0.3)
            proj = self:CreateProjectile('/effects/entities/DestructionFirePlume01/DestructionFirePlume01_proj.bp', offset.x, offset.y + yBoneOffset, offset.z, velocity.x, velocity.y, velocity.z)
            proj:SetBallisticAcceleration(utilities.GetRandomFloat(-4, -6)):SetVelocity(utilities.GetRandomFloat(9, 11)):SetCollision(false)
            
            local emitter = CreateEmitterOnEntity(proj, army, '/effects/emitters/destruction_explosion_fire_plume_03_emit.bp'):ScaleEmitter(0.5)

            local lifetime = utilities.GetRandomFloat( 20, 32 )
        end
    end,

    CreateExplosionDebris = function( self, army )
        for k, v in EffectTemplate.ExplosionDebrisLrg01 do
            CreateAttachedEmitter( self, 'Torso', army, v )
        end
    end,


	DeathThread = function(self)

		local army = self:GetArmy()

		--# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		--# MODIF PAR MANIMAL :
		--# retour aux conditions de victoire demandes en conservant les kills du mod
		--# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		if ScenarioInfo.Options.Victory == 'demoralization' then
			--# ALL UNITS are dead if you have no Commanders
			local units = ArmyBrains[army]:GetListOfUnits( categories.ALLUNITS, false )
			for index,unit in units do
				unit:Kill()
			end
		end

		self:CreateFirePlumes( army, {'Torso','Torso','Head','Torso','Head','Torso', 'Torso', 'Head', 'Head', }, 0.2 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 4.0 )
		self:PlayUnitSound('Killed2')
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()}) 
		self:PlayUnitSound('Killed')
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B02', 0.5 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
		self:CreateFirePlumes( army, {'Right_Arm_B01','Left_Arm_B01','Head','Torso','Head','Left_Footfall', 'Left_Footfall01', 'Right_Arm_Barrel', 'Left_Arm_Barrel', }, 0.2 )
        self:CreateExplosionDebris( army )
        self:CreateExplosionDebris( army )
        self:CreateExplosionDebris( army )
		self:CreateFirePlumes( army, {'Right_Arm_B01','Left_Arm_B01','Head','Torso','Head','Left_Footfall', 'Left_Footfall01', 'Right_Arm_Barrel', 'Left_Arm_Barrel', }, 0.2 )
        self:ShakeCamera(50, 5, 0, 1)
        for k, v in EffectTemplate.FootFall01 do
            CreateAttachedEmitter(self,'Torso',army, v):ScaleEmitter(2)          
        end
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.5 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Arm_B02', 0.5 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Arm_B01', 0.5 )
		self:PlayUnitSound('Killed')
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.5 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
		self:CreateFirePlumes( army, {'Right_Arm_B01','Left_Arm_B01','Head','Torso','Head','Left_Footfall', 'Left_Footfall01', 'Right_Arm_Barrel', 'Left_Arm_Barrel', }, 0.2 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.5 )       
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.5 )
		self:PlayUnitSound('Killed')
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()})           
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B02', 0.5 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.5 )
		self:PlayUnitSound('Killed')
		self:CreateFirePlumes( army, {'Right_Arm_B01','Left_Arm_B01','Head','Torso','Head','Left_Footfall', 'Left_Footfall01', 'Right_Arm_Barrel', 'Left_Arm_Barrel', }, 0.2 )
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Arm_B02', 0.5 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(0.3)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Arm_B01', 0.5 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.5 )
		self:CreateFirePlumes( army, {'Right_Arm_B01','Left_Arm_B01','Head','Torso','Head','Left_Footfall', 'Left_Footfall01', 'Right_Arm_Barrel', 'Left_Arm_Barrel', }, 0.2 )
		self:PlayUnitSound('Killed')
        WaitSeconds(0.5)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.5 )     
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.5 )
		self:PlayUnitSound('Killed')
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()})    
		self:PlayUnitSound('Killed')
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B02', 0.1 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Arm_B02', 0.1 )
		self:PlayUnitSound('Killed2')
		self:CreateFirePlumes( army, {'Right_Arm_B01','Left_Arm_B01','Head','Torso','Head','Left_Footfall', 'Left_Footfall01', 'Right_Arm_Barrel', 'Left_Arm_Barrel', }, 0.2 )
        WaitSeconds(0.3)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Arm_B01', 0.1 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(0.5)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.1 )     
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.1 )
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()})   
		self:PlayUnitSound('Killed2')        
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B02', 0.1 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Arm_B02', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(0.3)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Arm_B01', 0.1 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.1 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(0.5)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.1 )
		if self.DeathAnimManip then
			WaitFor(self.DeathAnimManip)
		end
		self:NukeExplosion()
		WaitSeconds(2)
		self:Destroy()
	end, 


    GiveInitialResources = function(self)
        WaitTicks(5)
        self:GetAIBrain():GiveResource('Energy', self:GetBlueprint().Economy.StorageEnergy)
        self:GetAIBrain():GiveResource('Mass', self:GetBlueprint().Economy.StorageMass)
    end,


    OnStopBeingBuilt = function(self,builder,layer)
        TWalkingLandUnit.OnStopBeingBuilt(self,builder,layer)
        if self:BeenDestroyed() then return end
        self.Animator = CreateAnimator(self)
        self.Animator:SetPrecedence(0)
        if self.IdleAnim then
            self.Animator:PlayAnim(self:GetBlueprint().Display.AnimationIdle, true)
            for k, v in self.DisabledBones do
                self.Animator:SetBoneEnabled(v, false)
            end
        end
        self:BuildManipulatorSetEnabled(false)
        self:SetWeaponEnabledByLabel('RightZephyr', true)
        self:SetWeaponEnabledByLabel('TacMissile', false)
        self:SetWeaponEnabledByLabel('TacNukeMissile', false)
		###VETE WPN I####
		self:SetWeaponEnabledByLabel('VeteUpgrade1Gun', false)
		###VETE WPN II####
		self:SetWeaponEnabledByLabel('VeteUpgrade2Gun', false)
		###VETE###
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran')
		###VETE###
        self:ForkThread(self.GiveInitialResources)
    end,


    PlayCommanderWarpInEffect = function(self)
        self:HideBone(0, true)
        self:SetUnSelectable(true)
        self:SetBusy(true)
        self:SetBlockCommandQueue(true)
        self:ForkThread(self.WarpInEffectThread)
    end,

    WarpInEffectThread = function(self)
        self:PlayUnitSound('CommanderArrival')
        self:CreateProjectile( '/effects/entities/UnitTeleport01/UnitTeleport01_proj.bp', 0, 1.35, 0, nil, nil, nil):SetCollision(false)
        WaitSeconds(2.1)
		# ~~~~~~~~~~~~~~~~~
		# MODIF PAR MANIMAL
		# ~~~~~~~~~~~~~~~~~
        self:SetMesh( MyModPath .. '/units/MEL0001/MEL0001_PhaseShield_mesh', true )
		# ~~~~~~~~~~~~~~~~~
        self:ShowBone(0, true)
        self:HideBone('Right_Upgrade', true)
        self:HideBone('Left_Upgrade', true)
        self:HideBone('Back_Upgrade_B01', true)
		self:HideBone('VeteUpgradePart0101', true)
		self:HideBone('VeteUpgradePart0201', true)
        self:SetUnSelectable(false)
        self:SetBusy(false)
        self:SetBlockCommandQueue(false)

        local totalBones = self:GetBoneCount() - 1
        local army = self:GetArmy()
        for k, v in EffectTemplate.UnitTeleportSteam01 do
            for bone = 1, totalBones do
                CreateAttachedEmitter(self,bone,army, v)
            end
        end

        WaitSeconds(6)
        self:SetMesh(self:GetBlueprint().Display.MeshBlueprint, true)
    end,


	OnStartBuild = function(self, unitBeingBuilt, order)
		TWalkingLandUnit.OnStartBuild(self, unitBeingBuilt, order)
		if self.Animator then
			self.Animator:SetRate(0)
		end
		self.UnitBeingBuilt = unitBeingBuilt
		self.UnitBuildOrder = order
		self.BuildingUnit = true 
	end,


    OnFailedToBuild = function(self)
        TWalkingLandUnit.OnFailedToBuild(self)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightZephyr', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self:GetWeaponManipulatorByLabel('RightZephyr'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    CreateBuildEffects = function( self, unitBeingBuilt, order )
        local UpgradesFrom = unitBeingBuilt:GetBlueprint().General.UpgradesFrom
        # If we are assisting an upgrading unit, or repairing a unit, play seperate effects
        if (order == 'Repair' and not unitBeingBuilt:IsBeingBuilt()) or (UpgradesFrom and UpgradesFrom != 'none' and self:IsUnitState('Guarding'))then
            EffectUtil.CreateDefaultBuildBeams( self, unitBeingBuilt, self:GetBlueprint().General.BuildBones.BuildEffectBones, self.BuildEffectsBag )
        else
            EffectUtil.CreateUEFCommanderBuildSliceBeams( self, unitBeingBuilt, self:GetBlueprint().General.BuildBones.BuildEffectBones, self.BuildEffectsBag )        
        end           
    end,


	OnStopBuild = function(self, unitBeingBuilt)
		TWalkingLandUnit.OnStopBuild(self, unitBeingBuilt)
		if self:BeenDestroyed() then return end
		if (self.IdleAnim and not self:IsDead()) then
			self.Animator:PlayAnim(self.IdleAnim, true)
		end
		self:BuildManipulatorSetEnabled(false)
		self.BuildArmManipulator:SetPrecedence(0)
		self:SetWeaponEnabledByLabel('RightZephyr', true)
		self:SetWeaponEnabledByLabel('OverCharge', false)
		self:GetWeaponManipulatorByLabel('RightZephyr'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
		self.UnitBeingBuilt = nil
		self.UnitBuildOrder = nil
		self.BuildingUnit = false
	end,


    NotifyOfPodDeath = function(self, pod)
        if pod == 'RightPod' and self.HasLeftPod then
            self:CreateEnhancement('RightPodRemove')
            self:CreateEnhancement('LeftPod')
            self.HasRightPod = false
            self:RequestRefreshUI()
        elseif pod == 'RightPod' and not self.HasLeftPod then
            self:CreateEnhancement('RightPodRemove')
            self:CreateEnhancement('LeftPodRemove')
            self.HasRightPod = false
            self:RequestRefreshUI()
        elseif pod == 'LeftPod' then
            self.HasLeftPod = false
            self:CreateEnhancement('LeftPodRemove')
            self:RequestRefreshUI()
        end
    end,


    OnPaused = function(self)
        TWalkingLandUnit.OnPaused(self)
        if self.BuildingUnit then
            TWalkingLandUnit.StopBuildingEffects(self, self:GetUnitBeingBuilt())
        end    
    end,
    
    OnUnpaused = function(self)
        if self.BuildingUnit then
            TWalkingLandUnit.StartBuildingEffects(self, self:GetUnitBeingBuilt(), self.UnitBuildOrder)
        end
        TWalkingLandUnit.OnUnpaused(self)
    end,      

#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				self:ShowBone('VeteUpgradePart0101', true)
				self:SetWeaponEnabledByLabel('VeteUpgrade1Gun', true)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 110,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = bp.NewRegenRate,
                            Mult = 1,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('VeteUpgradePart0201', true)
				self:SetWeaponEnabledByLabel('VeteUpgrade2Gun', true)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 120,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = 1,
                            Mult = 1,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
	end,


	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	# TOUTES LES AMLIORATIONS UBC
	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    CreateEnhancement = function( self, enh )
        TWalkingLandUnit.CreateEnhancement(self, enh)
        local bpEnh = self:GetBlueprint().Enhancements[enh]
        if not bpEnh then return end

        if enh == 'LeftPod' then
            local location = self:GetPosition('AttachSpecial02')
            local pod = CreateUnitHPR('UEA0001', self:GetArmy(), location[1], location[2], location[3], 0, 0, 0)
            pod:SetParent(self, 'LeftPod')
            pod:SetCreator(self)
            self.Trash:Add(pod)
            self.HasLeftPod = true
            self.LeftPod = pod

			--# NOTIFIER PODs DE RESTRICTION BATIMENTS DEJA CONSTRUITS
			--# ~~~~~~~~~~~~~-~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
			and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
				for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
					cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
					self.LeftPod:AddBuildRestriction( cat )
				end
			end
		
        elseif enh == 'RightPod' then
            local location = self:GetPosition('AttachSpecial01')
            local pod = CreateUnitHPR('UEA0001', self:GetArmy(), location[1], location[2], location[3], 0, 0, 0)
            pod:SetParent(self, 'RightPod')
            pod:SetCreator(self)
            self.Trash:Add(pod)
            self.HasRightPod = true
            self.RightPod = pod

			--# NOTIFIER PODs DE RESTRICTION BATIMENTS DEJA CONSTRUITS
			--# ~~~~~~~~~~~~~-~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
			and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
				for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
					cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
					self.RightPod:AddBuildRestriction( cat )
				end
			end
		
        elseif enh == 'LeftPodRemove' or enh == 'RightPodRemove' then
            if self.LeftPod and not self.LeftPod:IsDead() then
                self.LeftPod:Kill()
            end
            if self.RightPod and not self.RightPod:IsDead() then
                self.RightPod:Kill()
            end
		
        elseif enh == 'Teleporter' then
            self:AddCommandCap('RULEUCC_Teleport')
		
        elseif enh == 'TeleporterRemove' then
            self:RemoveCommandCap('RULEUCC_Teleport')
		
        elseif enh == 'Shield' then
            self:AddToggleCap('RULEUTC_ShieldToggle')
            self:CreatePersonalShield(bpEnh)
            self:SetEnergyMaintenanceConsumptionOverride(bpEnh.MaintenanceConsumptionPerSecondEnergy or 0)
            self:SetMaintenanceConsumptionActive()
		
        elseif enh == 'ShieldRemove' then
            self:DestroyShield()
            self:SetMaintenanceConsumptionInactive()
            RemoveUnitEnhancement(self, 'ShieldRemove')
            self:RemoveToggleCap('RULEUTC_ShieldToggle')
		
        elseif enh == 'ShieldGeneratorField' then
            self:DestroyShield()
            ForkThread(function()
                WaitTicks(1)
                self:CreateShield(bpEnh)
                self:SetEnergyMaintenanceConsumptionOverride(bpEnh.MaintenanceConsumptionPerSecondEnergy or 0)
                self:SetMaintenanceConsumptionActive()
            end)
		
        elseif enh == 'ShieldGeneratorFieldRemove' then
            self:DestroyShield()
            self:SetMaintenanceConsumptionInactive()
            self:RemoveToggleCap('RULEUTC_ShieldToggle')


		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		# GESTION DES BuildRestrictions : GARE AUX PERTES DE MODIFS !
		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        #T2 Engineering
        elseif enh =='AdvancedEngineering' then

			local cat = ParseEntityCategory( bpEnh.BuildableCategoryAdds )  --# BuildableCategoryAdds = 'BUILTBYTIER2COMMANDER UEF'
			self:RemoveBuildRestriction( cat )

			if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
			and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
				for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
					cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
					self:AddBuildRestriction( cat )
				end
			end

			self:RequestRefreshUI()

            if not Buffs['UEFACUT2BuildRate'] then
                BuffBlueprint {
                    Name = 'UEFACUT2BuildRate',
                    DisplayName = 'UEFACUT2BuildRate',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bpEnh.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                        MaxHealth = {
                            Add = bpEnh.NewHealth,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = bpEnh.NewRegenRate,
                            Mult = 1.0,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'UEFACUT2BuildRate')


        elseif enh =='AdvancedEngineeringRemove' then

            local bpEconBR = self:GetBlueprint().Economy.BuildRate
            if not bpEconBR then return end

            if Buff.HasBuff( self, 'UEFACUT2BuildRate' ) then
                Buff.RemoveBuff( self, 'UEFACUT2BuildRate' )
            end

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# N.B. : PROVOQUE PERTE DE RESTRICTIONS SPCIFIQUES AJOUTES VIA LE MOD
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            --self:RestoreBuildRestrictions()
            --self:AddBuildRestriction( categories.UEF * (categories.BUILTBYTIER2COMMANDER + categories.BUILTBYTIER3COMMANDER) )

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# PAR MANIMAL : GESTION DES RESTRICTIONS SINON PERTE DE MODIFS !
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			local preReq = bpEnh.Prerequisite  --#  Prerequisite = 'AdvancedEngineering'
			if  preReq  and  preReq != nil  then
				local bpPreReq = self:GetBlueprint().Enhancements[preReq]
				if  bpPreReq  and  bpPreReq != nil  then
					local cat = ParseEntityCategory( bpPreReq.BuildableCategoryAdds )  --# BuildableCategoryAdds = 'BUILTBYTIER2COMMANDER UEF'
					if  cat  and  cat != nil  then
						self:AddBuildRestriction( cat )
						self:RequestRefreshUI()
					end
					if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
					and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
						for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
							cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
							self:AddBuildRestriction( cat )
							self:RequestRefreshUI()
						end
					end
				end
			end


        #T3 Engineering
        elseif enh =='T3Engineering' then

			local cat = ParseEntityCategory( bpEnh.BuildableCategoryAdds )  --# BuildableCategoryAdds = 'BUILTBYTIER3COMMANDER UEF'
			self:RemoveBuildRestriction( cat )

			if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
			and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
				for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
					cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
					self:AddBuildRestriction( cat )
				end
			end

			self:RequestRefreshUI()

            if not Buffs['UEFACUT3BuildRate'] then
                BuffBlueprint {
                    Name = 'UEFACUT3BuildRate',
                    DisplayName = 'UEFCUT3BuildRate',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bpEnh.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                        MaxHealth = {
                            Add = bpEnh.NewHealth,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = bpEnh.NewRegenRate,
                            Mult = 1.0,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'UEFACUT3BuildRate')


        elseif enh =='T3EngineeringRemove' then

            local bpEconBR = self:GetBlueprint().Economy.BuildRate
            if not bpEconBR then return end

            if Buff.HasBuff( self, 'UEFACUT3BuildRate' ) then
                Buff.RemoveBuff( self, 'UEFACUT3BuildRate' )
            end

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# N.B. : PROVOQUE PERTE DE RESTRICTIONS SPCIFIQUES AJOUTES VIA LE MOD
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            --self:RestoreBuildRestrictions()
            --#self:AddBuildRestriction( categories.UEF * (categories.BUILTBYTIER2COMMANDER + categories.BUILTBYTIER3COMMANDER) )

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# PAR MANIMAL : GESTION DES RESTRICTIONS SINON PERTE DE MODIFS !
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			--# Suppression de 'T3Engineering'
			local preReq = bpEnh.Prerequisite  --#  Prerequisite = 'T3Engineering'
			if  preReq  and  preReq != nil  then

				local bpPreReq = self:GetBlueprint().Enhancements[preReq]
				if  bpPreReq  and  bpPreReq != nil  then

					local cat = ParseEntityCategory( bpPreReq.BuildableCategoryAdds ) --# BuildableCategoryAdds = 'BUILTBYTIER3COMMANDER UEF'
					if  cat  and  cat != nil  then
						self:AddBuildRestriction( cat )
						self:RequestRefreshUI()
					end

					--# Suppression de 'AdvancedEngineering'
					preReq = bpPreReq.Prerequisite  --#  Prerequisite = 'AdvancedEngineering'
					if  preReq  and  preReq != nil  then
						bpPreReq = self:GetBlueprint().Enhancements[preReq]
						if  bpPreReq  and  bpPreReq != nil  then
							cat = ParseEntityCategory( bpPreReq.BuildableCategoryAdds ) --# BuildableCategoryAdds = 'BUILTBYTIER2COMMANDER UEF'
							if  cat  and  cat != nil  then
								self:AddBuildRestriction( cat )
								self:RequestRefreshUI()
							end
						end  --# END  IF  bpPreReq  T2
					end  --# END  IF  preReq  T2

					if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
					and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
						for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
							cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
							self:AddBuildRestriction( cat )
						end
						self:RequestRefreshUI()
					end

				end  --# END  IF  bpPreReq  T3
			end  --# END  IF  preReq  T3


		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		# FIN DE GESTION DES BuildRestrictions - SCRIPT de MANIMAL
		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


        elseif enh =='DamageStablization' then
            self:SetRegenRate(bpEnh.NewRegenRate)
		
        elseif enh =='DamageStablizationRemove' then
            self:RevertRegenRate()
		
        elseif enh =='HeavyAntiMatterCannon' then
            local wep = self:GetWeaponByLabel('RightZephyr')
            wep:AddDamageMod(bpEnh.ZephyrDamageMod)
            wep:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
			local wep2 = self:GetWeaponByLabel('VeteUpgrade1Gun')
			wep2:AddDamageMod(bpEnh.ZephyrDamageModII)
			wep2:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
			local wep3 = self:GetWeaponByLabel('VeteUpgrade2Gun')
			wep3:AddDamageMod(bpEnh.ZephyrDamageModII)
			wep3:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
            local oc = self:GetWeaponByLabel('OverCharge')
            oc:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
		
		--# NOTE DE MANIMAL POUR ASDRUBAEL : PAS ASSEZ DE TEMPS POUR CORRIGER TES ERREURS !!! (TU LES ACCUMULE TROP)
        elseif enh =='HeavyAntiMatterCannonRemove' then
            local bpHAMC = self:GetBlueprint().Enhancements['HeavyAntiMatterCannon']
            if not bpHAMC then return end
            local wep = self:GetWeaponByLabel('RightZephyr')
            wep:AddDamageMod(-bpHAMC.ZephyrDamageMod)
            local bpDisrupt = self:GetBlueprint().Weapon[1].MaxRadius
            wep:ChangeMaxRadius(bpDisrupt or 22)
            local oc = self:GetWeaponByLabel('OverCharge')
            oc:ChangeMaxRadius(bpDisrupt or 22)
		
        #ResourceAllocation              
        elseif enh == 'ResourceAllocation' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEnh.ProductionPerSecondEnergy + bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEnh.ProductionPerSecondMass + bpEcon.ProductionPerSecondMass or 0)
		
        elseif enh == 'ResourceAllocationRemove' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEcon.ProductionPerSecondMass or 0)
		
        elseif enh =='TacticalMissile' then
            self:AddCommandCap('RULEUCC_Tactical')
            self:AddCommandCap('RULEUCC_SiloBuildTactical')
            self:SetWeaponEnabledByLabel('TacMissile', true)
		
        elseif enh =='TacticalNukeMissile' then
            self:RemoveCommandCap('RULEUCC_Tactical')
            self:RemoveCommandCap('RULEUCC_SiloBuildTactical')
            self:AddCommandCap('RULEUCC_Nuke')
            self:AddCommandCap('RULEUCC_SiloBuildNuke')
            self:SetWeaponEnabledByLabel('TacMissile', false)
            self:SetWeaponEnabledByLabel('TacNukeMissile', true)
            local amt = self:GetTacticalSiloAmmoCount()
            self:RemoveTacticalSiloAmmo(amt or 0)
            self:StopSiloBuild()
		
        elseif enh == 'TacticalMissileRemove' or enh == 'TacticalNukeMissileRemove' then
            self:RemoveCommandCap('RULEUCC_Nuke')
            self:RemoveCommandCap('RULEUCC_SiloBuildNuke')
            self:RemoveCommandCap('RULEUCC_Tactical')
            self:RemoveCommandCap('RULEUCC_SiloBuildTactical')
            self:SetWeaponEnabledByLabel('TacMissile', false)
            self:SetWeaponEnabledByLabel('TacNukeMissile', false)
            local amt = self:GetTacticalSiloAmmoCount()
            self:RemoveTacticalSiloAmmo(amt or 0)
            local amt = self:GetNukeSiloAmmoCount()
            self:RemoveNukeSiloAmmo(amt or 0)
            self:StopSiloBuild()
        end
    end,
    
}

TypeClass = MEL0001
