--[[#######################################################################
#  File     :  /units/MSL0001/MSL0001_script.lua
#  Author(s):  Drew Staltman, Jessica St. Croix, Gordon Duclos
#  Summary  :  Special Seraphim Commander Script
#  -----------------------------
#  Modif.by :  AsdrubaelVect -> his home-made cooking
#  Rev.Date :  dd mmmmmm 2009
#  -----------------------------
#  Revis.by :  Manimal -> Fixed up some bugs, not enough time to make Veterancy GENERIC again
#  Rev.Date :  27 mai 2010
#  Rev.Date :  14 juillet 2010 -> Ajout de Restrictions Oublies pour LABOS version 4b
#  Rev.Date :  26 janvier 2011 07:15 -> LABOS version 5.2 
#  Rev.Date :  07 mars 2011 01:08 -> CORRECTIONS 
#  Rev.Date :  20 mars 2011 11:16 -> MODIF KILL UNITS SI ACU MORT + CONDITION ASSASSINAT
#  Rev.Date :  22 mars 2011 00:38 -> CORRECTION OnVeteran
#  -----------------------------
#  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--

#=======================================================================
local Game = import('/lua/game.lua')

#VARIABLE ''GLOBALE'' (par Manimal)
local MyModPath = Game.MyModPath
#=======================================================================


local SWalkingLandUnit = import( MyModPath .. '/hook/lua/seraphimunits.lua' ).SWalkingLandUnit
local Buff = import('/lua/sim/Buff.lua')

local SWeapons = import('/lua/seraphimweapons.lua')
local SDFChronotronCannonWeapon = SWeapons.SDFChronotronCannonWeapon
local SDFChronotronOverChargeCannonWeapon = SWeapons.SDFChronotronCannonOverChargeWeapon
local SIFCommanderDeathWeapon = SWeapons.SIFCommanderDeathWeapon
local EffectTemplate = import('/lua/EffectTemplates.lua')
local EffectUtil = import('/lua/EffectUtilities.lua')
local SIFLaanseTacticalMissileLauncher = SWeapons.SIFLaanseTacticalMissileLauncher
local AIUtils = import('/lua/ai/aiutilities.lua')

# Setup as RemoteViewing child unit rather than SWalkingLandUnit
local RemoteViewing = import('/lua/RemoteViewing.lua').RemoteViewing
SWalkingLandUnit = RemoteViewing( SWalkingLandUnit ) 

local utilities = import('/lua/Utilities.lua')
local RandomFloat = utilities.GetRandomFloat
local explosion = import('/lua/defaultexplosions.lua')

local ScenarioUtils = import('/lua/sim/ScenarioUtilities.lua')
local Buff = import('/lua/sim/Buff.lua')

# ~~~~~~~~~~~~~~~~~~~
# AJOUT PAR MANIMAL :
# ~~~~~~~~~~~~~~~~~~~
--local EW_DefaultUnits = import( MyModPath .. '/hook/lua/EW_DefaultUnits.lua' ) 
--local hasHEB = false # Flag signalant Enhancement avec Heavy Electron Bolter
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# MODIF PAR ASDRUBAEL + CORRECTION PAR MANIMAL
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
--local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
--local hasHEBII = false
--local hasHEBIII = false
--local hasHEBIV = false
--local hasHEBV = false
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


MSL0001 = Class( SWalkingLandUnit ) {
    DeathThreadDestructionWaitTime = 2,

    Weapons = {
        DeathWeapon = Class(SIFCommanderDeathWeapon) {},
        ChronotronCannon = Class(SDFChronotronCannonWeapon) {},
		VeteUpgrade1Gun = Class(SDFChronotronCannonWeapon) {},
		VeteUpgrade2Gun = Class(SDFChronotronCannonWeapon) {},

        Missile = Class(SIFLaanseTacticalMissileLauncher) {
            OnCreate = function(self)
                SIFLaanseTacticalMissileLauncher.OnCreate(self)
                self:SetWeaponEnabled(false)
            end,
        },
        OverCharge = Class(SDFChronotronOverChargeCannonWeapon) {

            OnCreate = function(self)
                SDFChronotronOverChargeCannonWeapon.OnCreate(self)
                self:SetWeaponEnabled(false)
                self.AimControl:SetEnabled(false)
                self.AimControl:SetPrecedence(0)
				self.unit:SetOverchargePaused(false)
            end,

            OnEnableWeapon = function(self)
                if self:BeenDestroyed() then return end
                SDFChronotronOverChargeCannonWeapon.OnEnableWeapon(self)
                self:SetWeaponEnabled(true)
                self.unit:SetWeaponEnabledByLabel('ChronotronCannon', false)
                self.unit:BuildManipulatorSetEnabled(false)
                self.AimControl:SetEnabled(true)
                self.AimControl:SetPrecedence(20)
                self.unit.BuildArmManipulator:SetPrecedence(0)
                self.AimControl:SetHeadingPitch( self.unit:GetWeaponManipulatorByLabel('ChronotronCannon'):GetHeadingPitch() )
            end,
            
            OnWeaponFired = function(self)
                SDFChronotronOverChargeCannonWeapon.OnWeaponFired(self)
                self:OnDisableWeapon()
                self:ForkThread(self.PauseOvercharge)
            end,
            
            OnDisableWeapon = function(self)
                if self.unit:BeenDestroyed() then return end
                self:SetWeaponEnabled(false)
                self.unit:SetWeaponEnabledByLabel('ChronotronCannon', true)
                self.unit:BuildManipulatorSetEnabled(false)
                self.AimControl:SetEnabled(false)
                self.AimControl:SetPrecedence(0)
                self.unit.BuildArmManipulator:SetPrecedence(0)
                self.unit:GetWeaponManipulatorByLabel('ChronotronCannon'):SetHeadingPitch( self.AimControl:GetHeadingPitch() )
            end,
            
            PauseOvercharge = function(self)
                if not self.unit:IsOverchargePaused() then
                    self.unit:SetOverchargePaused(true)
                    WaitSeconds(1/self:GetBlueprint().RateOfFire)
                    self.unit:SetOverchargePaused(false)
                end
            end,
            
            OnFire = function(self)
                if not self.unit:IsOverchargePaused() then
                    SDFChronotronOverChargeCannonWeapon.OnFire(self)
                end
            end,
            IdleState = State(SDFChronotronOverChargeCannonWeapon.IdleState) {
                OnGotTarget = function(self)
                    if not self.unit:IsOverchargePaused() then
                        SDFChronotronOverChargeCannonWeapon.IdleState.OnGotTarget(self)
                    end
                end,            
                OnFire = function(self)
                    if not self.unit:IsOverchargePaused() then
                        ChangeState(self, self.RackSalvoFiringState)
                    end
                end,
            },
            RackSalvoFireReadyState = State(SDFChronotronOverChargeCannonWeapon.RackSalvoFireReadyState) {
                OnFire = function(self)
                    if not self.unit:IsOverchargePaused() then
                        SDFChronotronOverChargeCannonWeapon.RackSalvoFireReadyState.OnFire(self)
                    end
                end,
            },  
        },
    },


    OnCreate = function(self)
        SWalkingLandUnit.OnCreate(self)
        self:SetCapturable(false)
        self:SetupBuildBones()
        self:HideBone('Back_Upgrade', true)
        self:HideBone('Right_Upgrade', true)
        self:HideBone('Left_Upgrade', true)
		
		self:HideBone('VeteUpgradePart0101', true)
		self:HideBone('VeteUpgradePart0201', true)
        # Restrict what enhancements will enable later
        self:AddBuildRestriction( categories.SERAPHIM * (categories.BUILTBYTIER2COMMANDER + categories.BUILTBYTIER3COMMANDER) )
 		# ~~~~~~~~~~~~~~~~~~~~~
		# AJOUT PAR MANIMAL :
		# ~~~~~~~~~~~~~~~~~~~~~
		self:AddBuildRestriction( categories.SERAPHIM * (categories.REBUILTBYCOMMANDER + categories.REBUILTBYTIER2COMMANDER + categories.REBUILTBYTIER3COMMANDER) )
		self:RequestRefreshUI()
		# ~~~~~~~~~~~~~~~~~~~~~
   end,

    OnPrepareArmToBuild = function(self)
        SWalkingLandUnit.OnPrepareArmToBuild(self)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(true)
        self.BuildArmManipulator:SetPrecedence(20)
        self:SetWeaponEnabledByLabel('ChronotronCannon', false)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self.BuildArmManipulator:SetHeadingPitch( self:GetWeaponManipulatorByLabel('ChronotronCannon'):GetHeadingPitch() )
    end,

    OnStopCapture = function(self, target)
        SWalkingLandUnit.OnStopCapture(self, target)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('ChronotronCannon', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self:GetWeaponManipulatorByLabel('ChronotronCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnFailedCapture = function(self, target)
        SWalkingLandUnit.OnFailedCapture(self, target)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('ChronotronCannon', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self:GetWeaponManipulatorByLabel('ChronotronCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnStopReclaim = function(self, target)
        SWalkingLandUnit.OnStopReclaim(self, target)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('ChronotronCannon', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self:GetWeaponManipulatorByLabel('ChronotronCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnStopBeingBuilt = function(self,builder,layer)
        SWalkingLandUnit.OnStopBeingBuilt(self,builder,layer)
        self:DisableRemoteViewingButtons()
        self:SetWeaponEnabledByLabel('ChronotronCannon', true)

		###VETE WPN I####
		self:SetWeaponEnabledByLabel('VeteUpgrade1Gun', false)
		###VETE WPN II####
		self:SetWeaponEnabledByLabel('VeteUpgrade2Gun', false)
		###VETE###
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran')	
		###VETE###		
		
        self:ForkThread(self.GiveInitialResources)
        self.ShieldEffectsBag = {}
    end,

    OnFailedToBuild = function(self)
        SWalkingLandUnit.OnFailedToBuild(self)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('ChronotronCannon', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self:GetWeaponManipulatorByLabel('ChronotronCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnStartBuild = function(self, unitBeingBuilt, order)
        local bp = self:GetBlueprint()
        if order != 'Upgrade' or bp.Display.ShowBuildEffectsDuringUpgrade then
            self:StartBuildingEffects(unitBeingBuilt, order)
        end
        self:DoOnStartBuildCallbacks(unitBeingBuilt)
        self:SetActiveConsumptionActive()
        self:PlayUnitSound('Construct')
        self:PlayUnitAmbientSound('ConstructLoop')
        if bp.General.UpgradesTo and unitBeingBuilt:GetUnitId() == bp.General.UpgradesTo and order == 'Upgrade' then
            self.Upgrading = true
            self.BuildingUnit = false        
            unitBeingBuilt.DisallowCollisions = true
        end
        self.UnitBeingBuilt = unitBeingBuilt
        self.UnitBuildOrder = order
        self.BuildingUnit = true
    end,  

    OnStopBuild = function(self, unitBeingBuilt)
        SWalkingLandUnit.OnStopBuild(self, unitBeingBuilt)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('ChronotronCannon', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self:GetWeaponManipulatorByLabel('ChronotronCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
        self.UnitBeingBuilt = nil
        self.UnitBuildOrder = nil
        self.BuildingUnit = false
    end,
    
    PlayCommanderWarpInEffect = function(self)
        self:HideBone(0, true)
        self:SetUnSelectable(true)
        self:SetBusy(true)
        self:SetBlockCommandQueue(true)
        self:ForkThread(self.WarpInEffectThread)
    end, 
    
    WarpInEffectThread = function(self)
        self:PlayUnitSound('CommanderArrival')
        self:CreateProjectile( '/effects/entities/UnitTeleport01/UnitTeleport01_proj.bp', 0, 1.35, 0, nil, nil, nil):SetCollision(false)
        WaitSeconds(2.1)
        self:ShowBone(0, true)
        self:HideBone('Back_Upgrade', true)
        self:HideBone('Right_Upgrade', true)
        self:HideBone('Left_Upgrade', true)
		self:HideBone('VeteUpgradePart0101', true)
		self:HideBone('VeteUpgradePart0201', true)
        self:SetUnSelectable(false)
        self:SetBusy(false)
        self:SetBlockCommandQueue(false)

        local totalBones = self:GetBoneCount() - 1
        local army = self:GetArmy()
        for k, v in EffectTemplate.UnitTeleportSteam01 do
            for bone = 1, totalBones do
                CreateAttachedEmitter(self,bone,army, v)
            end
        end

        WaitSeconds(6)
    end,


    NukeExplosion = function(self)
        local position = self:GetPosition()
		local army = self:GetArmy()
        self:PlayUnitSound('Nuke')
			nukeProjectile = self:CreateProjectile( MyModPath .. '/hook/effects/Entities/InainoEffectController01/InainoEffectController01_proj.bp', 0, 0, 0, nil, nil, nil):SetCollision(false)
            nukeProjectile:PassData(self.Data) self:ForkThread(self.CreateOuterRingWaveSmokeRing)  # MyModPath .. 'hook/effects/Entities/UEFNukeEffectController01/UEFNukeEffectController01_proj.bp'

		local orientation = RandomFloat( 0, 2 * math.pi )
    end,

    CreateFirePlumes = function( self, army, bones, yBoneOffset )
        local proj, position, offset, velocity
        local basePosition = self:GetPosition()
        for k, vBone in bones do
            position = self:GetPosition(vBone)
            offset = utilities.GetDifferenceVector( position, basePosition )
            velocity = utilities.GetDirectionVector( position, basePosition ) # 
            velocity.x = velocity.x + utilities.GetRandomFloat(-0.3, 0.3)
            velocity.z = velocity.z + utilities.GetRandomFloat(-0.3, 0.3)
            velocity.y = velocity.y + utilities.GetRandomFloat( 9, 0.3)
            proj = self:CreateProjectile('/effects/entities/DestructionFirePlume01/DestructionFirePlume01_proj.bp', offset.x, offset.y + yBoneOffset, offset.z, velocity.x, velocity.y, velocity.z)
            proj:SetBallisticAcceleration(utilities.GetRandomFloat(-4, -6)):SetVelocity(utilities.GetRandomFloat(9, 11)):SetCollision(false)
            
            local emitter = CreateEmitterOnEntity(proj, army, '/effects/emitters/destruction_explosion_fire_plume_03_emit.bp'):ScaleEmitter(0.5)

            local lifetime = utilities.GetRandomFloat( 20, 32 )
        end
    end,	

    CreateExplosionDebris = function( self, army )
        for k, v in EffectTemplate.ExplosionDebrisLrg01 do
            CreateAttachedEmitter( self, 'Torso', army, v )
        end
    end,	


	DeathThread = function(self)

		local army = self:GetArmy()

		--# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		--# MODIF PAR MANIMAL :
		--# retour aux conditions de victoire demandes en conservant les kills du mod
		--# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		if ScenarioInfo.Options.Victory == 'demoralization' then
			--# ALL UNITS are dead if you have no Commanders
			local units = ArmyBrains[army]:GetListOfUnits( categories.ALLUNITS, false )
			for index,unit in units do
				unit:Kill()
			end
		end

		self:CreateFirePlumes( army, {'Torso','Torso','Head','Torso','Head','Torso', 'Torso', 'Head', 'Head', }, 0.2 )				
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 4.0 )
		self:PlayUnitSound('Killed2')
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()}) 
		self:PlayUnitSound('Killed')		
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B02', 0.5 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
		self:CreateFirePlumes( army, {'Right_Arm_B01','Left_Arm_B01','Head','Torso','Head','Left_Ankle', 'Right_Ankle', 'Left_Arm_B02', 'Right_Arm_B02', }, 0.2 )				
        self:CreateExplosionDebris( army )
        self:CreateExplosionDebris( army )
        self:CreateExplosionDebris( army )
		self:CreateFirePlumes( army, {'Right_Arm_B01','Left_Arm_B01','Head','Torso','Head','Left_Ankle', 'Right_Ankle', 'Left_Arm_B02', 'Right_Arm_B02', }, 0.2 )		
        self:ShakeCamera(50, 5, 0, 1)
        for k, v in EffectTemplate.FootFall01 do
            CreateAttachedEmitter(self,'Torso',army, v):ScaleEmitter(2)          
            CreateAttachedEmitter(self,'Torso',army, v):ScaleEmitter(2) 
        end		
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.5 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Arm_B02', 0.5 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Arm_B01', 0.5 )
		self:PlayUnitSound('Killed')
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.5 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
		self:CreateFirePlumes( army, {'Right_Arm_B01','Left_Arm_B01','Head','Torso','Head','Left_Ankle', 'Right_Ankle', 'Left_Arm_B02', 'Right_Arm_B02', }, 0.2 )				
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.5 )       
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.5 )
		self:PlayUnitSound('Killed')
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()})           
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B02', 0.5 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.5 )
		self:PlayUnitSound('Killed')
		self:CreateFirePlumes( army, {'Right_Arm_B01','Left_Arm_B01','Head','Torso','Head','Left_Ankle', 'Right_Ankle', 'Left_Arm_B02', 'Right_Arm_B02', }, 0.2 )				
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Arm_B02', 0.5 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(0.3)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Arm_B01', 0.5 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.5 )
		self:CreateFirePlumes( army, {'Right_Arm_B01','Left_Arm_B01','Head','Torso','Head','Left_Ankle', 'Right_Ankle', 'Left_Arm_B02', 'Right_Arm_B02', }, 0.2 )				
		self:PlayUnitSound('Killed')
        WaitSeconds(0.5)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.5 )     
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.5 )
		self:PlayUnitSound('Killed')
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()})    
		self:PlayUnitSound('Killed')		
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B02', 0.1 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Arm_B02', 0.1 )
		self:PlayUnitSound('Killed2')
		self:CreateFirePlumes( army, {'Right_Arm_B01','Left_Arm_B01','Head','Torso','Head','Left_Ankle', 'Right_Ankle', 'Left_Arm_B02', 'Right_Arm_B02', }, 0.2 )			
        WaitSeconds(0.3)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Arm_B01', 0.1 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(0.5)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.1 )     
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.1 )
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()})   
		self:PlayUnitSound('Killed2')        
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B02', 0.1 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Arm_B02', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(0.3)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Arm_B01', 0.1 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg_B01', 0.1 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(0.5)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.1 )     		
		if self.DeathAnimManip then
			WaitFor(self.DeathAnimManip)
		end
		self:NukeExplosion()
		WaitSeconds(2)
		self:Destroy()
	end, 	


    GiveInitialResources = function(self)
        WaitTicks(2)
        self:GetAIBrain():GiveResource('Energy', self:GetBlueprint().Economy.StorageEnergy)
        self:GetAIBrain():GiveResource('Mass', self:GetBlueprint().Economy.StorageMass)
    end,

    CreateBuildEffects = function( self, unitBeingBuilt, order )
        EffectUtil.CreateSeraphimUnitEngineerBuildingEffects( self, unitBeingBuilt, self:GetBlueprint().General.BuildBones.BuildEffectBones, self.BuildEffectsBag )
    end,

    RegenBuffThread = function(self)
        while not self:IsDead() do
            #Get friendly units in the area (including self)
            local units = AIUtils.GetOwnUnitsAroundPoint(self:GetAIBrain(), categories.BUILTBYTIER3FACTORY + categories.BUILTBYQUANTUMGATE + categories.NEEDMOBILEBUILD, self:GetPosition(), self:GetBlueprint().Enhancements.RegenAura.Radius)
            
            #Give them a 5 second regen buff
            for _,unit in units do
                Buff.ApplyBuff(unit, 'SeraphimACURegenAura')
            end
            
            #Wait 5 seconds
            WaitSeconds(5)
        end
    end,
       
    AdvancedRegenBuffThread = function(self)
        while not self:IsDead() do
            #Get friendly units in the area (including self)
            local units = AIUtils.GetOwnUnitsAroundPoint(self:GetAIBrain(), categories.BUILTBYTIER3FACTORY + categories.BUILTBYQUANTUMGATE + categories.NEEDMOBILEBUILD, self:GetPosition(), self:GetBlueprint().Enhancements.AdvancedRegenAura.Radius)
            
            #Give them a 5 second regen buff
            for _,unit in units do
                Buff.ApplyBuff(unit, 'SeraphimAdvancedACURegenAura')
            end
            
            #Wait 5 seconds
            WaitSeconds(5)
        end
    end,


    OnPaused = function(self)
        SWalkingLandUnit.OnPaused(self)
        if self.BuildingUnit then
            SWalkingLandUnit.StopBuildingEffects(self, self:GetUnitBeingBuilt())
        end
    end,

    OnUnpaused = function(self)
        if self.BuildingUnit then
            SWalkingLandUnit.StartBuildingEffects(self, self:GetUnitBeingBuilt(), self.UnitBuildOrder)
        end
        SWalkingLandUnit.OnUnpaused(self)
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				self:ShowBone('VeteUpgradePart0101', true)
				self:SetWeaponEnabledByLabel('VeteUpgrade1Gun', true)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 100,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = 1,
                            Mult = 1,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('VeteUpgradePart0201', true)
				self:SetWeaponEnabledByLabel('VeteUpgrade2Gun', true)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 120,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = 1,
                            Mult = 1,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################	
	end,	


	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	# TOUTES LES AMLIORATIONS UBC
	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    CreateEnhancement = function( self, enh )
        SWalkingLandUnit.CreateEnhancement( self, enh )
        local bpEnh = self:GetBlueprint().Enhancements[enh]
        if not bpEnh then return end

        # Regenerative Aura
        if enh == 'RegenAura' then
            if not Buffs['SeraphimACURegenAura'] then
                BuffBlueprint {
                    Name = 'SeraphimACURegenAura',
                    DisplayName = 'SeraphimACURegenAura',
                    BuffType = 'COMMANDERAURA',
                    Stacks = 'REPLACE',
                    Duration = 5,
                    Affects = {
                        RegenPercent = {
                            Add = 0,
                            Mult = bpEnh.RegenPerSecond or 0.1,
                            Ceil = bpEnh.RegenCeiling,
                            Floor = bpEnh.RegenFloor,
                        },
                    },
                }
                
            end
                
            table.insert( self.ShieldEffectsBag, CreateAttachedEmitter( self, 'XSL0001', self:GetArmy(), '/effects/emitters/seraphim_regenerative_aura_01_emit.bp' ) )
            self.RegenThreadHandle = self:ForkThread(self.RegenBuffThread)
                        
        elseif enh == 'RegenAuraRemove' then
            if self.ShieldEffectsBag then
                for k, v in self.ShieldEffectsBag do
                    v:Destroy()
                end
		        self.ShieldEffectsBag = {}
		    end
            KillThread(self.RegenThreadHandle)
            
        elseif enh == 'AdvancedRegenAura' then
            if self.RegenThreadHandle then
                if self.ShieldEffectsBag then
                    for k, v in self.ShieldEffectsBag do
                        v:Destroy()
                    end
		            self.ShieldEffectsBag = {}
		        end
                KillThread(self.RegenThreadHandle)
                
            end
            
            if not Buffs['SeraphimAdvancedACURegenAura'] then
                BuffBlueprint {
                    Name = 'SeraphimAdvancedACURegenAura',
                    DisplayName = 'SeraphimAdvancedACURegenAura',
                    BuffType = 'COMMANDERAURA',
                    Stacks = 'REPLACE',
                    Duration = 5,
                    Affects = {
                        RegenPercent = {
                            Add = 0,
                            Mult = bpEnh.RegenPerSecond or 0.1,
                            Ceil = bpEnh.RegenCeiling,
                            Floor = bpEnh.RegenFloor,
                        },
                        MaxHealth = {
                            Add = 0,
                            Mult = bpEnh.MaxHealthFactor or 1.0,
                            DoNoFill = true,
                        },                        
                    },
                }
            end
            
            table.insert( self.ShieldEffectsBag, CreateAttachedEmitter( self, 'XSL0001', self:GetArmy(), '/effects/emitters/seraphim_regenerative_aura_01_emit.bp' ) )
            self.AdvancedRegenThreadHandle = self:ForkThread(self.AdvancedRegenBuffThread)
            
        elseif enh == 'AdvancedRegenAuraRemove' then
            if self.ShieldEffectsBag then
                for k, v in self.ShieldEffectsBag do
                    v:Destroy()
                end
		        self.ShieldEffectsBag = {}
		    end
            KillThread(self.AdvancedRegenThreadHandle)
            
        #Resource Allocation
        elseif enh == 'ResourceAllocation' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEnh.ProductionPerSecondEnergy + bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEnh.ProductionPerSecondMass + bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'ResourceAllocationRemove' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'ResourceAllocationAdvanced' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEnh.ProductionPerSecondEnergy + bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEnh.ProductionPerSecondMass + bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'ResourceAllocationAdvancedRemove' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEcon.ProductionPerSecondMass or 0)
        #Damage Stabilization
        elseif enh == 'DamageStabilization' then
            if not Buffs['SeraphimACUDamageStabilization'] then
               BuffBlueprint {
                    Name = 'SeraphimACUDamageStabilization',
                    DisplayName = 'SeraphimACUDamageStabilization',
                    BuffType = 'ACUUPGRADEDMG',
                    Stacks = 'ALWAYS',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = bpEnh.NewHealth,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = bpEnh.NewRegenRate,
                            Mult = 1.0,
                        },
                    },
                } 
            end
            if Buff.HasBuff( self, 'SeraphimACUDamageStabilization' ) then
                Buff.RemoveBuff( self, 'SeraphimACUDamageStabilization' )
            end  
            Buff.ApplyBuff(self, 'SeraphimACUDamageStabilization')    
        elseif enh == 'DamageStabilizationAdvanced' then
            if not Buffs['SeraphimACUDamageStabilizationAdv'] then
               BuffBlueprint {
                    Name = 'SeraphimACUDamageStabilizationAdv',
                    DisplayName = 'SeraphimACUDamageStabilizationAdv',
                    BuffType = 'ACUUPGRADEDMG',
                    Stacks = 'ALWAYS',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = bpEnh.NewHealth,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = bpEnh.NewRegenRate,
                            Mult = 1.0,
                        },
                    },
                } 
            end
            if Buff.HasBuff( self, 'SeraphimACUDamageStabilizationAdv' ) then
                Buff.RemoveBuff( self, 'SeraphimACUDamageStabilizationAdv' )
            end  
            Buff.ApplyBuff(self, 'SeraphimACUDamageStabilizationAdv')     	    
        elseif enh == 'DamageStabilizationAdvancedRemove' then
            # since there's no way to just remove an upgrade anymore, if we're remove adv, we're removing both
            if Buff.HasBuff( self, 'SeraphimACUDamageStabilizationAdv' ) then
                Buff.RemoveBuff( self, 'SeraphimACUDamageStabilizationAdv' )
            end
            if Buff.HasBuff( self, 'SeraphimACUDamageStabilization' ) then
                Buff.RemoveBuff( self, 'SeraphimACUDamageStabilization' )
            end         
        elseif enh == 'DamageStabilizationRemove' then
            if Buff.HasBuff( self, 'SeraphimACUDamageStabilization' ) then
                Buff.RemoveBuff( self, 'SeraphimACUDamageStabilization' )
            end           
        #Teleporter
        elseif enh == 'Teleporter' then
            self:AddCommandCap('RULEUCC_Teleport')
        elseif enh == 'TeleporterRemove' then
            self:RemoveCommandCap('RULEUCC_Teleport')
        # Tactical Missile
        elseif enh == 'Missile' then
            self:AddCommandCap('RULEUCC_Tactical')
            self:AddCommandCap('RULEUCC_SiloBuildTactical')        
            self:SetWeaponEnabledByLabel('Missile', true)
        elseif enh == 'MissileRemove' then
            self:RemoveCommandCap('RULEUCC_Tactical')
            self:RemoveCommandCap('RULEUCC_SiloBuildTactical')        
            self:SetWeaponEnabledByLabel('Missile', false)


		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		# GESTION DES BuildRestrictions : GARE AUX PERTES DE MODIFS !
		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        #T2 Engineering
        elseif enh =='AdvancedEngineering' then

			local cat = ParseEntityCategory( bpEnh.BuildableCategoryAdds )
			self:RemoveBuildRestriction( cat )

			if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
			and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
				for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
					cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
					self:AddBuildRestriction( cat )
				end
			end

			self:RequestRefreshUI()


            if not Buffs['SeraphimACUT2BuildRate'] then
                BuffBlueprint {
                    Name = 'SeraphimACUT2BuildRate',
                    DisplayName = 'SeraphimACUT2BuildRate',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bpEnh.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                        MaxHealth = {
                            Add = bpEnh.NewHealth,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = bpEnh.NewRegenRate,
                            Mult = 1.0,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'SeraphimACUT2BuildRate')


        elseif enh =='AdvancedEngineeringRemove' then

            local bpEconBR = self:GetBlueprint().Economy.BuildRate
            if not bpEconBR then return end

            if Buff.HasBuff( self, 'SeraphimACUT2BuildRate' ) then
                Buff.RemoveBuff( self, 'SeraphimACUT2BuildRate' )
            end

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# N.B. : PROVOQUE PERTE DE RESTRICTIONS SPCIFIQUES AJOUTES VIA LE MOD
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            --self:RestoreBuildRestrictions()
            --self:AddBuildRestriction( categories.SERAPHIM * (categories.BUILTBYTIER2COMMANDER + categories.BUILTBYTIER3COMMANDER) )

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# PAR MANIMAL : GESTION DES RESTRICTIONS SINON PERTE DE MODIFS !
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			local preReq = bpEnh.Prerequisite
			if  preReq  and  preReq != nil  then
				local bpPreReq = self:GetBlueprint().Enhancements[preReq]
				if  bpPreReq  and  bpPreReq != nil  then
					local cat = ParseEntityCategory( bpPreReq.BuildableCategoryAdds )
					if  cat  and  cat != nil  then
						self:AddBuildRestriction( cat )
						self:RequestRefreshUI()
					end
					if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
					and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
						for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
							cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
							self:AddBuildRestriction( cat )
						end
						self:RequestRefreshUI()
					end
				end
			end


        #T3 Engineering
        elseif enh =='T3Engineering' then

			local cat = ParseEntityCategory( bpEnh.BuildableCategoryAdds )
			self:RemoveBuildRestriction( cat )

			if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
			and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
				for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
					cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
					self:AddBuildRestriction( cat )
				end
			end

			self:RequestRefreshUI()

            if not Buffs['SeraphimACUT3BuildRate'] then
                BuffBlueprint {
                    Name = 'SeraphimACUT3BuildRate',
                    DisplayName = 'SeraphimCUT3BuildRate',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bpEnh.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                        MaxHealth = {
                            Add = bpEnh.NewHealth,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = bpEnh.NewRegenRate,
                            Mult = 1.0,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'SeraphimACUT3BuildRate')


        elseif enh =='T3EngineeringRemove' then

            local bpEconBR = self:GetBlueprint().Economy.BuildRate
            if not bpEconBR then return end

            if Buff.HasBuff( self, 'SeraphimACUT3BuildRate' ) then
                Buff.RemoveBuff( self, 'SeraphimACUT3BuildRate' )
            end

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# N.B. : PROVOQUE PERTE DE RESTRICTIONS SPCIFIQUES AJOUTES VIA LE MOD
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            --self:RestoreBuildRestrictions()
            --self:AddBuildRestriction( categories.SERAPHIM * ( categories.BUILTBYTIER2COMMANDER + categories.BUILTBYTIER3COMMANDER) )

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# PAR MANIMAL : GESTION DES RESTRICTIONS SINON PERTE DE MODIFS !
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			--# Suppression de 'T3Engineering'
			local preReq = bpEnh.Prerequisite
			if  preReq  and  preReq != nil  then

				local bpPreReq = self:GetBlueprint().Enhancements[preReq]
				if  bpPreReq  and  bpPreReq != nil  then

					local cat = ParseEntityCategory( bpPreReq.BuildableCategoryAdds )
					if  cat  and  cat != nil  then
						self:AddBuildRestriction( cat )
						self:RequestRefreshUI()
					end

					--# Suppression de 'AdvancedEngineering'
					preReq = bpPreReq.Prerequisite
					if  preReq  and  preReq != nil  then
						bpPreReq = self:GetBlueprint().Enhancements[preReq]
						if  bpPreReq  and  bpPreReq != nil  then
							cat = ParseEntityCategory( bpPreReq.BuildableCategoryAdds )
							if  cat  and  cat != nil  then
								self:AddBuildRestriction( cat )
								self:RequestRefreshUI()
							end
						end  --# END  IF  bpPreReq  T2
					end  --# END  IF  preReq  T2

					if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
					and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
						for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
							cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
							self:AddBuildRestriction( cat )
						end
						self:RequestRefreshUI()
					end

				end  --# END  IF  bpPreReq  T3
			end  --# END  IF  preReq  T3

		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		# FIN DE GESTION DES BuildRestrictions - SCRIPT de MANIMAL
		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        #Blast Attack
        elseif enh == 'BlastAttack' then
            local wep = self:GetWeaponByLabel('ChronotronCannon')
            wep:AddDamageRadiusMod(bpEnh.NewDamageRadius or 5)
            wep:AddDamageMod(bpEnh.AdditionalDamage)
        elseif enh == 'BlastAttackRemove' then
            local wep = self:GetWeaponByLabel('ChronotronCannon')
            wep:AddDamageRadiusMod(bpEnh.NewDamageRadius or 5)
            wep:AddDamageMod(-self:GetBlueprint().Enhancements['BlastAttack'].AdditionalDamage)
        #Heat Sink Augmentation
        elseif enh == 'RateOfFire' then
            local wep = self:GetWeaponByLabel('ChronotronCannon')
            wep:ChangeRateOfFire(bpEnh.NewRateOfFire or 2)
            wep:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
            local oc = self:GetWeaponByLabel('OverCharge')
            oc:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)            
        elseif enh == 'RateOfFireRemove' then
            local wep = self:GetWeaponByLabel('ChronotronCannon')
            local bpDisrupt = self:GetBlueprint().Weapon[1].RateOfFire
            wep:ChangeRateOfFire(bpDisrupt or 1)
            bpDisrupt = self:GetBlueprint().Weapon[1].MaxRadius            
            wep:ChangeMaxRadius(bpDisrupt or 22)
            local oc = self:GetWeaponByLabel('OverCharge')
            oc:ChangeMaxRadius(bpDisrupt or 22)                        
        # Remote Viewing system
        #elseif enh == 'RemoteViewing' then
        #    self.Sync.Abilities = {[bpEnh.NewAbility] = self:GetBlueprint().Abilities[bpEnh.NewAbility]}
        #    self:SetEnergyMaintenanceConsumptionOverride(bpEnh.MaintenanceConsumptionPerSecondEnergy or 0)
        #    self:SetMaintenanceConsumptionInactive()
        #    self:EnableRemoteViewingButtons()
        #elseif enh == 'RemoteViewingRemove' then
        #    self.Sync.Abilities = false
        #    self.RemoteViewingData.VisibleLocation = false
        #    self:DisableRemoteViewingButtons()
        end
    end,

}

TypeClass = MSL0001
