--[[#######################################################################
#  File     :  /units/QuantumHeroesGate/UAB0110/UAB0110_script.lua
#  Author(s):  John Comes, David Tomandl, Gordon Duclos
#  Summary  :  Special AEON Quantum Gate Script
#  -----------------------------
#  Modif.by :  AsdrubaelVect
#  Rev.Date :  5 septembre 2009
#  -----------------------------
#  Revis.by :  Manimal
#  Rev.Date :  24 fvrier 2010
#  -----------------------------
#  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--


#######################################################################
local Game = import('/lua/game.lua')

#VARIABLE ''GLOBALE'' (par Manimal)
local MyModPath = Game.MyModPath
#######################################################################



# AJOUT DE MANIMAL
local APortalFactoryUnit = import( MyModPath .. '/hook/lua/aeonunits.lua' ).APortalFactoryUnit


UAB0110 = Class( APortalFactoryUnit ) {

    BuildAttachBone01 = 'BuildAttachBone01',
    UpgradeThreshhold1 = 0.167,
    UpgradeThreshhold2 = 0.5,

    OnStopBeingBuilt = function(self,Opener,layer)
        --AAirFactoryUnit.OnStopBeingBuilt(self, Opener, layer)	# NOTE DE MANIMAL : POURQUOI AIR FACTORY POUR UNE GATE ??? o_O
        APortalFactoryUnit.OnStopBeingBuilt(self, Opener, layer)
	---	if( not self.ConstructAnimManip ) then
		--	self.ConstructAnimManip = CreateAnimator(self)
		---	self.ConstructAnimManip:PlayAnim(self:GetBlueprint().Display.AnimationConstruct)
	---		self.ConstructAnimManip:SetRate(1)
      --  end
    end,
	
    OnStartBuild = function(self, unitBeingBuilt, order)
        --AAirFactoryUnit.OnStartBuild(self, unitBeingBuilt, order)	# NOTE DE MANIMAL : POURQUOI AIR FACTORY POUR UNE GATE ??? o_O
        APortalFactoryUnit.OnStartBuild(self, unitBeingBuilt, order)

		
		self.Effect1 = CreateAttachedEmitter(self,'AttachBone01',self:GetArmy(), '/effects/emitters/cybran_shield_05_generator_01_emit.bp')
		self.Effect2 = CreateAttachedEmitter(self,'AttachBone02',self:GetArmy(), '/effects/emitters/cybran_shield_05_generator_01_emit.bp')
		self.Effect3 = CreateAttachedEmitter(self,'AttachBone02',self:GetArmy(), '/effects/emitters/cybran_shield_05_generator_01_emit.bp')
		self.Effect4 = CreateAttachedEmitter(self,'AttachBone01',self:GetArmy(), '/effects/emitters/cybran_shield_05_generator_02_emit.bp')
		self.Effect5 = CreateAttachedEmitter(self,'AttachBone02',self:GetArmy(), '/effects/emitters/cybran_shield_05_generator_02_emit.bp')
		self.Effect6 = CreateAttachedEmitter(self,'AttachBone02',self:GetArmy(), '/effects/emitters/cybran_shield_05_generator_02_emit.bp')
		
		self.Effect7 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect8 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect9 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect10 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect11 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect12 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect13 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect14 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect15 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')

		self.Effect16 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), '/effects/emitters/uef_orbital_death_laser_end_04_emit.bp')
		self.Effect20 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), '/effects/emitters/uef_orbital_death_laser_end_08_emit.bp')

		self.Effect17 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_02_emit.bp')

		self.Effect18 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), '/effects/emitters/uef_orbital_death_laser_muzzle_05_emit.bp')
		self.Effect19 = CreateAttachedEmitter(self,'BuildAttachBone01',self:GetArmy(), '/effects/emitters/uef_orbital_death_laser_muzzle_05_emit.bp')
		
		self.Trash:Add(self.Effecct1)
		self.Trash:Add(self.Effecct2)
		self.Trash:Add(self.Effecct3)
		self.Trash:Add(self.Effecct4)
		self.Trash:Add(self.Effecct5)
		self.Trash:Add(self.Effecct6)
		self.Trash:Add(self.Effecct7)
		self.Trash:Add(self.Effecct8)
		self.Trash:Add(self.Effecct9)
		self.Trash:Add(self.Effecct10)
		self.Trash:Add(self.Effecct11)
		self.Trash:Add(self.Effecct12)
		self.Trash:Add(self.Effecct13)
		self.Trash:Add(self.Effecct14)
		self.Trash:Add(self.Effecct15)
		self.Trash:Add(self.Effecct16)
		self.Trash:Add(self.Effecct17)
		self.Trash:Add(self.Effecct18)
		self.Trash:Add(self.Effecct19)
		self.Trash:Add(self.Effecct20)
		self.UnitBeingBuilt = unitBeingBuilt
        self.UnitBuildOrder = order
        self.BuildingUnit = true
    end,

    OnFailedToBuild = function(self)
		APortalFactoryUnit.OnFailedToBuild(self)
    end,

    OnStopBuild = function(self, unitBeingBuilt, order )
        APortalFactoryUnit.OnStopBuild(self, unitBeingBuilt, order )  # NOTE DE MANIMAL : POURQUOI AIR FACTORY POUR UNE GATE ??? o_O
		if self.Effect1 then
                self.Effect1:Destroy()
				self.Effect2:Destroy()
				self.Effect3:Destroy()
				self.Effect4:Destroy()
				self.Effect5:Destroy()
				self.Effect6:Destroy()
				self.Effect7:Destroy()
				self.Effect8:Destroy()
				self.Effect9:Destroy()
				self.Effect10:Destroy()
				self.Effect11:Destroy()
				self.Effect12:Destroy()
				self.Effect13:Destroy()
				self.Effect14:Destroy()
				self.Effect15:Destroy()
				self.Effect16:Destroy()
				self.Effect17:Destroy()
				self.Effect18:Destroy()
				self.Effect19:Destroy()
				self.Effect20:Destroy()
        end

        if not self.FactoryBuildFailed then
            self:StopBuildFx()
            self:ForkThread(self.FinishBuildThread, unitBeingBuilt, order )
        end
        self.BuildingUnit = false
    end,


    FinishBuildThread = function(self, unitBeingBuilt, order )
        local bp = self:GetBlueprint()
		if( not self.AfterBuildAnimManip ) then
			self.AfterBuildAnimManip = CreateAnimator(self)
			self.AfterBuildAnimManip:PlayAnim(bp.Display.AnimationAfterBuild, false):SetRate(0.3)
			WaitFor(self.AfterBuildAnimManip)
			self.AfterBuildAnimManip:Destroy()
            self.AfterBuildAnimManip = nil
        end
	    if unitBeingBuilt and not unitBeingBuilt:IsDead() then
            unitBeingBuilt:DetachFrom(true)
        end
    end,
	
}

TypeClass = UAB0110
