--[[#######################################################################
#  File     :  /units/QuantumHeroesGate/UEB0110/UEB0110_script.lua
#  Author(s):  John Comes, David Tomandl, Gordon Duclos
#  Summary  :  Special UEF Quantum Gate Script
#  -----------------------------
#  Modif.by :  AsdrubaelVect
#  Rev.Date :  5 septembre 2009
#  -----------------------------
#  Revis.by :  Manimal
#  Rev.Date :  24 fvrier 2010
#  -----------------------------
#  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--


#######################################################################
local Game = import('/lua/game.lua')

#VARIABLE ''GLOBALE'' (par Manimal)
local MyModPath = Game.MyModPath
#######################################################################


local TPortalFactoryUnit = import( MyModPath .. '/hook/lua/terranunits.lua' ).TPortalFactoryUnit


UEB0110 = Class( TPortalFactoryUnit ) {

	BuildAttachBone = 'Attachpoint', --NOTE DE MANIMAL:  QUOI SERT LE BONE ConstuctBeam02 ?
	SwitchAnims = true,

	# NOTE DE MANIMAL: OnStopBeingBuilt <=> FIN DE CONSTRUCTION, UNIT PRETE !

    --OnStopBeingBuilt = function( self, builder, layer )
        # Turn off land bones If this unit has them.
        # Create any idle effects on unit
        # If we have a shield spec'd create it.
        # Initialize movement effects subsystems, idle effects, beam exhaust, and footfall manipulators

		# NOTE de MANIMAL : POURQUOI CRER 1 Build Anim ALORS QU'ON STOP !!!
		# PLACER DANS OnStartBeingBuilt OU BIEN StartBeingBuiltEffects ?!?
	--	local bp = self:GetBlueprint()
	--	if  not self.BuildAnimManip  then
	--		self.BuildAnimManip = CreateAnimator( self )
	--		self.BuildAnimManip:PlayAnim( bp.Display.AnimationBuild )
	--		self.BuildAnimManip:SetRate( 2 )
        --end

    --    TPortalFactoryUnit.OnStopBeingBuilt( self, builder, layer )
    --end,


    OnStartBuild = function( self, unitBeingBuilt, order )

		# PLACER DANS StartBuildingEffects ?!?

		self.Effect1 = CreateAttachedEmitter(self,'Attachpoint02',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_02_emit.bp')
		self.Effect2 = CreateAttachedEmitter(self,'Attachpoint01',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_03_emit.bp')
		self.Effect3 = CreateAttachedEmitter(self,'Attachpoint01',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_04_emit.bp')

		self.Effect16 = CreateAttachedEmitter(self,'Attachpoint02',self:GetArmy(), '/effects/emitters/uef_orbital_death_laser_end_04_emit.bp')
		self.Effect20 = CreateAttachedEmitter(self,'Attachpoint02',self:GetArmy(), '/effects/emitters/uef_orbital_death_laser_end_08_emit.bp')

		self.Effect17 = CreateAttachedEmitter(self,'Attachpoint02',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_02_emit.bp')
		self.Effect4 = CreateAttachedEmitter(self,'Attachpoint03',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect5 = CreateAttachedEmitter(self,'Attachpoint04',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect6 = CreateAttachedEmitter(self,'Attachpoint05',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect7 = CreateAttachedEmitter(self,'Attachpoint06',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect8 = CreateAttachedEmitter(self,'Attachpoint07',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect9 = CreateAttachedEmitter(self,'Attachpoint08',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect10 = CreateAttachedEmitter(self,'Attachpoint09',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect11 = CreateAttachedEmitter(self,'Attachpoint10',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect12 = CreateAttachedEmitter(self,'Attachpoint11',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect13 = CreateAttachedEmitter(self,'Attachpoint12',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect14 = CreateAttachedEmitter(self,'Attachpoint13',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		self.Effect15 = CreateAttachedEmitter(self,'Attachpoint14',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')

		self.Effect18 = CreateAttachedEmitter(self,'Attachpoint15',self:GetArmy(), '/effects/emitters/uef_orbital_death_laser_muzzle_05_emit.bp')
		self.Effect19 = CreateAttachedEmitter(self,'Attachpoint16',self:GetArmy(), '/effects/emitters/uef_orbital_death_laser_muzzle_05_emit.bp')
		
		self.Trash:Add(self.Effect1)  # MODIF DE MANIMAL : CORRECTION !
		self.Trash:Add(self.Effect2)  # TROUV [Effecct] AU LIEU DE [Effect]
		self.Trash:Add(self.Effect3)
		self.Trash:Add(self.Effect4)
		self.Trash:Add(self.Effect5)
		self.Trash:Add(self.Effect6)
		self.Trash:Add(self.Effect7)
		self.Trash:Add(self.Effect8)
		self.Trash:Add(self.Effect9)
		self.Trash:Add(self.Effect10)
		self.Trash:Add(self.Effect11)
		self.Trash:Add(self.Effect12)
		self.Trash:Add(self.Effect13)
		self.Trash:Add(self.Effect14)
		self.Trash:Add(self.Effect15)
		self.Trash:Add(self.Effect16)
		self.Trash:Add(self.Effect17)
		self.Trash:Add(self.Effect18)
		self.Trash:Add(self.Effect19)
		self.Trash:Add(self.Effect20)

        TPortalFactoryUnit.OnStartBuild( self, unitBeingBuilt, order )
    end,


    OnStopBuild = function( self, unitBeingBuilt, order )

        if self.Effect1 then
			self.Effect1:Destroy()
			self.Effect2:Destroy()
			self.Effect3:Destroy()
			self.Effect4:Destroy()
			self.Effect5:Destroy()
			self.Effect6:Destroy()
			self.Effect7:Destroy()
			self.Effect8:Destroy()
			self.Effect9:Destroy()
			self.Effect10:Destroy()
			self.Effect11:Destroy()
			self.Effect12:Destroy()
			self.Effect13:Destroy()
			self.Effect14:Destroy()
			self.Effect15:Destroy()
			self.Effect16:Destroy()
			self.Effect17:Destroy()
			self.Effect18:Destroy()
			self.Effect19:Destroy()
			self.Effect20:Destroy()
        end

        TPortalFactoryUnit.OnStopBuild( self, unitBeingBuilt, order )

		# LE FinishBuildThread PERSO REMPLACE AUTOMATIQUEMENT L'ORIGINAL !!!
		# INVOQUER FinishBuildThread ICI CAR IL Y A UN RETARD DANS Anim SI INVOQU DEPUIS L'ORIGINAL !
        if not self.FactoryBuildFailed then
            if not EntityCategoryContains( categories.AIR, unitBeingBuilt ) then
                self:RollOffUnit()
            end
            self:StopBuildFx()
            self:ForkThread( self.FinishBuildThread, unitBeingBuilt, order )
        end
        self.BuildingUnit = false --# VRAIMENT NECESSAIRE ?
    end,


    FinishBuildThread = function( self, unitBeingBuilt, order )
		local idUnitBB = unitBeingBuilt:GetUnitId()
		local idUnitSelf = self:GetUnitId()
		LOG( 'MANIMAL TRACEUR  UEB0110_Script  : FinishBuildThread -> OK !' )
        local bp = self:GetBlueprint()
        if EntityCategoryContains( categories.LAND, unitBeingBuilt ) then
			LOG( 'MANIMAL TRACEUR   FinishBuildThread -> unitBeingBuilt (Hros) ' .. tostring(idUnitBB) .. ' = categories.LAND' )
			if  not self.OpenAnimManip  then
				LOG( 'MANIMAL TRACEUR   FinishBuildThread -> unitSelf (Portail) ' .. tostring(idUnitSelf) .. ' = NOT OpenAnimManip' )
				self.OpenAnimManip = CreateAnimator(self)
				self.OpenAnimManip:PlayAnim( bp.Display.AnimationOpen, false ):SetRate( 0.5 )
				WaitFor( self.OpenAnimManip )
				self.OpenAnimManip:Destroy()
				self.OpenAnimManip = nil
			end
        end
        if unitBeingBuilt and not unitBeingBuilt:IsDead() then
            unitBeingBuilt:DetachFrom( true )
        end
    end,


}

TypeClass = UEB0110
