#****************************************************************************
#**
#**  File     :  /cdimage/units/UEB2303/UEB2303_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  UEF Light Artillery Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************

local TStructureUnit = import('/lua/terranunits.lua').TStructureUnit
local TIFArtilleryWeapon = import('/lua/terranweapons.lua').TIFArtilleryWeapon

UEB2303 = Class(TStructureUnit) {
	LandBuiltHiddenBones = {'Flotteur'},
	
    OnStopBeingBuilt = function(self,builder,layer)
        TStructureUnit.OnStopBeingBuilt(self,builder,layer)
        local bp = self:GetBlueprint()
		--[[
		if layer == 'Water' then
            self:ShowBone('Flotteur', true)
		else
            self:HideBone('Flotteur', true)
        end
		]]--
        if bp.Audio.Activate then
            self:PlaySound(bp.Audio.Activate)
        end
    end,

    Weapons = {
        MainGun = Class(TIFArtilleryWeapon) {
        },
    },
}

TypeClass = UEB2303


