#****************************************************************************
#**
#**  File     :  /cdimage/units/UEB4301/UEB4301_script.lua
#**  Author(s):  John Comes, Greg Kohne
#**
#**  Summary  :  UEF Heavy Shield Generator Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#****************************************************************************
#**	Note Asdru 16/07/011 :
#**		J'ai utilis une fonction deja presente dans le default units " LandBuiltHiddenBones "
#**	 	Cette derniere permet de faire apparaitre/disparaitre un bones quand la structure est construite sur terre ou sur mer 
#**	 	Voir tourelle anti air et autre pour exemple batiments amphibie
#** 	A noter que la fonction semble buguer quand les batiments sont construits via upgrades
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local TShieldStructureUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TShieldStructureUnit

UEB4301 = Class(TShieldStructureUnit) {
    
    ShieldEffects = {
        '/effects/emitters/terran_shield_generator_t2_01_emit.bp',
        '/effects/emitters/terran_shield_generator_T3_02_emit.bp',
        ###'/effects/emitters/terran_shield_generator_t2_03_emit.bp',
    },
    
    OnStopBeingBuilt = function(self,builder,layer)
        TShieldStructureUnit.OnStopBeingBuilt(self,builder,layer)
        self.Rotator1 = CreateRotator(self, 'Spinner', 'y', nil, 10, 5, 10)
        self.Rotator2 = CreateRotator(self, 'B01', 'z', nil, -10, 5, -10)
        self.Trash:Add(self.Rotator1)
        self.Trash:Add(self.Rotator2)
		self.ShieldEffectsBag = {}
    end,

    OnShieldEnabled = function(self, layer)
        TShieldStructureUnit.OnShieldEnabled(self, layer)
		##--Seul Moyen trouv pour forcer l'apparition du flotteur quand case eau. 
		##-- *Note j'ai tent de bidouiller le default units.lua en ajoutant le " layer " dans les function d'upgrade, ca marchait mais generait une erreur.
		##-- Si plus tard tu veux regarder hesites pas.
		if self:GetCurrentLayer() == 'Water' then
            self:ShowBone('Flotteur', true)
		elseif self:GetCurrentLayer() == 'Land' then
            self:HideBone('Flotteur', true)
        end 
		###////
        if self.Rotator1 then
            self.Rotator1:SetTargetSpeed(10)
        end
        if self.Rotator2 then
            self.Rotator2:SetTargetSpeed(-10)
        end
        
        if self.ShieldEffectsBag then
            for k, v in self.ShieldEffectsBag do
                v:Destroy()
            end
		    self.ShieldEffectsBag = {}
		end
        for k, v in self.ShieldEffects do
            table.insert( self.ShieldEffectsBag, CreateAttachedEmitter( self, 'Shaft', self:GetArmy(), v ) )
        end
    end,

    OnShieldDisabled = function(self, layer)
        TShieldStructureUnit.OnShieldDisabled(self, layer)
		##--Seul Moyen trouv pour forcer l'apparition du flotteur quand case eau. 
		##-- *Note j'ai tent de bidouiller le default units.lua en ajoutant le " layer " dans les function d'upgrade, ca marchait mais generait une erreur.
		##-- Si plus tard tu veux regarder hesites pas.
		if self:GetCurrentLayer() == 'Water' then
            self:ShowBone('Flotteur', true)
		elseif self:GetCurrentLayer() == 'Land' then
            self:HideBone('Flotteur', true)
        end 
		###////
        self.Rotator1:SetTargetSpeed(0)
        self.Rotator2:SetTargetSpeed(0)
        
        if self.ShieldEffectsBag then
            for k, v in self.ShieldEffectsBag do
                v:Destroy()
            end
		    self.ShieldEffectsBag = {}
		end
    end,

}

TypeClass = UEB4301