#****************************************************************************
#**
#**  File     :  /units/XSB4301/XSB4301_script.lua
#**
#**  Summary  :  Seraphim Heavy Shield Generator Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#**	Note Asdru 16/07/011 :
#**		J'ai utilis une fonction deja presente dans le default units " LandBuiltHiddenBones "
#**	 	Cette derniere permet de faire apparaitre/disparaitre un bones quand la structure est construite sur terre ou sur mer 
#**	 	Voir tourelle anti air et autre pour exemple batiments amphibie
#** 	A noter que la fonction semble buguer quand les batiments sont construits via upgrades
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local SShieldStructureUnit = import( MyModPath .. '/hook/lua/seraphimunits.lua').SShieldStructureUnit

XSB4301 = Class(SShieldStructureUnit) {
    
    ShieldEffects = {
        ###'/effects/emitters/seraphim_shield_generator_t3_01_emit.bp',
        '/effects/emitters/seraphim_shield_generator_t3_02_emit.bp',
        '/effects/emitters/seraphim_shield_generator_t3_03_emit.bp', 
        '/effects/emitters/seraphim_shield_generator_t3_04_emit.bp',        
        ###'/effects/emitters/seraphim_shield_generator_t3_05_emit.bp',
    },
    
    OnStopBeingBuilt = function(self,builder,layer)
        SShieldStructureUnit.OnStopBeingBuilt(self,builder,layer)
		self.ShieldEffectsBag = {}
    end,

    OnShieldEnabled = function(self, layer)
        SShieldStructureUnit.OnShieldEnabled(self, layer)
		##--Seul Moyen trouv pour forcer l'apparition du flotteur quand case eau. 
		##-- *Note j'ai tent de bidouiller le default units.lua en ajoutant le " layer " dans les function d'upgrade, ca marchait mais generait une erreur.
		##-- Si plus tard tu veux regarder hesites pas.
		if self:GetCurrentLayer() == 'Water' then
            self:ShowBone('Flotteur', true)
		elseif self:GetCurrentLayer() == 'Land' then
            self:HideBone('Flotteur', true)
        end 
		###////
        if self.ShieldEffectsBag then
            for k, v in self.ShieldEffectsBag do
                v:Destroy()
            end
		    self.ShieldEffectsBag = {}
		end
        for k, v in self.ShieldEffects do
            table.insert( self.ShieldEffectsBag, CreateAttachedEmitter( self, 0, self:GetArmy(), v ) )
        end
    end,

    OnShieldDisabled = function(self, layer)
        SShieldStructureUnit.OnShieldDisabled(self, layer)
		##--Seul Moyen trouv pour forcer l'apparition du flotteur quand case eau. 
		##-- *Note j'ai tent de bidouiller le default units.lua en ajoutant le " layer " dans les function d'upgrade, ca marchait mais generait une erreur.
		##-- Si plus tard tu veux regarder hesites pas.
		if self:GetCurrentLayer() == 'Water' then
            self:ShowBone('Flotteur', true)
		elseif self:GetCurrentLayer() == 'Land' then
            self:HideBone('Flotteur', true)
        end 
		###////
        if self.ShieldEffectsBag then
            for k, v in self.ShieldEffectsBag do
                v:Destroy()
            end
		    self.ShieldEffectsBag = {}
		end
    end,
    
    OnKilled = function(self, instigator, type, overkillRatio)
        SShieldStructureUnit.OnKilled(self, instigator, type, overkillRatio)
		##--Seul Moyen trouv pour forcer l'apparition du flotteur quand case eau. 
		##-- *Note j'ai tent de bidouiller le default units.lua en ajoutant le " layer " dans les function d'upgrade, ca marchait mais generait une erreur.
		##-- Si plus tard tu veux regarder hesites pas.
		if self:GetCurrentLayer() == 'Water' then
            self:ShowBone('Flotteur', true)
		elseif self:GetCurrentLayer() == 'Land' then
            self:HideBone('Flotteur', true)
        end 
		###////
        if self.ShieldEffctsBag then
            for k,v in self.ShieldEffectsBag do
                v:Destroy()
            end
        end
    end,
}

TypeClass = XSB4301