#****************************************************************************
#**
#**  File     :  /cdimage/units/UAL0301/UAL0301_script.lua
#**  Author(s):  Jessica St. Croix
#**
#**  Summary  :  Aeon Sub Commander Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************

local AWalkingLandUnit = import('/lua/aeonunits.lua').AWalkingLandUnit

local AWeapons = import('/lua/aeonweapons.lua')
local ADFReactonCannon = AWeapons.ADFReactonCannon
local AIFCommanderDeathWeapon = AWeapons.AIFCommanderDeathWeapon
local EffectUtil = import('/lua/EffectUtilities.lua')
local Buff = import('/lua/sim/Buff.lua')

UAL0301 = Class(AWalkingLandUnit) {    
    Weapons = {
        LeftReactonCannon = Class(ADFReactonCannon) {},
		
		RightReactonCannon = Class(ADFReactonCannon) {},
		
        DeathWeapon = Class(AIFCommanderDeathWeapon) {
        },
    },
    
    OnPrepareArmToBuild = function(self)
        AWalkingLandUnit.OnPrepareArmToBuild(self)
        self:BuildManipulatorSetEnabled(true)
        self.BuildArmManipulator:SetPrecedence(20)
        self:SetWeaponEnabledByLabel('LeftReactonCannon', false)
        self.BuildArmManipulator:SetHeadingPitch( self:GetWeaponManipulatorByLabel('LeftReactonCannon'):GetHeadingPitch() )
		--self.BuildArmManipulator:SetHeadingPitch( self:GetWeaponManipulatorByLabel('RightReactonCannon'):GetHeadingPitch() )
    end,
        
    OnStopCapture = function(self, target)
        AWalkingLandUnit.OnStopCapture(self, target)
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('LeftReactonCannon', true)
        self:GetWeaponManipulatorByLabel('LeftReactonCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
		--self:GetWeaponManipulatorByLabel('RightReactonCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,
    
    OnFailedCapture = function(self, target)
        AWalkingLandUnit.OnFailedCapture(self, target)
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('LeftReactonCannon', true)
        self:GetWeaponManipulatorByLabel('LeftReactonCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
		--self:GetWeaponManipulatorByLabel('RightReactonCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,
    
    OnStopReclaim = function(self, target)
        AWalkingLandUnit.OnStopReclaim(self, target)
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('LeftReactonCannon', true)
        self:GetWeaponManipulatorByLabel('LeftReactonCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
		--self:GetWeaponManipulatorByLabel('RightReactonCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnFailedToBuild = function(self)
        AWalkingLandUnit.OnFailedToBuild(self)
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('LeftReactonCannon', true)
        self:GetWeaponManipulatorByLabel('LeftReactonCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
		--self:GetWeaponManipulatorByLabel('RightReactonCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,
    
    OnStartBuild = function(self, unitBeingBuilt, order)
        AWalkingLandUnit.OnStartBuild(self, unitBeingBuilt, order)
        self.UnitBeingBuilt = unitBeingBuilt
        self.UnitBuildOrder = order
        self.BuildingUnit = true     
    end,    

    OnStopBuild = function(self, unitBeingBuilt)
        AWalkingLandUnit.OnStopBuild(self, unitBeingBuilt)
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('LeftReactonCannon', true)
        self:GetWeaponManipulatorByLabel('LeftReactonCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
		--self:GetWeaponManipulatorByLabel('RightReactonCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
        self.UnitBeingBuilt = nil
        self.UnitBuildOrder = nil
        self.BuildingUnit = false          
    end,

    
    OnFailedToBuild = function(self)
        AWalkingLandUnit.OnFailedToBuild(self)
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('LeftReactonCannon', true)
        self:GetWeaponManipulatorByLabel('LeftReactonCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
		--self:GetWeaponManipulatorByLabel('RightReactonCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,
    
    OnCreate = function(self)
        AWalkingLandUnit.OnCreate(self)
        self:SetCapturable(false)
		
		###RessourcesI II III
        self:HideBone('BackUpgrade01', true)
		self:HideBone('BackUpgrade02', true)
		self:HideBone('BackUpgrade03', true)
		###/RessourcesI II III
		###ArmeRight
		self:HideBone('Arm_Right_B0401', true)
		self:SetWeaponEnabledByLabel('RightReactonCannon', false)
		###/ArmeRight
	
        self:SetupBuildBones()
    end,
    
    CreateBuildEffects = function( self, unitBeingBuilt, order )
        EffectUtil.CreateAeonCommanderBuildingEffects( self, unitBeingBuilt, self:GetBlueprint().General.BuildBones.BuildEffectBones, self.BuildEffectsBag )
    end,      
	
	NotifyOfPodDeath = function(self, pod)
        if pod == 'RessourcesDroneL' then
            self.HasLeftPod = false
            self:CreateEnhancement('RessourcesDroneLRemove')
            self:RequestRefreshUI()
		elseif pod == 'RessourcesDroneR' then
            self.HasRightPod = false
            self:CreateEnhancement('RessourcesDroneRRemove')
            self:RequestRefreshUI()
        end
    end,
    
    CreateEnhancement = function(self, enh)
        AWalkingLandUnit.CreateEnhancement(self, enh)
        local bp = self:GetBlueprint().Enhancements[enh]
        if not bp then return end
        #Drone
        if enh == 'RessourcesDroneR' then
            local location = self:GetPosition('AttachSpecialRight')
            local pod = CreateUnitHPR('UAA0001', self:GetArmy(), location[1], location[2], location[3], 0, 0, 0)
            pod:SetParent(self, 'RessourcesDroneR')
            pod:SetCreator(self)
            self.Trash:Add(pod)
            self.HasRightPod = true
            self.RessourcesDroneR = pod
        elseif enh == 'RessourcesDroneL' then
            local location = self:GetPosition('AttachSpecialLeft')
            local pod = CreateUnitHPR('UAA0001', self:GetArmy(), location[1], location[2], location[3], 0, 0, 0)
            pod:SetParent(self, 'RessourcesDroneL')
            pod:SetCreator(self)
            self.Trash:Add(pod)
            self.HasLeftPod = true
            self.RessourcesDroneL = pod
		elseif enh == 'RessourcesDroneLRemove' then
            if self.RessourcesDroneL and not self.RessourcesDroneL:IsDead() then
                self.RessourcesDroneL:Kill()
            end
		elseif enh == 'RessourcesDroneRRemove' then
            if self.RessourcesDroneR and not self.RessourcesDroneR:IsDead() then
                self.RessourcesDroneR:Kill()
            end
        #Shields
        elseif enh == 'Shield' then
            self:AddToggleCap('RULEUTC_ShieldToggle')
            self:SetEnergyMaintenanceConsumptionOverride(bp.MaintenanceConsumptionPerSecondEnergy or 0)
            self:SetMaintenanceConsumptionActive()
            self:CreatePersonalShield(bp)
        elseif enh == 'ShieldRemove' then
            self:DestroyShield()
            self:SetMaintenanceConsumptionInactive()
            self:RemoveToggleCap('RULEUTC_ShieldToggle')
        elseif enh == 'ShieldHeavy' then
            self:ForkThread(self.CreateHeavyShield, bp)
        elseif enh == 'ShieldHeavyRemove' then
            self:DestroyShield()
            self:SetMaintenanceConsumptionInactive()
            self:RemoveToggleCap('RULEUTC_ShieldToggle') 
        #ResourceAllocationI         
        elseif enh == 'ResourceAllocation' then
            local bp = self:GetBlueprint().Enhancements[enh]
            local bpEcon = self:GetBlueprint().Economy
            if not bp then return end
            self:SetProductionPerSecondEnergy(bp.ProductionPerSecondEnergy + bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bp.ProductionPerSecondMass + bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'ResourceAllocationRemove' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEcon.ProductionPerSecondMass or 0)	
		#ResourceAllocationII      
        elseif enh == 'ResourceAllocationII' then
            local bp = self:GetBlueprint().Enhancements[enh]
            local bpEcon = self:GetBlueprint().Economy
            if not bp then return end
            self:SetProductionPerSecondEnergy(bp.ProductionPerSecondEnergy + bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bp.ProductionPerSecondMass + bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'ResourceAllocationIIRemove' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEcon.ProductionPerSecondMass or 0)	
		#ResourceAllocationIII     
        elseif enh == 'ResourceAllocationIII' then
            local bp = self:GetBlueprint().Enhancements[enh]
            local bpEcon = self:GetBlueprint().Economy
            if not bp then return end
            self:SetProductionPerSecondEnergy(bp.ProductionPerSecondEnergy + bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bp.ProductionPerSecondMass + bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'ResourceAllocationIIIRemove' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEcon.ProductionPerSecondMass or 0)
		#SensorRangeEnhancer
        elseif enh == 'SensorRangeEnhancer' then
            self:SetIntelRadius('Vision', bp.NewVisionRadius or 104)
            self:SetIntelRadius('Omni', bp.NewOmniRadius or 104)
        elseif enh == 'SensorRangeEnhancerRemove' then
            local bpIntel = self:GetBlueprint().Intel
            self:SetIntelRadius('Vision', bpIntel.VisionRadius or 26)
            self:SetIntelRadius('Omni', bpIntel.OmniRadius or 26)
	###################################FIN BACK			
		elseif enh == 'RightReactonCannon' then
		self:SetWeaponEnabledByLabel('RightReactonCannon', true)
        elseif enh == 'RightReactonCannonRemove' then
		self:SetWeaponEnabledByLabel('RightReactonCannon', false)
	########################BUILD RATE
		elseif enh =='RightBuildRateI' then
            if not Buffs['AEONBuildRateI'] then
                BuffBlueprint {
                    Name = 'AEONBuildRateI',
                    DisplayName = 'AEONBuildRateI',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bp.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'AEONBuildRateI')
        elseif enh =='RightBuildRateIRemove' then
            local bp = self:GetBlueprint().Economy.BuildRate
            if not bp then return end
            if Buff.HasBuff( self, 'AEONBuildRateI' ) then
                Buff.RemoveBuff( self, 'AEONBuildRateI' )
            end	
			
		elseif enh =='RightBuildRateII' then
            if not Buffs['AEONBuildRateII'] then
                BuffBlueprint {
                    Name = 'AEONBuildRateII',
                    DisplayName = 'AEONBuildRateII',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bp.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'AEONBuildRateII')
        elseif enh =='RightBuildRateIIRemove' then
            local bp = self:GetBlueprint().Economy.BuildRate
            if not bp then return end
            if Buff.HasBuff( self, 'AEONBuildRateII' ) then
                Buff.RemoveBuff( self, 'AEONBuildRateII' )
            end		
		
		
		elseif enh =='RightBuildRateIII' then
            if not Buffs['AEONBuildRateIII'] then
                BuffBlueprint {
                    Name = 'AEONBuildRateIII',
                    DisplayName = 'AEONBuildRateIII',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bp.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'AEONBuildRateIII')
        elseif enh =='RightBuildRateIIIRemove' then
            local bp = self:GetBlueprint().Economy.BuildRate
            if not bp then return end
            if Buff.HasBuff( self, 'AEONBuildRateIII' ) then
                Buff.RemoveBuff( self, 'AEONBuildRateIII' )
            end		
		end			
    end,
    
    CreateHeavyShield = function(self, bp)
        WaitTicks(1)
        self:CreatePersonalShield(bp)
        self:SetEnergyMaintenanceConsumptionOverride(bp.MaintenanceConsumptionPerSecondEnergy or 0)     
        self:SetMaintenanceConsumptionActive()
    end,    
    
    OnPaused = function(self)
        AWalkingLandUnit.OnPaused(self)
        if self.BuildingUnit then
            AWalkingLandUnit.StopBuildingEffects(self, self:GetUnitBeingBuilt())
        end    
    end,
    
    OnUnpaused = function(self)
        if self.BuildingUnit then
            AWalkingLandUnit.StartBuildingEffects(self, self:GetUnitBeingBuilt(), self.UnitBuildOrder)
        end
        AWalkingLandUnit.OnUnpaused(self)
    end,         
}

TypeClass = UAL0301
