#****************************************************************************
#**
#**  File     :  /cdimage/units/UEL0301/UEL0301_script.lua
#**  Author(s):  Jessica St. Croix, Gordon Duclos
#**
#**  Summary  :  UEF Sub Commander Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local TWalkingLandUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TWalkingLandUnit
local Shield = import('/lua/shield.lua').Shield
local EffectUtil = import('/lua/EffectUtilities.lua')

local Buff = import('/lua/sim/Buff.lua')



local TWeapons = import('/lua/terranweapons.lua')
local TDFHeavyPlasmaCannonWeapon = TWeapons.TDFHeavyPlasmaCannonWeapon

local TIFCruiseMissileUnpackingLauncher = TWeapons.TIFCruiseMissileUnpackingLauncher

local TIFCommanderDeathWeapon = TWeapons.TIFCommanderDeathWeapon

UEL0301 = Class(TWalkingLandUnit) {
    
    IntelEffects = {
		{
			Bones = {
				'BackUpgrade01',
			},
			Scale = 0.3,
			Type = 'Jammer01',
		},
    },    

    Weapons = {
        HeavyPlasma01 = Class(TDFHeavyPlasmaCannonWeapon) {
        },

		MissileWeaponIEM01 = Class(TIFCruiseMissileUnpackingLauncher){},
		MissileWeaponIEM02 = Class(TIFCruiseMissileUnpackingLauncher){},
		
		MissileWeaponIEM03 = Class(TIFCruiseMissileUnpackingLauncher){},
		MissileWeaponIEM04 = Class(TIFCruiseMissileUnpackingLauncher){},
		
        DeathWeapon = Class(TIFCommanderDeathWeapon) {
        },
    },

    OnCreate = function(self)
        TWalkingLandUnit.OnCreate(self)
        self:SetCapturable(false)
		###PODS
        self:HideBone('UpgradePodRight01', true)
        self:HideBone('UpgradePodLeft01', true)
		###/PODS
		###IEM
		self:HideBone('IEMRight', true)
		self:HideBone('IEMLeft', true)  
		###/IEM
		###BuildRateI
        self:HideBone('BuildRateLeft01', true)
        self:HideBone('BuildRateRight01', true)
		###/BuildRateI
		###RessourcesI II III
        self:HideBone('BackUpgrade01', true)
		self:HideBone('BackUpgrade02', true)
		self:HideBone('BackUpgrade03', true)
		###/RessourcesI II III
		###Radar
		self:HideBone('BackUpgrade04', true)
		###/Radar
		###Jamm
		self:HideBone('BackUpgrade05', true)
		###/Jamm
        self:SetupBuildBones()
        
    end,
    
    OnStopBeingBuilt = function(self, builder, layer)
        TWalkingLandUnit.OnStopBeingBuilt(self, builder, layer)
		self:SetWeaponEnabledByLabel('HeavyPlasma01', true)
		
		self:SetWeaponEnabledByLabel('MissileWeaponIEM01', false)
		self:SetWeaponEnabledByLabel('MissileWeaponIEM02', false)
		
		self:SetWeaponEnabledByLabel('MissileWeaponIEM03', false)
		self:SetWeaponEnabledByLabel('MissileWeaponIEM04', false)
		
        self:DisableUnitIntel('Jammer')
    end,

    OnPrepareArmToBuild = function(self)
        TWalkingLandUnit.OnPrepareArmToBuild(self)
       -- self:BuildManipulatorSetEnabled(true)
        --self.BuildArmManipulator:SetPrecedence(20)
        self:SetWeaponEnabledByLabel('RightHeavyPlasmaCannon', false)
        --self.BuildArmManipulator:SetHeadingPitch( self:GetWeaponManipulatorByLabel('RightHeavyPlasmaCannon'):GetHeadingPitch() )
    end,
    
    OnStopCapture = function(self, target)
        TWalkingLandUnit.OnStopCapture(self, target)
        --self:BuildManipulatorSetEnabled(false)
       -- self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightHeavyPlasmaCannon', true)
      --  self:GetWeaponManipulatorByLabel('RightHeavyPlasmaCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnFailedCapture = function(self, target)
        TWalkingLandUnit.OnFailedCapture(self, target)
       -- self:BuildManipulatorSetEnabled(false)
       -- self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightHeavyPlasmaCannon', true)
     --   self:GetWeaponManipulatorByLabel('RightHeavyPlasmaCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,
    
    OnStopReclaim = function(self, target)
        TWalkingLandUnit.OnStopReclaim(self, target)
    --    self:BuildManipulatorSetEnabled(false)
     --   self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightHeavyPlasmaCannon', true)
      --  self:GetWeaponManipulatorByLabel('RightHeavyPlasmaCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,
    
    OnStartBuild = function(self, unitBeingBuilt, order)    
        TWalkingLandUnit.OnStartBuild(self, unitBeingBuilt, order)
        self.UnitBeingBuilt = unitBeingBuilt
        self.UnitBuildOrder = order
        self.BuildingUnit = true        
    end,    

    OnStopBuild = function(self, unitBeingBuilt)
        TWalkingLandUnit.OnStopBuild(self, unitBeingBuilt)
       -- self.UnitBeingBuilt = nil
       -- self.UnitBuildOrder = nil
       -- self.BuildingUnit = false      
        self:SetWeaponEnabledByLabel('RightHeavyPlasmaCannon', true)    
        --self:GetWeaponManipulatorByLabel('RightHeavyPlasmaCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,     
    
    OnFailedToBuild = function(self)
        TWalkingLandUnit.OnFailedToBuild(self)
     --   self:BuildManipulatorSetEnabled(false)
      --  self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightHeavyPlasmaCannon', true)
       -- self:GetWeaponManipulatorByLabel('RightHeavyPlasmaCannon'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,
    
    CreateBuildEffects = function( self, unitBeingBuilt, order )
        local UpgradesFrom = unitBeingBuilt:GetBlueprint().General.UpgradesFrom
        # If we are assisting an upgrading unit, or repairing a unit, play seperate effects
        if (order == 'Repair' and not unitBeingBuilt:IsBeingBuilt()) or (UpgradesFrom and UpgradesFrom != 'none' and self:IsUnitState('Guarding'))then
            EffectUtil.CreateDefaultBuildBeams( self, unitBeingBuilt, self:GetBlueprint().General.BuildBones.BuildEffectBones, self.BuildEffectsBag )
        else
            EffectUtil.CreateUEFCommanderBuildSliceBeams( self, unitBeingBuilt, self:GetBlueprint().General.BuildBones.BuildEffectBones, self.BuildEffectsBag )   
        end           
    end,     

    NotifyOfPodDeath = function(self, pod)
        if pod == 'LeftPod' then
            self.HasLeftPod = false
            self:CreateEnhancement('LeftPodRemove')
            self:RequestRefreshUI()
		elseif pod == 'RightPod' then
            self.HasRightPod = false
            self:CreateEnhancement('RightPodRemove')
            self:RequestRefreshUI()
        end
    end,

    CreateEnhancement = function(self, enh)
        TWalkingLandUnit.CreateEnhancement(self, enh)
        local bp = self:GetBlueprint().Enhancements[enh]
        if not bp then return end
        #Drone
        if enh == 'RightPod' then
            local location = self:GetPosition('AttachSpecialRight')
            local pod = CreateUnitHPR('UEA0001', self:GetArmy(), location[1], location[2], location[3], 0, 0, 0)
            pod:SetParent(self, 'RightPod')
            pod:SetCreator(self)
            self.Trash:Add(pod)
            self.HasRightPod = true
            self.RightPod = pod
        elseif enh == 'LeftPod' then
            local location = self:GetPosition('AttachSpecialLeft')
            local pod = CreateUnitHPR('UEA0001', self:GetArmy(), location[1], location[2], location[3], 0, 0, 0)
            pod:SetParent(self, 'LeftPod')
            pod:SetCreator(self)
            self.Trash:Add(pod)
            self.HasLeftPod = true
            self.LeftPod = pod
		elseif enh == 'LeftPodRemove' then
            if self.LeftPod and not self.LeftPod:IsDead() then
                self.LeftPod:Kill()
            end
		elseif enh == 'RightPodRemove' then
            if self.RightPod and not self.RightPod:IsDead() then
                self.RightPod:Kill()
            end
			
			
		elseif enh == 'RightIEMI' then
			self:SetWeaponEnabledByLabel('MissileWeaponIEM01', true)
        elseif enh == 'RightIEMIRemove' then
            self:SetWeaponEnabledByLabel('MissileWeaponIEM01', false)
		
		elseif enh == 'LeftIEMI' then
			self:SetWeaponEnabledByLabel('MissileWeaponIEM02', true)
        elseif enh == 'LeftIEMIRemove' then
            self:SetWeaponEnabledByLabel('MissileWeaponIEM02', false)
		

		elseif enh == 'RightIEMII' then
			self:SetWeaponEnabledByLabel('MissileWeaponIEM03', true)
			self:SetWeaponEnabledByLabel('MissileWeaponIEM01', false)
        elseif enh == 'RightIEMIIRemove' then
            self:SetWeaponEnabledByLabel('MissileWeaponIEM03', false)
		
		elseif enh == 'LeftIEMII' then
			self:SetWeaponEnabledByLabel('MissileWeaponIEM04', true)
			self:SetWeaponEnabledByLabel('MissileWeaponIEM02', false)
        elseif enh == 'LeftIEMIIRemove' then
            self:SetWeaponEnabledByLabel('MissileWeaponIEM04', false)
			
			
		elseif enh =='RightBuildRateI' then
            if not Buffs['UEFBuildRateI'] then
                BuffBlueprint {
                    Name = 'UEFBuildRateI',
                    DisplayName = 'UEFBuildRateI',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bp.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'UEFBuildRateI')
        elseif enh =='RightBuildRateIRemove' then
            local bp = self:GetBlueprint().Economy.BuildRate
            if not bp then return end
            if Buff.HasBuff( self, 'UEFBuildRateI' ) then
                Buff.RemoveBuff( self, 'UEFBuildRateI' )
            end	
			
		elseif enh =='RightBuildRateII' then
            if not Buffs['UEFBuildRateII'] then
                BuffBlueprint {
                    Name = 'UEFBuildRateII',
                    DisplayName = 'UEFBuildRateII',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bp.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'UEFBuildRateII')
        elseif enh =='RightBuildRateIIRemove' then
            local bp = self:GetBlueprint().Economy.BuildRate
            if not bp then return end
            if Buff.HasBuff( self, 'UEFBuildRateII' ) then
                Buff.RemoveBuff( self, 'UEFBuildRateII' )
            end		
		
		
		elseif enh =='RightBuildRateIII' then
            if not Buffs['UEFBuildRateIII'] then
                BuffBlueprint {
                    Name = 'UEFBuildRateIII',
                    DisplayName = 'UEFBuildRateIII',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bp.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'UEFBuildRateIII')
        elseif enh =='RightBuildRateIIIRemove' then
            local bp = self:GetBlueprint().Economy.BuildRate
            if not bp then return end
            if Buff.HasBuff( self, 'UEFBuildRateIII' ) then
                Buff.RemoveBuff( self, 'UEFBuildRateIII' )
            end		
			
			
		#ResourceAllocationI         
        elseif enh == 'ResourceAllocation' then
            local bp = self:GetBlueprint().Enhancements[enh]
            local bpEcon = self:GetBlueprint().Economy
            if not bp then return end
            self:SetProductionPerSecondEnergy(bp.ProductionPerSecondEnergy + bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bp.ProductionPerSecondMass + bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'ResourceAllocationRemove' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEcon.ProductionPerSecondMass or 0)	
		#ResourceAllocationII      
        elseif enh == 'ResourceAllocationII' then
            local bp = self:GetBlueprint().Enhancements[enh]
            local bpEcon = self:GetBlueprint().Economy
            if not bp then return end
            self:SetProductionPerSecondEnergy(bp.ProductionPerSecondEnergy + bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bp.ProductionPerSecondMass + bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'ResourceAllocationIIRemove' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEcon.ProductionPerSecondMass or 0)	
		#ResourceAllocationIII     
        elseif enh == 'ResourceAllocationIII' then
            local bp = self:GetBlueprint().Enhancements[enh]
            local bpEcon = self:GetBlueprint().Economy
            if not bp then return end
            self:SetProductionPerSecondEnergy(bp.ProductionPerSecondEnergy + bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bp.ProductionPerSecondMass + bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'ResourceAllocationIIIRemove' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEcon.ProductionPerSecondMass or 0)	
			

		#SensorRangeEnhancer
        elseif enh == 'SensorRangeEnhancer' then
            self:SetIntelRadius('Vision', bp.NewVisionRadius or 104)
            self:SetIntelRadius('Omni', bp.NewOmniRadius or 104)
        elseif enh == 'SensorRangeEnhancerRemove' then
            local bpIntel = self:GetBlueprint().Intel
            self:SetIntelRadius('Vision', bpIntel.VisionRadius or 26)
            self:SetIntelRadius('Omni', bpIntel.OmniRadius or 26)
        #RadarJammer
        elseif enh == 'RadarJammer' then
            self:SetIntelRadius('Jammer', bp.NewJammerRadius or 26)
            self.RadarJammerEnh = true 
			self:EnableUnitIntel('Jammer')
            self:AddToggleCap('RULEUTC_JammingToggle')              
        elseif enh == 'RadarJammerRemove' then
            local bpIntel = self:GetBlueprint().Intel
            self:SetIntelRadius('Jammer', 0)
            self:DisableUnitIntel('Jammer')
            self.RadarJammerEnh = false
            self:RemoveToggleCap('RULEUTC_JammingToggle')
		
		#Shield
		elseif enh == 'ShieldGeneratorField' then
            ForkThread(function()
                WaitTicks(1)   
                self:CreateShield(bp)
                self:SetEnergyMaintenanceConsumptionOverride(bp.MaintenanceConsumptionPerSecondEnergy or 0)
                self:SetMaintenanceConsumptionActive()
            end)
        elseif enh == 'ShieldGeneratorFieldRemove' then
            self:DestroyShield()
            self:SetMaintenanceConsumptionInactive()
            self:RemoveToggleCap('RULEUTC_ShieldToggle')
			
        end
    end,

    OnIntelEnabled = function(self)
        TWalkingLandUnit.OnIntelEnabled(self)
        if self.RadarJammerEnh and self:IsIntelEnabled('Jammer') then 
            if self.IntelEffects then
		        self.IntelEffectsBag = {}
		        self.CreateTerrainTypeEffects( self, self.IntelEffects, 'FXIdle',  self:GetCurrentLayer(), nil, self.IntelEffectsBag )
	        end
	        self:SetEnergyMaintenanceConsumptionOverride(self:GetBlueprint().Enhancements['RadarJammer'].MaintenanceConsumptionPerSecondEnergy or 0)        
            self:SetMaintenanceConsumptionActive()
        end    
    end,

    OnIntelDisabled = function(self)
        TWalkingLandUnit.OnIntelDisabled(self)
        if self.RadarJammerEnh and not self:IsIntelEnabled('Jammer') then
            self:SetMaintenanceConsumptionInactive()
            if self.IntelEffectsBag then
                EffectUtil.CleanupEffectBag(self,'IntelEffectsBag')
            end
        end       
    end,     
    
    OnPaused = function(self)
        TWalkingLandUnit.OnPaused(self)
        if self.BuildingUnit then
            TWalkingLandUnit.StopBuildingEffects(self, self:GetUnitBeingBuilt())
        end    
    end,
    
    OnUnpaused = function(self)
        if self.BuildingUnit then
            TWalkingLandUnit.StartBuildingEffects(self, self:GetUnitBeingBuilt(), self.UnitBuildOrder)
        end
        TWalkingLandUnit.OnUnpaused(self)
    end,     

}

TypeClass = UEL0301