#****************************************************************************
#**
#**  File     :  /cdimage/units/UAA0102/UAA0102_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  Aeon Interceptor Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local AAirUnit = import( MyModPath .. '/hook/lua/aeonunits.lua').AAirUnit
local aWeapons = import('/lua/aeonweapons.lua')
local AAASonicPulseBatteryWeapon = aWeapons.AAASonicPulseBatteryWeapon
local AAASonicPulseBatteryWeapon02 = aWeapons.AAASonicPulseBatteryWeapon
local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UAA0102 = Class(AAirUnit) {

    Weapons = {
        SonicPulseBattery1 = Class(AAASonicPulseBatteryWeapon) {
			FxMuzzleFlash = {'/effects/emitters/sonic_pulse_muzzle_flash_02_emit.bp',},
        },
        SonicPulseBattery2 = Class(AAASonicPulseBatteryWeapon) {
			FxMuzzleFlash = {'/effects/emitters/sonic_pulse_muzzle_flash_02_emit.bp',},
        },
		SonicPulseBattery3 = Class(AAASonicPulseBatteryWeapon) {
			FxMuzzleFlash = {'/effects/emitters/sonic_pulse_muzzle_flash_02_emit.bp',},
        },
		SonicPulseBattery4 = Class(AAASonicPulseBatteryWeapon) {
			FxMuzzleFlash = {'/effects/emitters/sonic_pulse_muzzle_flash_02_emit.bp',},
        },
		SonicPulseBattery6 = Class(AAASonicPulseBatteryWeapon02) {
			FxMuzzleFlash = {'/effects/emitters/sonic_pulse_muzzle_flash_01_emit.bp',},
        },
    }, 

    OnCreate = function(self)
		AAirUnit.OnCreate(self)
			self:HideBone('Upgrade01_01', true)  
			self:HideBone('Upgrade02_01', true)
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,	
	
    OnStopBeingBuilt = function(self, builder, layer)
        AAirUnit.OnStopBeingBuilt(self,builder,layer)
	        self:SetWeaponEnabledByLabel('SonicPulseBattery1', true)
	        self:SetWeaponEnabledByLabel('SonicPulseBattery2', true)  
			self:SetWeaponEnabledByLabel('SonicPulseBattery3', false)
	        self:SetWeaponEnabledByLabel('SonicPulseBattery4', false)
			self:SetWeaponEnabledByLabel('SonicPulseBattery6', false)  			
       self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,
	
	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				self:ShowBone('Upgrade01_01', true)
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				local wep = self:GetWeaponByLabel('SonicPulseBattery1')
				local wep2 = self:GetWeaponByLabel('SonicPulseBattery2')
				wep:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod) 
				wep2:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)	
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 50,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)
				self:SetSpeedMult(bp.Physics.Upgrade02SpeedMultiplier)
				local wep01 = self:GetWeaponByLabel('SonicPulseBattery1')
				local wep02 = self:GetWeaponByLabel('SonicPulseBattery2')
				local wep03 = self:GetWeaponByLabel('SonicPulseBattery3')
				local wep04 = self:GetWeaponByLabel('SonicPulseBattery4')
				local wep05 = self:GetWeaponByLabel('SonicPulseBattery6')
				##wep02:ChangeMaxRadius(97)
				wep01:ChangeMaxRadius(bp.NewMaxRadius or 29)
				wep02:ChangeMaxRadius(bp.NewMaxRadius or 29)
				wep03:ChangeMaxRadius(bp.NewMaxRadius or 29)
				wep04:ChangeMaxRadius(bp.NewMaxRadius or 29)
				wep05:ChangeMaxRadius(bp.NewMaxRadius or 29)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 100,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
			self:ShowBone('Upgrade03_01', true)
				self:SetWeaponEnabledByLabel('SonicPulseBattery3', true)
				self:SetWeaponEnabledByLabel('SonicPulseBattery4', true)  
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
			self:ShowBone('Upgrade04_01', true)
			self:SetWeaponEnabledByLabel('SonicPulseBattery6', true)  
			local wep05 = self:GetWeaponByLabel('SonicPulseBattery6')			
			wep05:ChangeMaxRadius(35)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
			self:ShowBone('Upgrade05_01', true)
				local wep1 = self:GetWeaponByLabel('SonicPulseBattery1')
				local wep2 = self:GetWeaponByLabel('SonicPulseBattery2')
				local wep3 = self:GetWeaponByLabel('SonicPulseBattery3')
				local wep4 = self:GetWeaponByLabel('SonicPulseBattery4')
				wep1:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod) 
				wep2:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod) 
				wep3:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod) 
				wep4:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod) 
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 50,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 200,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
end,		
	
}

TypeClass = UAA0102