#****************************************************************************
#**
#**  File     :  /cdimage/units/UAS0103/UAS0103_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  Aeon Frigate Script: UAS0103
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local ASeaUnit = import( MyModPath .. '/hook/lua/aeonunits.lua').ASeaUnit
local AeonWeapons = import('/lua/aeonweapons.lua')
local ADFCannonQuantumWeapon = AeonWeapons.ADFCannonQuantumWeapon
local AIFQuasarAntiTorpedoWeapon = AeonWeapons.AIFQuasarAntiTorpedoWeapon
##UPGRADE 03 torp
local AANChronoTorpedoWeapon = import('/lua/aeonweapons.lua').AANChronoTorpedoWeapon
###UPGRADE 04 Arty
local AIFArtilleryMiasmaShellWeapon = import('/lua/aeonweapons.lua').AIFArtilleryMiasmaShellWeapon

local EffectTemplate = import('/lua/EffectTemplates.lua')
local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UAS0103 = Class(ASeaUnit) {

    Weapons = {
        MainGun = Class(ADFCannonQuantumWeapon) {
            FxMuzzleFlash = EffectTemplate.AQuantumCannonMuzzle02
        },
        MainGun2 = Class(ADFCannonQuantumWeapon) {
            FxMuzzleFlash = EffectTemplate.AQuantumCannonMuzzle02
        },
        AntiTorpedo01 = Class(AIFQuasarAntiTorpedoWeapon) {},
        AntiTorpedo02 = Class(AIFQuasarAntiTorpedoWeapon) {},
		####UPGRADE01
		UpgradeGun01 = Class(ADFCannonQuantumWeapon) {
            FxMuzzleFlash = EffectTemplate.AQuantumCannonMuzzle02
        },
		UpgradeGun02 = Class(ADFCannonQuantumWeapon) {
            FxMuzzleFlash = EffectTemplate.AQuantumCannonMuzzle02
        },
		####UPGRADE02
		UpgradeGun03 = Class(ADFCannonQuantumWeapon) {
            FxMuzzleFlash = EffectTemplate.AQuantumCannonMuzzle02
        },
		UpgradeGun04 = Class(ADFCannonQuantumWeapon) {
            FxMuzzleFlash = EffectTemplate.AQuantumCannonMuzzle02
        },
		###UPGRADE 03
		Torpedo01 = Class(AANChronoTorpedoWeapon) {},
		###UPGRADE 04
		ArtyUpgrade = Class(AIFArtilleryMiasmaShellWeapon) {},
    },
	
    OnCreate = function(self)
		ASeaUnit.OnCreate(self)
			self:HideBone('Upgrade01_01', true)
			self:HideBone('Upgrade02_01', true)
			self:HideBone('Upgrade03_01', true)  
			self:HideBone('Upgrade04_01', true)  
			self:HideBone('Upgrade04_02', true) 
			self:HideBone('Upgrade04_03', true)  			
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,	
	
    OnStopBeingBuilt = function(self,builder,layer)
		ASeaUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('MainGun', true)
		self:SetWeaponEnabledByLabel('MainGun2', true)
		self:SetWeaponEnabledByLabel('AntiTorpedo01', true)
		self:SetWeaponEnabledByLabel('AntiTorpedo02', true)
		###UPGRADE01
		self:SetWeaponEnabledByLabel('UpgradeGun01', false)
		self:SetWeaponEnabledByLabel('UpgradeGun02', false)
		###UPGRADE02
		self:SetWeaponEnabledByLabel('UpgradeGun03', false)
		self:SetWeaponEnabledByLabel('UpgradeGun04', false)
		###UPGRADE03
		self:SetWeaponEnabledByLabel('Torpedo01', false)
		###UPGRADE04
		self:SetWeaponEnabledByLabel('ArtyUpgrade', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,	

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
			self:ShowBone('Upgrade01_01', true)
			
			self:SetWeaponEnabledByLabel('UpgradeGun01', true)
			self:SetWeaponEnabledByLabel('UpgradeGun02', true)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 223,
                            Mult = 1,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		##################################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)				
			
				self:SetWeaponEnabledByLabel('UpgradeGun03', true)
				self:SetWeaponEnabledByLabel('UpgradeGun04', true)
			
				local wep1 = self:GetWeaponByLabel('MainGun')
				local wep2 = self:GetWeaponByLabel('UpgradeGun01')
				local wep3 = self:GetWeaponByLabel('UpgradeGun02')

				wep1:AddDamageMod(bpEnh.CanonIDamageMod) 
				wep2:AddDamageMod(bpEnh.CanonIDamageMod) 
				wep3:AddDamageMod(bpEnh.CanonIDamageMod) 

				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
				BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 250,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				self:ShowBone('Upgrade03_01', true)
				
				self:SetWeaponEnabledByLabel('Torpedo01', true)
				
				local wep1 = self:GetWeaponByLabel('MainGun')
				local wep2 = self:GetWeaponByLabel('UpgradeGun01')
				local wep3 = self:GetWeaponByLabel('UpgradeGun02')
				local wep4 = self:GetWeaponByLabel('UpgradeGun03')
				local wep5 = self:GetWeaponByLabel('UpgradeGun04')
				local wep6 = self:GetWeaponByLabel('Torpedo01')
				wep1:ChangeMaxRadius(35)
				wep2:ChangeMaxRadius(35)
				wep3:ChangeMaxRadius(35)
				wep4:ChangeMaxRadius(35)
				wep5:ChangeMaxRadius(35)
				wep6:ChangeMaxRadius(38)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
				BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 350,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				self:ShowBone('Upgrade04_03', true)
				self:HideBone('Origine04_01', true)
				
				self:SetWeaponEnabledByLabel('ArtyUpgrade', true)
				
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
				BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 450,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				ForkThread(function()
				self:AddToggleCap('RULEUTC_ShieldToggle')
				self:SetEnergyMaintenanceConsumptionOverride(bpEnh.MaintenanceConsumptionPerSecondEnergy or 0)
				self:SetMaintenanceConsumptionActive()
				self:CreatePersonalShield(bpEnh)
				end)	
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
            end
		end
	end,				
	
}

TypeClass = UAS0103
