#****************************************************************************
#**
#**  File     :  /units/uas0204/uas0204_script.lua
#**  Author(s):  John Comes, Jessica St. Croix
#**
#**  Summary  :  Aeon Light Attack Sub Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************


#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local ASubUnit = import( MyModPath .. '/hook/lua/aeonunits.lua' ).ASubUnit

local AANChronoTorpedoWeapon = import('/lua/aeonweapons.lua').AANChronoTorpedoWeapon
#####UPGRADE 03
local AIFQuasarAntiTorpedoWeapon = import('/lua/aeonweapons.lua').AIFQuasarAntiTorpedoWeapon
####UPGRADE 05
local AAAZealotMissileWeapon = import('/lua/aeonweapons.lua').AAAZealotMissileWeapon

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UAS0204 = Class( ASubUnit ) {
    DeathThreadDestructionWaitTime = 0,
    Weapons = {
        Torpedo01 = Class(AANChronoTorpedoWeapon) {},
		###UPGRADE 01 torp
		Torpedo02 = Class(AANChronoTorpedoWeapon) {},
		###UPGRADE 03 Anti Torp
		AntiTorpedo01 = Class(AIFQuasarAntiTorpedoWeapon) {},
		####UPGRADE 05
		AntiAirMissiles = Class(AAAZealotMissileWeapon) {},
    },
	
    OnCreate = function(self)
		ASubUnit.OnCreate(self)
			self:HideBone('Upgrade01_01', true)
			self:HideBone('Upgrade02_01', true)
			self:HideBone('Upgrade03_01', true)  
			self:HideBone('Upgrade04_01', true)  
 			self:HideBone('Upgrade05_01', true)  
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,	
	
    OnStopBeingBuilt = function(self,builder,layer)
		ASubUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('Torpedo01', true)
		self:SetWeaponEnabledByLabel('Torpedo02', false)
		self:SetWeaponEnabledByLabel('AntiTorpedo01', false)
		self:SetWeaponEnabledByLabel('AntiAirMissiles', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,	

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
			self:ShowBone('Upgrade01_01', true)
			
				self:SetWeaponEnabledByLabel('Torpedo02', true)
				
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
				BuffBlueprint {
						Name = 'UEFHEALTHBUFF',
						DisplayName = 'UEFHEALTHBUFF',
						BuffType = 'MAXHEALTH',
						Stacks = 'REPLACE',
						Duration = -1,
						Affects = {
							Health = {
								Add = 100,
								Mult = 1.0,
							},						
						},
					}
				end
				Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
			end	
		##################################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)				
				local wep1 = self:GetWeaponByLabel('Torpedo01')
				wep1:ChangeMaxRadius(32)
				wep1:AddDamageMod(bpEnh.TorpIDamageMod) 
				
				local wep2 = self:GetWeaponByLabel('Torpedo02')
				wep2:ChangeMaxRadius(32)
				wep2:AddDamageMod(bpEnh.TorpIDamageMod) 

				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
				BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        #MaxHealth = {
                        #    Add = 40,
                        #    Mult = 1,
                        #},
						Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				self:ShowBone('Upgrade03_01', true)
				
				self:SetWeaponEnabledByLabel('AntiTorpedo01', false)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
				BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 200,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				self:SetWeaponEnabledByLabel('AntiTorpedo01', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
				BuffBlueprint {
						Name = 'UEFHEALTHBUFF',
						DisplayName = 'UEFHEALTHBUFF',
						BuffType = 'MAXHEALTH',
						Stacks = 'REPLACE',
						Duration = -1,
						Affects = {
							MaxHealth = {
								Add = 120,
								Mult = 1,
							},
							Health = {
								Add = 250,
								Mult = 1.0,
							},						
						},
					}
				end
				Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
			end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				self:ShowBone('Upgrade05_01', true)
				self:SetWeaponEnabledByLabel('AntiAirMissiles', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
            end
		end
	end,				
	
}

TypeClass = UAS0204
