#****************************************************************************
#**
#**  File     :  /units/URS0204/URS0204_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  Cybran Attack Sub Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local CSubUnit = import( MyModPath .. '/hook/lua/cybranunits.lua').CSubUnit

local CANNaniteTorpedoWeapon = import('/lua/cybranweapons.lua').CANNaniteTorpedoWeapon
local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

URS0204 = Class(CSubUnit) {
    DeathThreadDestructionWaitTime = 0,
    
    Weapons = {
        Torpedo01 = Class(CANNaniteTorpedoWeapon) {},
		####UPGRADE 03 Torp EMP
		TorpedoEMP01 = Class(CANNaniteTorpedoWeapon) {},
    },
    OnCreate = function(self)
		CSubUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true)  
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)		
			##UPGRADE03
			self:HideBone('Upgrade03_01', true)
			##UPGRADE04
			self:HideBone('Upgrade04_01', true)
			###UPGRADE05
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,

    OnStopBeingBuilt = function(self,builder,layer)
        CSubUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('Torpedo01', true)
		####UPGRADE03
		self:SetWeaponEnabledByLabel('TorpedoEMP01', false)
		self.WeaponsEnabled = true
		
		self:DisableUnitIntel('SonarStealth')
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,	

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				self:ShowBone('Upgrade01_01', true)	
			
				local wep1 = self:GetWeaponByLabel('Torpedo01')  				
				wep1:ChangeRateOfFire(0.7)
				
				hasHEBI = true    
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        #MaxHealth = {
                        #    Add = 40,
                        #    Mult = 1,
                        #},
						Health = {
                            Add = 100,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				
				local wep = self:GetWeaponByLabel('Torpedo01')  				
				wep:ChangeRateOfFire(bp.NewRateOfFire or 0.8)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        #MaxHealth = {
                        #    Add = 40,
                        #    Mult = 1,
                        #},
						Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				self:ShowBone('Upgrade03_01', true)
				self:SetSpeedMult(bp.Physics.Upgrade02SpeedMultiplier)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        #MaxHealth = {
                        #    Add = 40,
                        #    Mult = 1,
                        #},
						Health = {
                            Add = 200,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
			self:ShowBone('Upgrade04_01', true)
			
			self:AddToggleCap('RULEUTC_CloakToggle')
			self:EnableUnitIntel('SonarStealth')
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        #MaxHealth = {
                        #    Add = 40,
                        #    Mult = 1,
                        #},
						Health = {
                            Add = 250,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		#####################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				self:ShowBone('Upgrade05_01', true)
					
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
            end
		end
	end,		

	OnKilled = function(self, instigator, type, overkillRatio)
	CSubUnit.OnKilled(self, instigator, type, overkillRatio)
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if not bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
		if enh =='VeterancyV' then
			--self:Destroy()	
			end
		end			
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
		if enh =='VeterancyV' then
			local bp = self:GetBlueprint()
			local buildUnit = bp.Economy.BuildUnit   
			local pos = self:GetPosition()
			local aiBrain = self:GetAIBrain()		
			ForkThread(function()
			self:CreateProjectile( MyModPath .. '/hook/effects/entities/CybranRelife/CybranRelife_proj.bp', 0, 0, 0, nil, nil, nil):SetCollision(false)
			
			WaitSeconds(6.5)			
			CreateUnitHPR(
				buildUnit,
				aiBrain.Name,
				pos[1], pos[2], pos[3],
				0, 0, 0
			)	
			self:Destroy()
			end)
			
			end
		end
		
    end,		
}

TypeClass = URS0204