#****************************************************************************
#**
#**  File     :  /data/units/XSA0102/XSA0102_script.lua
#**  Author(s):  Jessica St. Croix, Greg Kohne, Aaron Lundquist
#**
#**  Summary  :  Seraphim Interceptor Script
#**
#**  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


local SAirUnit = import( MyModPath .. '/hook/lua/seraphimunits.lua').SAirUnit
local SeraphimWeapons = import('/lua/seraphimweapons.lua')
local SAAShleoCannonWeapon = SeraphimWeapons.SAAShleoCannonWeapon
local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

XSA0102 = Class(SAirUnit) {
    Weapons = {
        SonicPulseBattery = Class(SAAShleoCannonWeapon) {},
		###UPGRADE03GUNS###
		SonicPulseBattery02 = Class(SAAShleoCannonWeapon) {},
		SonicPulseBattery03 = Class(SAAShleoCannonWeapon) {},
    },
	
    OnCreate = function(self)
		SAirUnit.OnCreate(self)
			self:HideBone('Upgrade01_01', true)  
			self:HideBone('Upgrade02_01', true)
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
    OnStopBeingBuilt = function(self, builder, layer)
        SAirUnit.OnStopBeingBuilt(self,builder,layer)
	        self:SetWeaponEnabledByLabel('SonicPulseBattery', true)
	        self:SetWeaponEnabledByLabel('SonicPulseBattery02', false)  
			self:SetWeaponEnabledByLabel('SonicPulseBattery03', false)
       self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				self:ShowBone('Upgrade01_01', true)
				
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				
				local wep1 = self:GetWeaponByLabel('SonicPulseBattery')
				local wep2 = self:GetWeaponByLabel('SonicPulseBattery02')
				local wep3 = self:GetWeaponByLabel('SonicPulseBattery03')
				wep1:ChangeMaxRadius(bp.NewMaxRadius or 27)
				wep2:ChangeMaxRadius(bp.NewMaxRadius or 27)
				wep3:ChangeMaxRadius(bp.NewMaxRadius or 27)
				
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 50,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)
				
				self:SetSpeedMult(bp.Physics.Upgrade02SpeedMultiplier)
				
				local wep1 = self:GetWeaponByLabel('SonicPulseBattery')
				local wep2 = self:GetWeaponByLabel('SonicPulseBattery02')
				local wep3 = self:GetWeaponByLabel('SonicPulseBattery03')
				wep1:ChangeMaxRadius(bp.NewMaxRadius or 29)
				wep2:ChangeMaxRadius(bp.NewMaxRadius or 29)
				wep3:ChangeMaxRadius(bp.NewMaxRadius or 29)
				
				wep1:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod) 
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 100,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
			
				self:SetWeaponEnabledByLabel('SonicPulseBattery02', true)  
				self:SetWeaponEnabledByLabel('SonicPulseBattery03', true)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				self.Effect1 = CreateAttachedEmitter(self,'Effect01',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Trash:Add(self.Effecct1)
				self.Effect2 = CreateAttachedEmitter(self,'Effect02',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Trash:Add(self.Effecct2)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
							Regen = {
                            Add = 10,
                            Mult = 1,
                        },					
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end		
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
			
				self:ShowBone('Upgrade05_01', true)
				
				self:SetSpeedMult(bp.Physics.Upgrade02SpeedMultiplier)
				
				local wep1 = self:GetWeaponByLabel('SonicPulseBattery')
				local wep2 = self:GetWeaponByLabel('SonicPulseBattery02')
				local wep3 = self:GetWeaponByLabel('SonicPulseBattery03')
				wep1:ChangeMaxRadius(bp.NewMaxRadius or 31)
				wep2:ChangeMaxRadius(bp.NewMaxRadius or 31)
				wep3:ChangeMaxRadius(bp.NewMaxRadius or 31)
				
				wep1:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod) 
				wep2:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod) 
				wep3:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod) 
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 50,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 200,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
end,		
	
}

TypeClass = XSA0102