#****************************************************************************
#**
#**  File     :  /cdimage/units/DEA0202/DEA0202_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix, Matt Vainio
#**
#**  Summary  :  UEF Supersonic Fighter Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local TAirUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TAirUnit

local TAirToAirLinkedRailgun = import('/lua/terranweapons.lua').TAirToAirLinkedRailgun
local TIFCarpetBombWeapon = import('/lua/terranweapons.lua').TIFCarpetBombWeapon

###UPGRADE04
local TSAMLauncher = import('/lua/terranweapons.lua').TSAMLauncher

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false


DEA0202 = Class(TAirUnit) {
    Weapons = {
        RightBeam = Class(TAirToAirLinkedRailgun) {},
        LeftBeam = Class(TAirToAirLinkedRailgun) {},
        Bomb = Class(TIFCarpetBombWeapon) {

            IdleState = State (TIFCarpetBombWeapon.IdleState) {
                Main = function(self)
                    TIFCarpetBombWeapon.IdleState.Main(self)
                end,
                
                OnGotTarget = function(self)
                    self.unit:SetBreakOffTriggerMult(2.0)
                    self.unit:SetBreakOffDistanceMult(8.0)
                   -- self.unit:SetSpeedMult(0.67)
                    TIFCarpetBombWeapon.IdleState.OnGotTarget(self)
                end,
                OnFire = function(self)
                    self.unit:RotateWings(self:GetCurrentTarget())
                    TIFCarpetBombWeapon.IdleState.OnFire(self)
                end,                
            },
            
            OnFire = function(self)
                self.unit:RotateWings(self:GetCurrentTarget())
                TIFCarpetBombWeapon.OnFire(self)
            end,
                    
            OnGotTarget = function(self)
                self.unit:SetBreakOffTriggerMult(2.0)
                self.unit:SetBreakOffDistanceMult(8.0)
                --self.unit:SetSpeedMult(0.67)
                TIFCarpetBombWeapon.OnGotTarget(self)
            end,
        
            OnLostTarget = function(self)
                self.unit:SetBreakOffTriggerMult(1.0)
                self.unit:SetBreakOffDistanceMult(1.0)
               -- self.unit:SetSpeedMult(1.0)
                TIFCarpetBombWeapon.OnLostTarget(self)
            end,        
        },
		###UPGRADE02
		RightBeam01 = Class(TAirToAirLinkedRailgun) {},
        LeftBeam02 = Class(TAirToAirLinkedRailgun) {},
		Bomb01 = Class(TIFCarpetBombWeapon) {},
		########UPGRADE04
		MissileRack01 = Class(TSAMLauncher) {},
    },
    
    
    RotateWings = function(self, target)
        if not self.LWingRotator then
            self.LWingRotator = CreateRotator(self, 'Left_Wing', 'y')
            self.Trash:Add(self.LWingRotator)

        end
		if not self.L01WingRotator then
            self.L01WingRotator = CreateRotator(self, 'Upgrade01_02', 'y')
            self.Trash:Add(self.L01WingRotator)

        end
        if not self.RWingRotator then
            self.RWingRotator = CreateRotator(self, 'Right_Wing', 'y')
            self.Trash:Add(self.RWingRotator)
        end
		if not self.R01WingRotator then
            self.R01WingRotator = CreateRotator(self, 'Upgrade01_01', 'y')
            self.Trash:Add(self.R01WingRotator)
        end
		
        local fighterAngle = -105
        local bomberAngle = 0
        local wingSpeed = 45
        if target and EntityCategoryContains(categories.AIR, target) then
            if self.LWingRotator then
                self.LWingRotator:SetSpeed(wingSpeed)
                self.LWingRotator:SetGoal(-fighterAngle)
            end
			
			if self.L01WingRotator then
                self.L01WingRotator:SetSpeed(wingSpeed)
                self.L01WingRotator:SetGoal(-fighterAngle)
            end
			
            if self.RWingRotator then
                self.RWingRotator:SetSpeed(wingSpeed)
                self.RWingRotator:SetGoal(fighterAngle)
            end
			
			if self.R01WingRotator then
                self.R01WingRotator:SetSpeed(wingSpeed)
                self.R01WingRotator:SetGoal(fighterAngle)
            end
        else
            if self.LWingRotator then
                self.LWingRotator:SetSpeed(wingSpeed)
                self.LWingRotator:SetGoal(-bomberAngle)
            end
			
			if self.L01WingRotator then
                self.L01WingRotator:SetSpeed(wingSpeed)
                self.L01WingRotator:SetGoal(-bomberAngle)
            end
			
            if self.RWingRotator then
                self.RWingRotator:SetSpeed(wingSpeed)
                self.RWingRotator:SetGoal(bomberAngle)
            end   

			if self.R01WingRotator then
                self.R01WingRotator:SetSpeed(wingSpeed)
                self.R01WingRotator:SetGoal(bomberAngle)
            end     
			
        end  
    end,
    
    OnCreate = function(self)
        TAirUnit.OnCreate(self)
        self:ForkThread(self.MonitorWings)
		###UPGRADE01
		self:HideBone('Upgrade01_01', true)
		self:HideBone('Upgrade01_02', true)
		###UPGRADE02
		self:HideBone('Upgrade02_01', true)
		###UPGRADE03
		self:HideBone('Upgrade03_01', true)
		###UPGRADE04 
		self:HideBone('Upgrade04_01', true)
		###UPGRADE05 
		self:HideBone('Upgrade05_01', true)
		self.hasHEBI = false
		self.hasHEBII = false
		self.hasHEBIII = false
		self.hasHEBIV = false
		self.hasHEBV = false	
    end,
    
    MonitorWings = function(self)
        local airTargetRight
        local airTargetLeft
        while self and not self:IsDead() do
            WaitSeconds(1)
            local airTargetWeapon = self:GetWeaponByLabel('RightBeam')
            if airTargetWeapon then     
                airTargetRight = airTargetWeapon:GetCurrentTarget()
            end
            airTargetWeapon = self:GetWeaponByLabel('LeftBeam')
            if airTargetWeapon then
                airTargetLeft = airTargetWeapon:GetCurrentTarget()
            end
            
            if airTargetRight then
                self:RotateWings(airTargetRight)              
            elseif airTargetLeft then
                self:RotateWings(airTargetLeft)             
            else
                self:RotateWings(nil)
            end
        end
    end,
	
    OnStopBeingBuilt = function(self, builder,layer)
        TAirUnit.OnStopBeingBuilt(self, builder,layer)
		self:SetWeaponEnabledByLabel('RightBeam', true)
		self:SetWeaponEnabledByLabel('LeftBeam', true)
		self:SetWeaponEnabledByLabel('Bomb', true)
		###UPGRADE02
		self:SetWeaponEnabledByLabel('RightBeam01', false)
		self:SetWeaponEnabledByLabel('LeftBeam01', false)
		self:SetWeaponEnabledByLabel('Bomb01', false)
		####UPGRADE04
		self:SetWeaponEnabledByLabel('MissileRack01', false)
		
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 			
    end,	

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then	
			
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				
				
				local wep = self:GetWeaponByLabel('RightBeam')
				wep:ChangeMaxRadius(34)
				
				local wep2 = self:GetWeaponByLabel('LeftBeam')
				wep2:ChangeMaxRadius(34)
				
				local wep3 = self:GetWeaponByLabel('RightBeam01')
				wep3:ChangeMaxRadius(34)
				
				local wep4 = self:GetWeaponByLabel('LeftBeam01')
				wep4:ChangeMaxRadius(34)
				
				local wep5 = self:GetWeaponByLabel('MissileRack01')
				wep5:ChangeMaxRadius(34)
				
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false			
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 67,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 100,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
			
				
				self:ShowBone('Upgrade02_01', true)
				
				self:SetWeaponEnabledByLabel('RightBeam01', true)
				self:SetWeaponEnabledByLabel('LeftBeam01', true)
				self:SetWeaponEnabledByLabel('Bomb01', true)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then	
				self:ShowBone('Upgrade03_01', true)
				
				local wep = self:GetWeaponByLabel('RightBeam')
				wep:AddDamageMod(bpEnh.AAIDamageMod)
				
				local wep2 = self:GetWeaponByLabel('LeftBeam')
				wep2:AddDamageMod(bpEnh.AAIDamageMod)
				
				local wep3 = self:GetWeaponByLabel('RightBeam01')
				wep3:AddDamageMod(bpEnh.AAIDamageMod)
				
				local wep4 = self:GetWeaponByLabel('LeftBeam01')
				wep4:AddDamageMod(bpEnh.AAIDamageMod)
				
				local wep5 = self:GetWeaponByLabel('Bomb')
				wep5:AddDamageMod(bpEnh.BombIDamageMod)
				
				local wep6 = self:GetWeaponByLabel('Bomb01')
				wep6:AddDamageMod(bpEnh.BombIDamageMod)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		

                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 172,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 250,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:SetWeaponEnabledByLabel('MissileRack01', true)
				self:ShowBone('Upgrade04_01', true)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then	
				self:ShowBone('Upgrade05_01', true)
				hasHEBI = true  
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 500,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 350,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end		
	end,	
	
}

TypeClass = DEA0202