#****************************************************************************
#**
#**  File     :  /cdimage/units/DRL0204/DRL0204_script.lua
#**  Author(s):  Dru Staltman, Eric Williamson, Gordon Duclos
#**
#**  Summary  :  Cybran Rocket Bot Script
#**
#**  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#######################################################################
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#######################################################################
local CWalkingLandUnit = import( MyModPath .. '/hook/lua/cybranunits.lua' ).CWalkingLandUnit

#########UPGRADE04
local CAANanoDartWeapon = import('/lua/cybranweapons.lua').CAANanoDartWeapon

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false


DRL0204 = Class(CWalkingLandUnit){
    Weapons = {
        RocketBackpack = Class(import('/lua/cybranweapons.lua').CDFRocketIridiumWeapon02) {},
		####UPGRADE02
		RocketBackpackupgrade = Class(import('/lua/cybranweapons.lua').CDFRocketIridiumWeapon02) {},
		#########UPGRADE04
		AAGun01 = Class(CAANanoDartWeapon) {},
    },
	
    OnCreate = function(self)
		CWalkingLandUnit.OnCreate(self)
			####UPGRADE01
			self:HideBone('Upgrade01_01', true)
			self:HideBone('Upgrade01_02', true)
			self:HideBone('Upgrade01_03', true)
			self:HideBone('Upgrade01_04', true)
			self:HideBone('Upgrade01_05', true)
			self:HideBone('Upgrade01_06', true)
			self:HideBone('Upgrade01_07', true)
			self:HideBone('Upgrade01_08', true)
			self:HideBone('Upgrade01_09', true)
			self:HideBone('Upgrade01_10', true)
			self:HideBone('Upgrade01_11', true)
			####UPGRADE02
			self:HideBone('Upgrade02_01', true)
			####UPGRADE03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true)
			self:HideBone('Upgrade03_03', true)
			self:HideBone('Upgrade03_04', true)
			self:HideBone('Upgrade03_05', true)
			self:HideBone('Upgrade03_06', true)
			self:HideBone('Upgrade03_07', true)
			self:HideBone('Upgrade03_08', true)
			self:HideBone('Upgrade03_09', true)
			self:HideBone('Upgrade03_10', true)
			self:HideBone('Upgrade03_11', true)
			self:HideBone('Upgrade03_12', true)
			self:HideBone('Upgrade03_13', true)
			self:HideBone('Upgrade03_14', true)
			self:HideBone('Upgrade03_15', true)
			####UPGRADE04
			self:HideBone('Upgrade04_01', true)
			####UPGRADE05
			self:HideBone('Upgrade05_01', true)
			self:HideBone('Upgrade05_02', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,

    OnStopBeingBuilt = function(self,builder,layer)
        CWalkingLandUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('RocketBackpack', true)
		###UPGRADE 02
		self:SetWeaponEnabledByLabel('RocketBackpackupgrade', false)
		####UPGRADE 04
		self:SetWeaponEnabledByLabel('AAGun01', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,		
	
	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				self:ShowBone('Upgrade01_03', true)
				self:ShowBone('Upgrade01_04', true)
				self:ShowBone('Upgrade01_05', true)
				self:ShowBone('Upgrade01_06', true)
				self:ShowBone('Upgrade01_07', true)
				self:ShowBone('Upgrade01_08', true)
				self:ShowBone('Upgrade01_09', true)
				self:ShowBone('Upgrade01_10', true)
				self:ShowBone('Upgrade01_11', true)
				
				local wep = self:GetWeaponByLabel('RocketBackpack')
    		    wep:ChangeRateOfFire(0.35)   
				
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				
				hasHEBI = true 
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 300,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)
				
				self:HideBone('Upgrade03_12', true)
				self:HideBone('Upgrade03_13', true)
				
				self:SetWeaponEnabledByLabel('RocketBackpackupgrade', true)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 400,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end			
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				self:ShowBone('Upgrade03_03', true)
				self:ShowBone('Upgrade03_04', true)
				self:ShowBone('Upgrade03_05', true)
				self:ShowBone('Upgrade03_06', true)
				self:ShowBone('Upgrade03_07', true)
				self:ShowBone('Upgrade03_08', true)
				self:ShowBone('Upgrade03_09', true)
				self:ShowBone('Upgrade03_10', true)
				self:ShowBone('Upgrade03_11', true)
				self:ShowBone('Upgrade03_12', true)
				self:ShowBone('Upgrade03_13', true)
				self:ShowBone('Upgrade03_14', true)
				self:ShowBone('Upgrade03_15', true)
				self:SetSpeedMult(bp.Physics.Upgrade02SpeedMultiplier)
				
				local wep1 = self:GetWeaponByLabel('RocketBackpack')
				wep1:AddDamageMod(bpEnh.RocketIDamageMod)
				
				local wep2 = self:GetWeaponByLabel('RocketBackpackupgrade')
				wep2:AddDamageMod(bpEnh.RocketIDamageMod)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end		
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				
				self:SetWeaponEnabledByLabel('AAGun01', true)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end		
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				self:ShowBone('Upgrade05_01', true)
				self:ShowBone('Upgrade05_02', true)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
			end
		end				
end,		

	OnKilled = function(self, instigator, type, overkillRatio)
	CWalkingLandUnit.OnKilled(self, instigator, type, overkillRatio)
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if not bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
		if enh =='VeterancyV' then
			--self:Destroy()	
			end
		end			
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
		if enh =='VeterancyV' then
			local bp = self:GetBlueprint()
			local buildUnit = bp.Economy.BuildUnit   
			local pos = self:GetPosition()
			local aiBrain = self:GetAIBrain()		
			
			ForkThread(function()
			self:CreateProjectile( MyModPath .. '/hook/effects/entities/CybranRelife/CybranRelife_proj.bp', 0, 0, 0, nil, nil, nil):SetCollision(false)
			
			WaitSeconds(6.5)			
			CreateUnitHPR(
				buildUnit,
				aiBrain.Name,
				pos[1], pos[2], pos[3],
				0, 0, 0
			)	
			self:Destroy()
			end)
			
			end
		end
		
    end,
	
}
TypeClass = DRL0204
