#****************************************************************************
#**
#**  File     :  /cdimage/units/UAL0202/UAL0202_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix, Gordon Duclos
#**
#**  Summary  :  Aeon Heavy Tank Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local ALandUnit = import( MyModPath .. '/hook/lua/aeonunits.lua' ).ALandUnit

local Shield = import('/lua/shield.lua').Shield

local ADFCannonQuantumWeapon = import('/lua/aeonweapons.lua').ADFCannonQuantumWeapon
local Buff = import('/lua/sim/Buff.lua')

local EffectTemplate = import('/lua/EffectTemplates.lua')
local EffectUtil = import('/lua/EffectUtilities.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UAL0202 = Class( ALandUnit ) {

    Weapons = {
        MainGun = Class(ADFCannonQuantumWeapon) {},
		###UPGRADE02
		UpgradeGun = Class(ADFCannonQuantumWeapon) {},
		###UPGRADE04
		UpgradeGun02 = Class(ADFCannonQuantumWeapon) {},
		UpgradeGun03 = Class(ADFCannonQuantumWeapon) {},
    },

    OnCreate = function(self)
		ALandUnit.OnCreate(self)
			self:HideBone('Upgrade01_01', true)
			########UPGRADE 02
			self:HideBone('Upgrade02_01', true)
			########UPGRADE 03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true)
			########UPGRADE 04
			self:HideBone('Upgrade04_01', true)
			########UPGRADE 05
			self:HideBone('Upgrade05_01', true)
			self:HideBone('Upgrade05_02', true)
			self:HideBone('Upgrade05_03', true)
			self:HideBone('Upgrade05_04', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,

    OnStopBeingBuilt = function(self,builder,layer)
        ALandUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('MainGun', true)
		####UPGRADE 02
		self:SetWeaponEnabledByLabel('UpgradeGun', false)
		####UPGRADE 04
		self:SetWeaponEnabledByLabel('UpgradeGun02', false)
		self:SetWeaponEnabledByLabel('UpgradeGun03', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,		

	#Level#
	OnVeteran = function ( self, enh )
	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				self:ShowBone('Upgrade01_01', true)								
			
				local wep = self:GetWeaponByLabel('MainGun') 
				wep:ChangeMaxRadius(22)
				wep:AddDamageMod(bpEnh.BolterIDamageMod)
				local wep2 = self:GetWeaponByLabel('UpgradeGun')
				wep2:ChangeMaxRadius(22)
				
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 300,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)	
				
				self:HideBone('Upgrade03_02', true)	
				
				self:SetWeaponEnabledByLabel('UpgradeGun', true)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 400,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
			
				local wep = self:GetWeaponByLabel('MainGun') 
				wep:ChangeMaxRadius(26)
				local wep2 = self:GetWeaponByLabel('UpgradeGun')
				wep2:ChangeMaxRadius(26)
			
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				
				self:SetWeaponEnabledByLabel('UpgradeGun02', true)
				self:SetWeaponEnabledByLabel('UpgradeGun03', true)
				local wep1 = self:GetWeaponByLabel('UpgradeGun02')
				wep1:ChangeMaxRadius(26)
				local wep3 = self:GetWeaponByLabel('UpgradeGun03')
				wep3:ChangeMaxRadius(26)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
			self:ShowBone('Upgrade05_01', true)	
			self:ShowBone('Upgrade05_02', true)	
			self:ShowBone('Upgrade05_03', true)	
			self:ShowBone('Upgrade05_04', true)	
				ForkThread(function()
				self:DestroyShield()
                WaitTicks(1)
                self:CreateShield(bpEnh)
                self:SetEnergyMaintenanceConsumptionOverride(bpEnh.MaintenanceConsumptionPerSecondEnergy or 0)
                self:SetMaintenanceConsumptionActive()
            end)
			self.Trash:Add(CreateRotator(self, 'Upgrade05_01', 'z', nil, 100, 0, 100))
			self.Trash:Add(CreateRotator(self, 'Upgrade05_02', 'z', nil, 100, 0, 100))
			self.Trash:Add(CreateRotator(self, 'Upgrade05_03', 'z', nil, 100, 0, 100))
			self.Trash:Add(CreateRotator(self, 'Upgrade05_04', 'z', nil, 100, 0, 100))
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
            end
		end			
	end,		
    
}

TypeClass = UAL0202
